%def_disable check
%define _unpackaged_files_terminate_build 1
%define _localstatedir %_var

%add_findreq_skiplist %_x11sysconfdir/xinit.d/*
%add_findreq_skiplist %_kernel_installdir/*
%add_findreq_skiplist %_unitdir/local.service
%add_findreq_skiplist %_unitdir/rc-local.service
%add_findreq_skiplist %_unitdir/quotaon.service
%add_findreq_skiplist %_unitdir/initrd-switch-root.service
%add_findreq_skiplist %_unitdir/systemd-volatile-root.service
%add_findreq_skiplist %_unitdir/altlinux-libresolv.service
%add_findreq_skiplist %_unitdir/altlinux-openresolv.service

%def_disable static_libsystemd
%def_disable static_libudev
%def_enable elfutils
%def_enable libcryptsetup
%ifnarch ppc64le loongarch64 riscv64 %mips32
%def_enable tpm2
%else
%def_disable tpm2
%endif
%def_enable logind
%def_enable vconsole
%def_enable vmspawn
%def_enable initrd
%def_enable quotacheck
%def_enable randomseed
%def_enable coredump
%def_enable pstore
%def_enable gcrypt
%def_enable qrencode
%def_enable microhttpd
%def_enable gnutls
%def_enable openssl
%def_enable libcurl
%def_disable libidn
%def_enable libidn2
%def_enable libiptc
%def_enable polkit
%def_enable homed
%def_enable passwdqc
%def_enable networkd
%def_enable timesyncd
%def_enable resolve
%ifarch %{ix86} x86_64 aarch64 %arm riscv32 riscv64 loongarch32 loongarch64
%def_enable efi
%def_enable bootloader
%else
%def_disable efi
%def_disable bootloader
%endif
%def_enable p11kit
%def_enable libfido2
%def_enable utmp
%def_enable xz
%def_enable zlib
%def_enable bzip2
%def_enable lz4
%def_enable zstd
%def_enable tests

%def_disable smack
%def_enable seccomp
%def_enable ima
%def_enable selinux
%def_disable apparmor

%def_enable kill_user_processes

%def_enable sysusers
%def_enable tcb
%def_disable ldconfig
%def_disable firstboot
%def_enable standalone_binaries

%if_enabled sysusers
%def_enable ldconfig
%endif

%ifnarch riscv64
%def_enable kexec
%endif

# from meson.build: bpf_arches = ['x86_64']
%ifarch x86_64
%def_disable bpf_framework
%else
%def_disable bpf_framework
%endif

%ifarch ia64 %ix86 ppc64le x86_64 aarch64
%define mmap_min_addr 65536
%else
%define mmap_min_addr 32768
%endif

%define ver_major 258

Name: systemd
Epoch: 1
Version: %ver_major.1
Release: alt1
Summary: System and Session Manager
Url: https://systemd.io/
Group: System/Configuration/Boot and Init
License: LGPLv2.1+

Source: %name-%version.tar
Source2: systemd-sysv-install
Source4: altlinux-openresolv.path
Source5: altlinux-openresolv.service
Source6: altlinux-libresolv.path
Source7: altlinux-libresolv.service
Source8: sysctl.conf
Source9: modules.conf
Source10: systemd-udev-trigger-no-reload.conf
Source11: env-path-user.conf
Source12: env-path-system.conf
Source14: systemd-user.pam
Source19: udevd.init
Source20: udevd.sysconfig
Source22: scsi_id.config
Source23: var-lock.mount
Source24: var-run.mount
Source25: 98-default-mac-none.link
Source27: altlinux-first_time.service
Source30: 49-coredump-disable.conf
# ALTLinux's default preset policy
Source34: 85-display-manager.preset
Source35: 90-default.preset
Source36: 99-default-disable.preset
Source37: 85-networkd.preset
Source38: 85-timesyncd.preset

Source44: 10-oomd-defaults.conf
Source45: 10-oomd-per-slice-defaults.conf
Source47: 10-map-count.conf

# simpleresolv
Source68: altlinux-simpleresolv.path
Source69: altlinux-simpleresolv.service

# rpm filetriggers
Source71: udev.filetrigger
Source72: udev-hwdb.filetrigger
Source73: systemd.filetrigger
Source74: systemd-tmpfiles.filetrigger
Source75: systemd-sysctl.filetrigger
Source76: systemd-binfmt.filetrigger
Source77: journal-catalog.filetrigger
Source78: systemd-sysusers.filetrigger
Source79: systemd-modules-load.filetrigger
Source80: systemd-user.filetrigger

Source81: systemd-modules-load-shared.alternatives
Source82: systemd-modules-load-standalone.alternatives
Source83: systemd-repart-shared.alternatives
Source84: systemd-repart-standalone.alternatives
Source85: systemd-shutdown-shared.alternatives
Source86: systemd-shutdown-standalone.alternatives
Source87: systemd-sysctl-shared.alternatives
Source88: systemd-sysctl-standalone.alternatives
Source89: systemd-sysusers-shared.alternatives
Source90: systemd-sysusers-standalone.alternatives
Source91: systemd-tmpfiles-shared.alternatives
Source92: systemd-tmpfiles-standalone.alternatives
Source93: systemd-busctl-shared.alternatives
Source94: systemd-busctl-standalone.alternatives

Patch1: %name-%version.patch

%define dbus_ver 1.11.0

BuildRequires(pre): rpm-build-xdg meson >= 0.62.0
BuildRequires(pre): rpm-macros-systemd >= 5
BuildRequires: glibc-kernheaders
BuildRequires: intltool >= 0.40.0
BuildRequires: gperf
BuildRequires: libcap-devel libcap-utils
BuildRequires: libpam-devel
BuildRequires: libacl-devel acl
BuildRequires: xsltproc docbook-style-xsl docbook-dtds python3-module-lxml
BuildRequires: python3(jinja2)
BuildRequires: libdbus-devel >= %dbus_ver
%{?_enable_seccomp:BuildRequires: pkgconfig(libseccomp) >= 2.3.1}
%{?_enable_selinux:BuildRequires: pkgconfig(libselinux) >= 2.1.9}
%{?_enable_apparmor:BuildRequires: pkgconfig(libapparmor)}
%{?_enable_elfutils:BuildRequires: elfutils-devel >= 0.158}
BuildRequires: libaudit-devel
%{?_enable_xz:BuildRequires: pkgconfig(liblzma)}
%{?_enable_zlib:BuildRequires: pkgconfig(zlib)}
%{?_enable_bzip2:BuildRequires: bzlib-devel}
%{?_enable_lz4:BuildRequires: pkgconfig(liblz4) >= 1.3.0}
%{?_enable_zstd:BuildRequires: pkgconfig(libzstd) >= 1.4.0}
BuildRequires: libkmod-devel >= 15 kmod
%{?_enable_kexec:BuildRequires: kexec-tools}
BuildRequires: quota
BuildRequires: pkgconfig(blkid) >= 2.24
# temporarily lower libmount version check
# util-linux 2.27.1's configure.ac still claims to be 2.27.0, which breaks our version check
BuildRequires: libmount-devel >= 2.30
BuildRequires: pkgconfig(mount) >= 2.27
BuildRequires: pkgconfig(libarchive) >= 3.0
BuildRequires: pkgconfig(xkbcommon) >= 0.3.0
BuildRequires: pkgconfig(libpcre2-8)
BuildRequires: libkeyutils-devel
BuildRequires: pkgconfig(fdisk) >= 2.32
BuildRequires: pkgconfig(bash-completion)

%{?_enable_libcryptsetup:BuildRequires: libcryptsetup-devel >= 2.0.1}
%{?_enable_tpm2:BuildRequires: libtpm2-tss-devel libssl-devel >= 1.1.0}
%{?_enable_gcrypt:BuildRequires: libgcrypt-devel >= 1.4.5 libgpg-error-devel >= 1.12}
%{?_enable_openssl:BuildRequires: pkgconfig(openssl) >= 1.1.0}
%{?_enable_p11kit:BuildRequires: pkgconfig(p11-kit-1) >= 0.23.3}
%{?_enable_libfido2:BuildRequires: pkgconfig(libfido2)}
%{?_enable_qrencode:BuildRequires: libqrencode-devel >= 3}
%{?_enable_microhttpd:BuildRequires: pkgconfig(libmicrohttpd) >= 0.9.33}
%{?_enable_gnutls:BuildRequires: pkgconfig(gnutls) >= 3.1.4}
%{?_enable_libcurl:BuildRequires: pkgconfig(libcurl) >= 7.32.0}
%{?_enable_libidn:BuildRequires: pkgconfig(libidn)}
%{?_enable_libidn2:BuildRequires: pkgconfig(libidn2) >= 2.0.0}
%{?_enable_libiptc:BuildRequires: pkgconfig(libiptc)}
%{?_enable_polkit:BuildRequires: pkgconfig(polkit-gobject-1)}
%{?_enable_bootloader:BuildRequires: python3-module-elftools}
%{?_enable_pstore:BuildRequires: libacl-devel libdw-devel liblzma-devel liblz4-devel}
%{?_enable_passwdqc:BuildRequires: pkgconfig(passwdqc)}
%{?_enable_bpf_framework:BuildRequires: pkgconfig(libbpf) >= 0.1.0 /usr/bin/clang /usr/bin/llvm-strip bpftool}
%{?_enable_tcb:BuildRequires: libtcb-devel}
# for make check
#BuildRequires: /proc
#BuildRequires: lz4
# for tests
%{?_enable_tests:BuildRequires: rpm-build-python3 diffutils}

Requires: dbus >= %dbus_ver
Conflicts: filesystem < 3
Requires: filesystem >= 2.3.10-alt1
Requires: %name-filesystem = %EVR
Requires: agetty
Requires: acl
Requires: util-linux >= 2.27.1
%{?_enable_seccomp:Requires: libseccomp >= 2.3.1}
%{?_enable_libidn:Requires: libidn >= 1.33-alt2}
%{?_enable_libidn2:Requires: libidn2 > 2.0.4-alt3}

# Requires: selinux-policy >= 3.8.5
%{?_enable_efi:Requires: %name-boot-efi = %EVR}
Requires: libnss-myhostname = %EVR
Requires: libnss-systemd = %EVR

Provides: %name-utils = %EVR
Obsoletes: %name-utils < %EVR
Provides: %name-services = %EVR
Obsoletes: %name-services < %EVR

#utils
Provides: /sbin/systemctl /bin/systemctl /usr/bin/systemctl /usr/sbin/systemctl
Provides: /bin/journalctl
Provides: /sbin/journalctl
Provides: /sbin/systemd-modules-load /sbin/systemd-shutdown /sbin/systemd-sysctl /sbin/systemd-sysusers
Provides: /sbin/systemd-sysusers /sbin/systemd-tmpfiles
Provides: /lib/systemd/systemd-reply-password /lib/systemd/systemd-logind /lib/systemd/systemd-vconsole-setup
Provides: /lib/systemd/systemd-update-helper
Provides: journalctl = %EVR
Obsoletes: journalctl < %EVR
Obsoletes: libsystemd-shared < %EVR
Obsoletes: bash-completion-%name < %EVR
Obsoletes: bash-completion-journalctl < %EVR
Obsoletes: zsh-completion-%name < %EVR
Obsoletes: zsh-completion-journalctl < %EVR
Requires: %name-utils-filetriggers = %EVR
Requires: %name-tmpfiles-common = %EVR
Requires: %name-sysctl-common = %EVR
Requires: %name-modules-common = %EVR

Obsoletes: systemd-units < 0:43-alt1
Provides: systemd-units = %EVR
Provides: syslogd-daemon

# services
Requires: pam_%name = %EVR
Requires: dbus >= %dbus_ver
Conflicts: service <= 0.5.25-alt1
Conflicts: chkconfig <= 1.3.59-alt3
Conflicts: ConsoleKit2 ConsoleKit2-x11

# Copy from SysVinit
Requires: coreutils
Requires: /sbin/sulogin
Requires: sysvinit-utils

# Obsoletes: SysVinit
Provides: %name-sysvinit = %EVR
Obsoletes: %name-sysvinit < 1:255.7-alt1
#Obsoletes:      upstart
Conflicts: upstart
Conflicts: SysVinit
Provides: /sbin/init /sbin/reboot /sbin/halt /sbin/poweroff /sbin/shutdown

# SBAT generation number for ALT (refer to SBAT.md)
%define sbat_distro altlinux
%define sbat_distro_generation 1
%define sbat_distro_summary "ALT Linux"
%define sbat_distro_pkgname systemd-boot-efi
%define sbat_distro_version %version-%release
%define sbat_distro_url http://git.altlinux.org/gears/s/systemd.git

%description
systemd is a system and session manager for Linux, compatible with
SysV and LSB init scripts. systemd provides aggressive parallelization
capabilities, uses socket and D-Bus activation for starting services,
offers on-demand starting of daemons, keeps track of processes using
Linux cgroups, supports snapshotting and restoring of the system
state, maintains mount and automount points and implements an
elaborate transactional dependency-based service control logic. It can
work as a drop-in replacement for sysvinit.

%package filesystem
Group: System/Base
Summary: The basic directory layout for systemd
BuildArch: noarch
Requires: filesystem

%description filesystem
%summary.

%package -n libsystemd
Group: System/Libraries
Summary: Systemd Library

%description -n libsystemd
The libsystemd library provides a reference implementation of various
APIs for new-style daemons, as implemented by the systemd init system.

%package -n libsystemd-devel
Group: Development/C
Summary: Development headers for systemd Library
License: LGPLv2+ and MIT

Requires: libsystemd = %EVR

Provides: libsystemd-daemon-devel = %EVR
Provides: libsystemd-journal-devel = %EVR
Provides: libsystemd-login-devel = %EVR
Provides: libsystemd-id128-devel = %EVR
Provides: systemd-devel = %EVR

Obsoletes: libsystemd-daemon-devel < %EVR
Obsoletes: libsystemd-journal-devel < %EVR
Obsoletes: libsystemd-login-devel < %EVR
Obsoletes: libsystemd-id128-devel < %EVR
Obsoletes: systemd-devel < %EVR

%description -n libsystemd-devel
The libsystemd library provides a reference implementation of various
APIs for new-style daemons, as implemented by the systemd init system.

%package -n libsystemd-devel-static
Group: Development/C
Summary: Development static libraries for systemd
License: LGPLv2+ and MIT

%description -n libsystemd-devel-static
Static Library files for doing development with the systemd.

%package -n libnss-systemd
Group: System/Libraries
Summary: nss-systemd providing UNIX user and group name resolution for dynamic users and groups
Requires(pre): chrooted >= 0.3.5-alt1 sed
Requires(postun): chrooted >= 0.3.5-alt1 sed
# Requires: systemd

%description -n libnss-systemd
nss-systemd is a plug-in module for the GNU Name Service Switch (NSS) functionality of the
GNU C Library glibc, providing UNIX user and group name resolution for dynamic users and
groups allocated through the DynamicUser= option in systemd unit files.

This module also ensures that the root and nobody users and groups (i.e. the users/groups with the UIDs/GIDs
0 and 65534) remain resolvable at all times, even if they aren't listed in /etc/passwd or
/etc/group, or if these files are missing.

To activate the NSS module, add systemd to the lines starting with
passwd: and group: in /etc/nsswitch.conf.

passwd: files systemd
group: files systemd

%package -n libnss-myhostname
Group: System/Libraries
Summary: nss-myhostname provide hostname resolution for the locally configured system hostname
Requires(pre): chrooted >= 0.3.5-alt1 sed
Requires(postun): chrooted >= 0.3.5-alt1 sed

%description -n libnss-myhostname
nss-myhostname is a plugin for the GNU Name Service Switch (NSS)
functionality of the GNU C Library (glibc) providing host name
resolution for the locally configured system hostname as returned by
gethostname(2). Various software relies on an always resolvable local
host name. When using dynamic hostnames this is usually achieved by
patching /etc/hosts at the same time as changing the host name. This
however is not ideal since it requires a writable /etc file system and
is fragile because the file might be edited by the administrator at
the same time. nss-myhostname simply returns all locally configure
public IP addresses, or -- if none are configured -- the IPv4 address
127.0.0.2 (wich is on the local loopback) and the IPv6 address ::1
(which is the local host) for whatever system hostname is configured
locally. Patching /etc/hosts is thus no longer necessary.

It is necessary to change "hosts" in /etc/nsswitch.conf to
hosts: files myhostname

%package -n libnss-mymachines
Group: System/Libraries
Summary: libnss-mymachines is plugin for local system host name resolution
Requires(pre): chrooted >= 0.3.5-alt1 chrooted-resolv sed
Requires(postun): chrooted >= 0.3.5-alt1 sed
Requires: dbus >= %dbus_ver
Requires: systemd-container

%description -n libnss-mymachines
nss-mymachines for automatically resolves the names
of all local registered containers to their respective IP addresses.

It is necessary to change "hosts" in /etc/nsswitch.conf to
hosts: files mymachines

%package -n libnss-resolve
Group: System/Libraries
Summary: nss-resolve is plugin for resolve hostnames via systemd-resolved
Requires(pre): chrooted >= 0.3.5-alt1 sed
Requires(postun): chrooted >= 0.3.5-alt1 sed
Requires: dbus >= %dbus_ver
Requires: %name-networkd = %EVR

%description -n libnss-resolve
NSS module "nss-resolve" has been added which can be used
instead of glibc's own "nss-dns" to resolve hostnames via
systemd-resolved. Hostnames, addresses and arbitrary RRs may
be resolved via systemd-resolved D-Bus APIs. In contrast to
the glibc internal resolver systemd-resolved is aware of
multi-homed system, and keeps DNS server and caches separate
and per-interface.

It is necessary to change "hosts" in /etc/nsswitch.conf to
hosts: files resolve

%package -n pam_%name
Group: System/Base
Summary: Register user sessions in the systemd login manager
Requires: dbus >= %dbus_ver
Conflicts: %name < 1:216-alt1

%description -n pam_%name
pam_systemd registers user sessions with the systemd login manager
systemd-logind.service, and hence the systemd control group hierarchy.

%package -n pam_%{name}_home
Group: System/Base
Summary: Automatically mount home directories managed by systemd-homed.service on login
Requires: dbus >= %dbus_ver

%description -n pam_%{name}_home
pam_systemd_home ensures that home directories managed by systemd-homed.service
are automatically activated (mounted) on user login,
and are deactivated (unmounted) when the last session of the user ends.

%package networkd
Group: System/Base
Summary: System daemon that manages network configurations
Conflicts: %name < 1:214-alt13
Requires: %name = %EVR
Requires: iproute2
Provides: network-config-subsystem

%description networkd
systemd-networkd is a system service that manages networks.
It detects and configures network devices as they appear,
as well as creating virtual network devices.

%package oomd-defaults
Group: System/Base
Summary: Configuration files for systemd-oomd
BuildArch: noarch
Requires: %name = %EVR

%description oomd-defaults
A set of drop-in files for systemd units to enable action from systemd-oomd,
a userspace out-of-memory (OOM) killer.

%package timesyncd
Group: System/Configuration/Other
Summary: Network Time Synchronization
Conflicts: %name < 1:214-alt13
Requires: %name-networkd = %EVR
Provides: ntp-client
# temporary disabled
# Provides: ntp-server

%description timesyncd
systemd-timesyncd is a system service that may be used
to synchronize the local system clock with a Network Time Protocol Server.

%package container
Summary: Tools for containers and VMs
Group: System/Configuration/Other
Requires: %name = %EVR
#Requires: libnss-mymachines = %%EVR
Provides: /lib/systemd/systemd-machined

%description container
Systemd tools to spawn and manage containers and virtual machines.

This package contains systemd-nspawn, systemd-vmspawn, machinectl,
systemd-machined, and systemd-importd.

%package portable
Summary: Tools for Portable Services
Group: System/Configuration/Other
Requires: %name = %EVR

%description portable
A portable service is ultimately just an OS tree, either inside of a directory
tree, or inside a raw disk image containing a Linux file system.

%package homed
Summary: Home Directory/User Account Manager
Group: System/Configuration/Other
Requires: %name = %EVR
Requires: pam_%{name}_home = %EVR

%description homed
systemd-homed is a system service that may be used
to create, remove, change or inspect home directories.

%package analyze
Group: System/Configuration/Boot and Init
Summary: Analyze tool for systemd.
Requires: %name = %EVR

%description analyze
Analyze tool for systemd.

%package journal-remote
Group: System/Servers
Summary: Journal Gateway Daemon
Requires: %name = %EVR
Provides: systemd-journal-gateway = %EVR
Obsoletes: systemd-journal-gateway < %EVR

%description journal-remote
This service provides access to the journal via HTTP and JSON.

%package boot-efi
Group: System/Kernel and hardware
Summary: systemd-boot and bootctl utils

%description boot-efi
systemd-boot and bootctl utils.

%package boot-efi-checkinstall
Group: System/Kernel and hardware
Summary: Verify systemd-boot EFI signature
Requires: %name-boot-efi = %EVR
Requires(post): rpm-pesign-checkinstall

%description boot-efi-checkinstall
systemd-boot and bootctl utils.

This package enables EFI signature verification.

%package ukify
Group: System/Kernel and hardware
Summary: Tool to build Unified Kernel Images
Requires: %name = %EVR
#BuildArch: noarch
BuildRequires: python3(pefile) python3(PIL) python3(zstd)
%py3_requires pefile PIL zstd

%description ukify
This package provides ukify, a script that combines a kernel image, an initrd,
with a command line, and possibly PCR measurements and other metadata, into a
Unified Kernel Image (UKI).

%package coredump
Group: System/Servers
Summary: systemd-coredump and coredumpctl utils
Requires: %name = %EVR

%description coredump
systemd-coredump and coredumpctl utils.

%package stateless
Group: System/Servers
Summary: systems that boot up with an empty /etc directory
BuildArch: noarch
Requires: %name = %EVR

%description stateless
This package contains:
 - ldconfig unit

%package -n udev
Group: System/Configuration/Hardware
Summary: udev - an userspace implementation of devfs
License: GPLv2+
Conflicts: filesystem < 3
Requires: shadow-utils dmsetup kmod >= 15 util-linux >= 2.27.1 losetup >= 2.19.1
Provides: hotplug = 2004_09_23-alt18
Obsoletes: hotplug < 2004_09_23-alt18
Provides: udev-extras = %EVR
Obsoletes: udev-extras < %EVR
Provides: udev-rules = %EVR
Obsoletes: udev-rules < %EVR
Provides: /etc/udev/rules.d /lib/udev/rules.d %_prefix/lib/udev/rules.d
Provides: udev-hwdb = %EVR
Obsoletes: udev-hwdb < %EVR
Provides: /etc/udev/hwdb.d /lib/udev/hwdb.d %_prefix/lib/udev/hwdb.d /sbin/udevadm
Conflicts: util-linux <= 2.22-alt2
Conflicts: DeviceKit
Conflicts: make-initrd < 2.2.10
Obsoletes: bash-completion-udev < %EVR
Obsoletes: zsh-completion-udev < %EVR

# Newer versions of those are required to support X11 keycode remapping
Conflicts: xorg-drv-evdev < 2.11.0
Conflicts: xorg-drv-libinput < 1.5.0

%description -n udev
Starting with the 2.5 kernel, all physical and virtual devices in a
system are visible to userspace in a hierarchal fashion through
sysfs. /sbin/hotplug provides a notification to userspace when any
device is added or removed from the system. Using these two features,
a userspace implementation of a dynamic /dev is now possible that can
provide a very flexible device naming policy

%package -n libudev1
Summary: Shared library to access udev device information
Group: System/Libraries
License: LGPLv2.1+
Conflicts: libudev < 0:181-alt5

%description -n libudev1
This package provides shared library to access udev device information

%package -n libudev-devel
Summary: Libraries and headers for libudev
Group: Development/C
License: LGPLv2.1+
Requires: libudev1 = %EVR

%description -n libudev-devel
Shared library and headers for libudev

%package -n libudev-devel-static
Summary: Static Library for libudev
Group: Development/C
License: LGPLv2.1+

%description -n libudev-devel-static
Static library for libudev.

%package tests
Summary: Internal unit tests for systemd
Group: Development/Other
License: LGPLv2+
Requires: %name = %EVR
Requires: %name-utils = %EVR
Requires: libnss-mymachines = %EVR
Requires: libnss-resolve = %EVR
Requires: libfido2_1 libqrencode4 libarchive
%add_findreq_skiplist /usr/lib/systemd/tests/testdata/units/TEST-50-DISSECT.dissect.sh
%add_findreq_skiplist /usr/lib/systemd/tests/testdata/units/TEST-81-GENERATORS.fstab-generator.sh
%add_findreq_skiplist /usr/lib/systemd/tests/testdata/units/TEST-86-MULTI-PROFILE-UKI.sh
%add_findreq_skiplist /usr/lib/systemd/tests/testdata/units/TEST-07-PID1.private-bpf.sh
%filter_from_requires /^.usr.lib.os-release/d

%description tests
"Installed tests" that are usually run as part of the build system.
They can be useful to test systemd internals.

%package utils-standalone
Group: System/Configuration/Boot and Init
Summary: Standalone systemd utils
Provides: %name-modules-load-standalone = %EVR
Provides: %name-repart-standalone = %EVR
Provides: %name-shutdown-standalone = %EVR
Provides: %name-sysctl-standalone = %EVR
Provides: %name-sysusers-standalone = %EVR
Provides: %name-tmpfiles-standalone = %EVR
Provides: %name-busctl-standalone = %EVR
Obsoletes: %name-modules-load-standalone < %EVR
Obsoletes: %name-sysctl-standalone < %EVR
Obsoletes: %name-sysusers-standalone < %EVR
Obsoletes: %name-tmpfiles-standalone < %EVR
Requires: %name-utils-filetriggers = %EVR
Requires: %name-tmpfiles-common = %EVR
Requires: %name-sysctl-common = %EVR
Requires: %name-modules-common = %EVR
Provides: %name-utils = %EVR
Obsoletes: %name-utils < %EVR
Conflicts: systemd
Conflicts: filesystem < 3
Provides: /sbin/systemd-modules-load /sbin/systemd-shutdown /sbin/systemd-sysctl /sbin/systemd-sysusers /sbin/systemd-sysusers /sbin/systemd-tmpfiles

%description utils-standalone
This package contains standalone utils from systemd:
 - systemd-modules-load.standalone
 - systemd-repart.standalone
 - systemd-shutdown.standalone
 - systemd-sysctl.standalone
 - systemd-sysusers.standalone
 - systemd-tmpfiles.standalone
 - busctl.standalone

%package utils-filetriggers
Group: System/Configuration/Boot and Init
Summary: RPM filetriggers for systemd utils
BuildArch: noarch
%add_findreq_skiplist %_rpmlibdir/systemd-tmpfiles.filetrigger
%add_findreq_skiplist %_rpmlibdir/systemd-sysusers.filetrigger
%add_findreq_skiplist %_rpmlibdir/systemd-modules-load.filetrigger
%add_findreq_skiplist %_rpmlibdir/systemd-sysctl.filetrigger

%description utils-filetriggers
%summary

%package tmpfiles-common
Group: System/Configuration/Boot and Init
Summary: Common tmpfiles configs
BuildArch: noarch

%description tmpfiles-common
%summary

%package sysctl-common
Group: System/Configuration/Boot and Init
Summary: Common sysctl configs
Conflicts: startup < 0.9.9.14

%description sysctl-common
%summary

%package modules-common
Group: System/Configuration/Boot and Init
Summary: Common modules configs
BuildArch: noarch
Conflicts: startup < 0.9.9.14

%description modules-common
%summary

%prep
%setup -q
%patch1 -p1
sed -i "s|/usr/bin/bash|/bin/bash|g" test/units/*.sh
sed -i "s|/usr/bin/bash|/bin/bash|" mkosi/mkosi.images/exitrd/mkosi.extra/shutdown

%build
%meson \
        -Dmode=release \
        -Dlink-udev-shared=false \
        -Dlink-systemctl-shared=false \
        -Dlink-networkd-shared=false \
        -Dlink-timesyncd-shared=false \
        -Dlink-journalctl-shared=false \
        -Dlink-boot-shared=false \
        -Dlink-portabled-shared=false \
        -Dlink-executor-shared=false \
        %{?_enable_static_libsystemd:-Dstatic-libsystemd=pic} \
        %{?_enable_static_libudev:-Dstatic-libudev=pic} \
        %{?_enable_standalone_binaries:-Dstandalone-binaries=true} \
        -Dxinitrcdir=%_sysconfdir/X11/xinit.d \
        -Dpamlibdir=/%_lib/security \
        -Dsplit-bin=true \
        -Dconfigfiledir=/usr/lib \
        -Dsysvinit-path=%_initdir \
        -Dsysvrcnd-path=%_sysconfdir/rc.d \
        -Drc-local=%_sysconfdir/rc.d/rc.local \
        -Dsshdconfdir=%_sysconfdir/openssh/sshd_config.d \
        -Dsshconfdir=%_sysconfdir/openssh/ssh_config.d \
        -Dinstall-sysconfdir=true \
        -Dkernel-install=true \
        -Dpamconfdir=%_sysconfdir/pam.d \
        -Ddebug-shell=/bin/bash \
        -Dquotaon-path=/sbin/quotaon \
        -Dquotacheck-path=/sbin/quotacheck \
        -Dkmod-path=/bin/kmod \
        %{?_enable_kexec:-Dkexec-path=/sbin/kexec} \
        -Dsulogin-path=/sbin/sulogin \
        -Dmount-path=/bin/mount \
        -Dumount-path=/bin/umount \
        -Dloadkeys-path=/bin/loadkeys \
        -Dsetfont-path=/bin/setfont \
        -Dnologin-path=/sbin/nologin \
        -Dcompat-mutable-uid-boundaries=true \
        -Dadm-gid=4 \
        -Daudio-gid=81 \
        -Dcdrom-gid=22 \
        -Ddisk-gid=6 \
        -Dkmem-gid=9 \
        -Dlp-gid=7 \
        -Dtty-gid=5 \
        -Dusers-gid=100 \
        -Dutmp-gid=72 \
        -Dwheel-gid=10 \
        -Dnobody-user=nobody \
        -Dnobody-group=nobody \
        -Dbump-proc-sys-fs-file-max=false \
        -Dbump-proc-sys-fs-nr-open=false \
        %{?_enable_elfutils:-Delfutils=enabled} \
        %{?_enable_passwdqc:-Dpasswdqc=enabled} \
        %{?_enable_xz:-Dxz=enabled} \
        %{?_enable_zlib:-Dzlib=enabled} \
        %{?_enable_bzip2:-Dbzip2=enabled} \
        %{?_enable_lz4:-Dlz4=enabled} \
        %{?_enable_zstd:-Dzstd=enabled} \
        %{?_enable_libcryptsetup:-Dlibcryptsetup=enabled} \
        %{?_enable_tpm2:-Dtpm2=enabled} \
        %{?_enable_logind:-Dlogind=true} \
        %{?_enable_vconsole:-Dvconsole=true} \
        %{?_enable_initrd:-Dinitrd=true} \
        %{?_enable_quotacheck:-Dquotacheck=true} \
        %{?_enable_randomseed:-Drandomseed=true} \
        %{?_enable_bpf_framework:-Dbpf-framework=true} \
        %{?_enable_coredump:-Dcoredump=true} \
        %{?_enable_pstore:-Dpstore=true} \
        %{?_enable_smack:-Dsmack=true} \
        %{?_enable_gcrypt:-Dgcrypt=enabled} \
        %{?_enable_qrencode:-Dqrencode=enabled} \
        %{?_enable_microhttpd:-Dmicrohttpd=enabled} \
        %{?_enable_gnutls:-Dgnutls=enabled} \
        %{?_enable_openssl:-Dopenssl=enabled} \
        %{?_enable_p11kit:-Dp11kit=enabled} \
        %{?_enable_libfido2:-Dlibfido2=enabled} \
        %{?_enable_libcurl:-Dlibcurl=enabled} \
        %{?_enable_libidn:-Dlibidn=true} \
        %{?_enable_libidn2:-Dlibidn2=enabled} \
        %{?_enable_libiptc:-Dlibiptc=enabled} \
        %{?_enable_polkit:-Dpolkit=enabled} \
        %{?_enable_efi:-Defi=true} \
        %{?_enable_vmspawn:-Dvmspawn=enabled} \
        -Dsbat-distro=%sbat_distro \
        -Dsbat-distro-generation=%sbat_distro_generation \
        -Dsbat-distro-summary=%sbat_distro_summary \
        -Dsbat-distro-pkgname=%sbat_distro_pkgname \
        -Dsbat-distro-version=%sbat_distro_version \
        -Dsbat-distro-url=%sbat_distro_url \
        %{?_enable_homed:-Dhomed=enabled} \
        %{?_enable_networkd:-Dnetworkd=true} \
        %{?_enable_resolve:-Dresolve=true} \
        -Ddns-servers="" \
        %{?_enable_timesyncd:-Dtimesyncd=true} \
        -Dntp-servers="" \
        %{?_enable_sysusers:-Dsysusers=true} \
        %{?_enable_tcb:-Dtcb=true} \
        %{?_enable_ldconfig:-Dldconfig=true} \
        -Dbootloader=%{?_enable_bootloader:enabled}%{!?_enable_bootloader:disabled} \
        -Dukify=%{?_enable_bootloader:enabled}%{!?_enable_bootloader:disabled} \
        -Dfirstboot=%{?_enable_firstboot:true}%{!?_enable_firstboot:false} \
        %{?_enable_seccomp:-Dseccomp=enabled} \
        %{?_enable_ima:-Dima=true} \
        %{?_enable_selinux:-Dselinux=enabled} \
        %{?_enable_apparmor:-Dapparmor=true} \
        %{?_enable_utmp:-Dutmp=true} \
        %{?_disable_kill_user_processes:-Ddefault-kill-user-processes=false} \
        -Dfirst-boot-full-preset=true \
        -Ddefault-timeout-sec=45 \
        -Ddefault-user-timeout-sec=45 \
        -Doomd=true \
        -Dsysupdate=disabled \
        -Dstatus-unit-format-default=combined \
        -Dfallback-hostname=localhost \
        -Ddefault-dnssec=no \
        -Ddefault-mdns=no \
        -Ddefault-llmnr=yes \
%ifnarch mipsel
        -Db_lto=true \
%else
        -Db_lto=false \
%endif
        -Db_pie=true \
        -Db_ndebug=false \
        -Dman=enabled \
        -Dcreate-log-dirs=false \
        -Durlify=false \
        -Dtests=unsafe \
        -Dinstall-tests=true \
        -Dversion-tag=%version-%release \
        -Dvcs-tag=false \
        -Dcertificate-root=/etc/pki/tls \
        -Ddocdir=%_defaultdocdir/%name-%version

%meson_build

%install
%meson_install

# Config files that were moved under /usr.
# We need to %%ghost them so that they are not removed on upgrades.
touch %buildroot%_sysconfdir/systemd/coredump.conf \
      %buildroot%_sysconfdir/systemd/homed.conf \
      %buildroot%_sysconfdir/systemd/journald.conf \
      %buildroot%_sysconfdir/systemd/journal-remote.conf \
      %buildroot%_sysconfdir/systemd/journal-upload.conf \
      %buildroot%_sysconfdir/systemd/logind.conf \
      %buildroot%_sysconfdir/systemd/networkd.conf \
      %buildroot%_sysconfdir/systemd/oomd.conf \
      %buildroot%_sysconfdir/systemd/pstore.conf \
      %buildroot%_sysconfdir/systemd/resolved.conf \
      %buildroot%_sysconfdir/systemd/sleep.conf \
      %buildroot%_sysconfdir/systemd/system.conf \
      %buildroot%_sysconfdir/systemd/timesyncd.conf \
      %buildroot%_sysconfdir/systemd/user.conf \
      %buildroot%_sysconfdir/udev/udev.conf \
      %buildroot%_sysconfdir/udev/iocost.conf

# remove .so file for the shared library, it's not supposed to be used
rm -f %buildroot%_systemd_dir/libsystemd-shared.so
# remove systemd rpm macros
rm -f %buildroot/usr/lib/rpm/macros.d/macros.systemd
# remove linuxia32.elf.stub
# debugedit: Failed to update file: invalid section entry size
%ifarch %ix86
rm -f %buildroot%_systemd_dir/boot/efi/linuxia32.elf.stub
%endif

%if_disabled bpf_framework
rm -f %buildroot%_systemd_dir/tests/unit-tests/manual/test-bpf-token
%endif

%if_disabled tpm2
# for some weird reason, systemd still installs these man pages
# even though the corresponding binaries are not built
rm -vf %buildroot%_man1dir/systemd-measure*
rm -vf %buildroot%_man8dir/systemd-pcrfs*
rm -vf %buildroot%_man8dir/systemd-pcrphase*
rm -vf %buildroot%_man8dir/systemd-pcrmachine*
rm -vf %buildroot%_man8dir/systemd-pcrextend*
rm -vf %buildroot%_man8dir/systemd-pcrlock*
rm -vf %buildroot%_man8dir/systemd-tpm2*
%endif

%find_lang %name

# Make sure these directories are properly owned
mkdir -p %buildroot%_unitdir/{basic,dbus,default,graphical,poweroff,rescue,reboot,sysinit}.target.wants

install -m755 %SOURCE2 %buildroot%_systemd_dir/systemd-sysv-install

ln -s rc-local.service %buildroot%_unitdir/local.service
install -m644 %SOURCE4 %buildroot%_unitdir/altlinux-openresolv.path
install -m644 %SOURCE5 %buildroot%_unitdir/altlinux-openresolv.service
install -m644 %SOURCE68 %buildroot%_unitdir/altlinux-simpleresolv.path
install -m644 %SOURCE69 %buildroot%_unitdir/altlinux-simpleresolv.service
ln -r -s %buildroot%_unitdir/altlinux-openresolv.path %buildroot%_unitdir/multi-user.target.wants/altlinux-openresolv.path
ln -r -s %buildroot%_unitdir/altlinux-simpleresolv.path %buildroot%_unitdir/multi-user.target.wants/altlinux-simpleresolv.path
install -m644 %SOURCE6 %buildroot%_unitdir/altlinux-libresolv.path
install -m644 %SOURCE7 %buildroot%_unitdir/altlinux-libresolv.service
ln -r -s %buildroot%_unitdir/altlinux-libresolv.path %buildroot%_unitdir/multi-user.target.wants/altlinux-libresolv.path
install -m644 %SOURCE27 %buildroot%_unitdir/altlinux-first_time.service
ln -r -s %buildroot%_unitdir/altlinux-first_time.service %buildroot%_unitdir/basic.target.wants/altlinux-first_time.service
ln -s systemd-random-seed.service %buildroot%_unitdir/random.service
ln -s systemd-reboot.service %buildroot%_unitdir/reboot.service
ln -s systemd-halt.service %buildroot%_unitdir/halt.service
ln -s systemd-tmpfiles-setup.service %buildroot%_unitdir/tmpfiles.service

# Make sure the NTP units dir exists
mkdir -p %buildroot%_systemd_dir/ntp-units.d
mkdir -p %buildroot%_sysconfdir/systemd/ntp-units.d

# restore bind-mounts /var/run -> run and /var/lock -> /run/lock
# we don't have those directories symlinked
install -m644 %SOURCE23 %buildroot%_unitdir/var-lock.mount
install -m644 %SOURCE24 %buildroot%_unitdir/var-run.mount
ln -r -s %buildroot%_unitdir/var-lock.mount %buildroot%_unitdir/local-fs.target.wants
ln -r -s %buildroot%_unitdir/var-run.mount %buildroot%_unitdir/local-fs.target.wants

# turn off tmp.mount by default (ALT#29066)
rm -f %buildroot%_unitdir/tmp.mount
rm -f %buildroot%_unitdir/local-fs.target.wants/tmp.mount

find %buildroot \( -name '*.la' \) -exec rm {} \;
mkdir -p %buildroot/{sbin,bin}
ln -r -s %buildroot%_systemd_dir/systemd %buildroot/%_sbindir/systemd

# for compatibility with older systemd pkgs which expected it at /sbin/:
ln -r -s %buildroot%_bindir/systemctl %buildroot/%_sbindir/
ln -r -s %buildroot%_bindir/udevadm %buildroot/%_sbindir/

# add defaults services
ln -r -s %buildroot%_unitdir/remote-fs.target %buildroot%_unitdir/multi-user.target.wants
ln -r -s %buildroot%_unitdir/machines.target %buildroot%_unitdir/multi-user.target.wants
%if_enabled pstore
ln -r -s %buildroot%_unitdir/systemd-pstore.service %buildroot%_unitdir/sysinit.target.wants
%endif

# create drop-in to prevent tty1 to be cleared
mkdir -p %buildroot%_unitdir/getty@tty1.service.d
cat > %buildroot%_unitdir/getty@tty1.service.d/noclear.conf << EOF
[Service]
# ensure tty1 isn't cleared
TTYVTDisallocate=no
EOF

# don't enable wall ask password service, it spams every console
rm -f %buildroot%_unitdir/multi-user.target.wants/systemd-ask-password-wall.path

# disable legacy services
ln -s /dev/null %buildroot%_unitdir/fbsetfont.service
ln -s /dev/null %buildroot%_unitdir/keytable.service
ln -s /dev/null %buildroot%_unitdir/killall.service
ln -s /dev/null %buildroot%_unitdir/single.service
ln -s /dev/null %buildroot%_unitdir/netfs.service

mkdir -p %buildroot%_modules_loaddir
# add example file for module load
install -Dm0644 %SOURCE9 %buildroot%_sysconfdir/modules-load.d/modules.conf
# create /etc/modules as a symlink to /etc/modules-load.d/modules.conf
ln -r -s %buildroot%_sysconfdir/modules-load.d/modules.conf %buildroot%_sysconfdir/modules

# create /etc/sysctl.conf as a symlink to /etc/sysctl.d/99-sysctl.conf
install -Dm0644 %SOURCE8 %buildroot%_sysconfdir/sysctl.d/99-sysctl.conf
ln -r -s %buildroot%_sysconfdir/sysctl.d/99-sysctl.conf %buildroot%_sysconfdir/sysctl.conf

# Make sure directories in /var exist
mkdir -p %buildroot%_sharedstatedir/%name/coredump
mkdir -p %buildroot%_sharedstatedir/%name/catalog
mkdir -p %buildroot%_sharedstatedir/%name/backlight
mkdir -p %buildroot%_sharedstatedir/%name/rfkill
mkdir -p %buildroot%_sharedstatedir/%name/linger
mkdir -p %buildroot%_sharedstatedir/%name/journal-upload
mkdir -p %buildroot%_sharedstatedir/private/systemd/journal-upload
mkdir -p %buildroot%_cachedir/private
mkdir -p %buildroot%_sharedstatedir/%name/timesync
touch %buildroot%_sharedstatedir/%name/catalog/database
touch %buildroot%_sysconfdir/udev/hwdb.bin
touch %buildroot%_sharedstatedir/%name/random-seed
touch %buildroot%_sharedstatedir/%name/timesync/clock
mkdir -p %buildroot%_logdir/journal
mkdir -p %buildroot%_logdir/private
%if_enabled microhttpd
mkdir -p %buildroot%_logdir/journal/remote
%endif
install -Dm0644 docs/var-log/README.logs %buildroot%_logdir/

# Create new-style configuration files so that we can ghost-own them
touch %buildroot%_sysconfdir/hostname
touch %buildroot%_sysconfdir/vconsole.conf
touch %buildroot%_sysconfdir/locale.conf
touch %buildroot%_sysconfdir/machine-info

# Make sure the system.conf drop-in dirs exist
mkdir -p %buildroot{%_systemd_dir,%_sysconfdir/systemd}/system.conf.d
mkdir -p %buildroot{%_systemd_dir,%_sysconfdir/systemd}/user.conf.d

install -d -m 0700 %buildroot%_sysconfdir/userdb

# Make sure the shutdown/sleep drop-in dirs exist
mkdir -p %buildroot%_systemd_dir/system-shutdown
mkdir -p %buildroot%_systemd_dir/system-sleep

# Make sure the *-environment-generators dirs exist
mkdir -p %buildroot%_user_env_gen_dir
mkdir -p %buildroot%_env_gen_dir
mkdir -p %buildroot%_sysconfdir/systemd/{system,user}-generators

# fix pam.d/systemd-user for ALTLinux
install -m644 %SOURCE14 %buildroot%_sysconfdir/pam.d/systemd-user

# Install ALTLinux default preset policy
mkdir -p %buildroot%_presetdir
mkdir -p %buildroot%_sysconfdir/systemd/{system,user}-preset
mkdir -p %buildroot%_systemd_dir/user-preset
mkdir -p %buildroot%_sysconfdir/systemd/user-preset
mkdir -p %buildroot%_user_presetdir
install -m 0644 %SOURCE34 %buildroot%_presetdir/
install -m 0644 %SOURCE35 %buildroot%_presetdir/
install -m 0644 %SOURCE36 %buildroot%_presetdir/
install -m 0644 %SOURCE36 %buildroot%_user_presetdir/
install -m 0644 %SOURCE37 %buildroot%_presetdir/
install -m 0644 %SOURCE38 %buildroot%_presetdir/

mkdir -p %buildroot%_systemd_dir/logind.conf.d

# systemd-oomd default configuration
install -D -m 0644 -t %buildroot%_systemd_dir/oomd.conf.d/ %SOURCE44
install -D -m 0644 -t %buildroot%_unitdir/system.slice.d/ %SOURCE45
install -D -m 0644 -t %buildroot%_user_unitdir/slice.d/ %SOURCE45

# increase vm.max_map_count
install -D -m 0644 -t %buildroot%_sysctldir/ %SOURCE47

install -D -m 0664 -t %buildroot%_systemd_dir/network/ %SOURCE25

mkdir -p %buildroot%_sysconfdir/systemd/network
mkdir -p %buildroot%_sysconfdir/systemd/nspawn

# The following services are currently installed by initscripts
#pushd %%buildroot%%_unitdir/graphical.target.wants && {
#        rm -f display-manager.service
#        rm -f dm.service
#popd
#}

# Set up the pager to make it generally more useful
mkdir -p %buildroot%_sysconfdir/profile.d
cat > %buildroot%_sysconfdir/profile.d/systemd.sh << EOF
export SYSTEMD_PAGER="/usr/bin/less -FR"
EOF
chmod 755 %buildroot%_sysconfdir/profile.d/systemd.sh

install -m644 %SOURCE30 %buildroot%_sysctldir/49-coredump-disable.conf
# rpm posttrans filetriggers
install -pD -m755 %SOURCE71 %buildroot%_rpmlibdir/udev.filetrigger
install -pD -m755 %SOURCE72 %buildroot%_rpmlibdir/udev-hwdb.filetrigger
install -pD -m755 %SOURCE73 %buildroot%_rpmlibdir/systemd.filetrigger
install -pD -m755 %SOURCE74 %buildroot%_rpmlibdir/systemd-tmpfiles.filetrigger
install -pD -m755 %SOURCE75 %buildroot%_rpmlibdir/systemd-sysctl.filetrigger
install -pD -m755 %SOURCE76 %buildroot%_rpmlibdir/systemd-binfmt.filetrigger
install -pD -m755 %SOURCE77 %buildroot%_rpmlibdir/journal-catalog.filetrigger
install -pD -m755 %SOURCE78 %buildroot%_rpmlibdir/systemd-sysusers.filetrigger
install -pD -m755 %SOURCE79 %buildroot%_rpmlibdir/systemd-modules-load.filetrigger
install -pD -m755 %SOURCE80 %buildroot%_rpmlibdir/systemd-user.filetrigger

# alternatives
for f in busctl systemd-repart systemd-sysusers systemd-tmpfiles; do
        mv %buildroot%_bindir/$f %buildroot%_bindir/$f.shared
done
install -pD -m644 %SOURCE81 %buildroot/%_altdir/systemd-modules-load-shared
install -pD -m644 %SOURCE82 %buildroot/%_altdir/systemd-modules-load-standalone
install -pD -m644 %SOURCE83 %buildroot/%_altdir/systemd-repart-shared
install -pD -m644 %SOURCE84 %buildroot/%_altdir/systemd-repart-standalone
install -pD -m644 %SOURCE85 %buildroot/%_altdir/systemd-shutdown-shared
install -pD -m644 %SOURCE86 %buildroot/%_altdir/systemd-shutdown-standalone
install -pD -m644 %SOURCE87 %buildroot/%_altdir/systemd-sysctl-shared
install -pD -m644 %SOURCE88 %buildroot/%_altdir/systemd-sysctl-standalone
install -pD -m644 %SOURCE89 %buildroot/%_altdir/systemd-sysusers-shared
install -pD -m644 %SOURCE90 %buildroot/%_altdir/systemd-sysusers-standalone
install -pD -m644 %SOURCE91 %buildroot/%_altdir/systemd-tmpfiles-shared
install -pD -m644 %SOURCE92 %buildroot/%_altdir/systemd-tmpfiles-standalone
install -pD -m644 %SOURCE93 %buildroot/%_altdir/systemd-busctl-shared
install -pD -m644 %SOURCE94 %buildroot/%_altdir/systemd-busctl-standalone

cat >>%buildroot%_sysctldir/50-mmap-min-addr.conf <<EOF
# Indicates the amount of address space which a user process will be
# restricted from mmaping.  Since kernel null dereference bugs could
# accidentally operate based on the information in the first couple of
# pages of memory userspace processes should not be allowed to write to
# them.  By default, this value in kernel is set to 0 and no protections
# will be enforced by the security module.  Setting this value to
# something >= 32k will allow the vast majority of applications to work
# correctly and provide defense in depth against future potential kernel
# bugs.  This value is somewhat architecture-dependent, though.
# Recommended default for x86_64 is 65536.
vm.mmap_min_addr = %mmap_min_addr
EOF

# define default PATH for system and user
mkdir -p %buildroot%_systemd_dir/user.conf.d
install -m 0644 %SOURCE11 %buildroot%_systemd_dir/user.conf.d/env-path.conf
#mkdir -p %%buildroot%%_prefix/systemd/system.conf.d
#install -m 0644 %%SOURCE12 %%buildroot%%_prefix/systemd/system.conf.d/env-path.conf

#######
# UDEV
#######
mkdir -p %buildroot{%_initdir,%_sysconfdir/sysconfig}
install -p -m755 %SOURCE19 %buildroot%_initdir/udevd
install -p -m644 %SOURCE20 %buildroot%_sysconfdir/sysconfig/udevd

ln -s systemd-udevd.service %buildroot%_unitdir/udevd.service

# compatibility symlinks to udevd binary
ln -r -s %buildroot%_systemd_dir/systemd-udevd %buildroot%_prefix/lib/udev/udevd
ln -r -s %buildroot%_systemd_dir/systemd-udevd %buildroot%_sbindir/udevd

install -p -m644 %SOURCE22 %buildroot%_sysconfdir/scsi_id.config

# Install symlinks for rules which are needed in initramfs
mkdir -p %buildroot%_prefix/lib/udev/initramfs-rules.d
for f in \
    50-udev-default.rules \
    60-persistent-storage.rules \
    80-drivers.rules
do
    ln -s ../rules.d/"$f" \
        %buildroot%_prefix/lib/udev/initramfs-rules.d/
done
# Create ghost files
touch %buildroot%_sysconfdir/udev/hwdb.bin


echo ".so man8/systemd-udevd.8" > %buildroot%_man8dir/udevd.8

# https://bugzilla.redhat.com/show_bug.cgi?id=1378974
install -D -m644 -t %buildroot%_unitdir/systemd-udev-trigger.service.d/ %SOURCE10

%check
export LD_LIBRARY_PATH=$(pwd)/%{__builddir}/src/shared:$(pwd)/%{__builddir}
%meson_test

%pre
groupadd -r -f systemd-journal >/dev/null 2>&1 ||:
groupadd -r -f systemd-oom >/dev/null 2>&1 ||:
useradd -g systemd-oom -c 'systemd Userspace OOM Killer' \
    -d /var/empty -s /dev/null -r -l -M systemd-oom >/dev/null 2>&1 ||:

%post
systemd-machine-id-setup >/dev/null 2>&1 || :

systemctl daemon-reexec &>/dev/null || {
  # systemd v239 had bug #9553 in D-Bus authentication of the private socket,
  # which was later fixed in v240 by #9625.
  #
  # The end result is that a `systemctl daemon-reexec` call as root will fail
  # when upgrading from systemd v239, which means the system will not start
  # running the new version of systemd after this post install script runs.
  #
  # To work around this issue, let's fall back to using a `kill -TERM 1` to
  # re-execute the daemon when the `systemctl daemon-reexec` call fails.
  #
  # In order to prevent issues when the reason why the daemon-reexec failed is
  # not the aforementioned bug, let's only use this fallback when:
  #   - we're upgrading this RPM package; and
  #   - we confirm that systemd is running as PID1 on this system.
  if [ $1 -gt 1 ] && [ -d /run/systemd/system ] ; then
    kill -TERM 1 &>/dev/null || :
  fi
}

# Move old stuff around in /var/lib
[ -d %_sharedstatedir/%name/random-seed ] && rm -rf %_sharedstatedir/%name/random-seed >/dev/null 2>&1 || :
[ -e %_sharedstatedir/random-seed ] && mv %_sharedstatedir/random-seed %_sharedstatedir/%name/random-seed >/dev/null 2>&1 || :
[ -e %_sharedstatedir/backlight ] && mv %_sharedstatedir/backlight %_sharedstatedir/%name/backlight >/dev/null 2>&1 || :

%_systemd_dir/systemd-random-seed save >/dev/null 2>&1 || :

# rm symlinks for network.service
[ -L %_sysconfdir/systemd/system/network.target.wants/network.service ] && rm -f %_sysconfdir/systemd/system/network.target.wants/network.service  >/dev/null 2>&1 || :
[ -L %_sysconfdir/systemd/system/multi-user.target.wants/network.service ] && rm -f %_sysconfdir/systemd/system/multi-user.target.wants/network.service  >/dev/null 2>&1 || :

# rm symlinks for prefdm.service
[ -L %_sysconfdir/systemd/system/graphical.target.wants/prefdm.service ] && rm -f %_sysconfdir/systemd/system/graphical.target.wants/prefdm.service  >/dev/null 2>&1 || :

if [ $1 -eq 1 ] ; then
     # create /var/log/journal only on initial installation
     mkdir -p %_logdir/journal
fi

# Make sure new journal files will be owned by the "systemd-journal" group
chgrp systemd-journal /run/log/journal/ /run/log/journal/`cat /etc/machine-id 2> /dev/null` %_logdir/journal/ %_logdir/journal/`cat /etc/machine-id 2> /dev/null` >/dev/null 2>&1 || :
chmod g+s  /run/log/journal/ /run/log/journal/`cat /etc/machine-id 2> /dev/null` %_logdir/journal/ %_logdir/journal/`cat /etc/machine-id 2> /dev/null` >/dev/null 2>&1 || :

# Apply ACL to the journal directory
setfacl -Rnm g:wheel:rx,d:g:wheel:rx,g:adm:rx,d:g:adm:rx %_logdir/journal/ >/dev/null 2>&1 || :

# remove obsolete systemd-readahead file and services symlink
rm -f /.readahead > /dev/null 2>&1 || :
[ -L %_sysconfdir/systemd/system/default.target.wants/systemd-readahead-collect.service ] && rm -f %_sysconfdir/systemd/system/default.target.wants/systemd-readahead-collect.service
[ -L %_sysconfdir/systemd/system/default.target.wants/systemd-readahead-replay.service ] && rm -f %_sysconfdir/systemd/system/default.target.wants/systemd-readahead-replay.service
[ -L %_sysconfdir/systemd/system/system-update.target.wants/systemd-readahead-drop.service ] && rm -f %_sysconfdir/systemd/system/system-update.target.wants/systemd-readahead-drop.service


if [ $1 -eq 1 ] ; then
        # Enable the services we install by default
        systemctl preset-all >/dev/null 2>&1 || :
        systemctl --global preset-all >/dev/null 2>&1 || :
fi


# Migrate /etc/sysconfig/clock
SYSCONFIG_CLOCK=/etc/sysconfig/clock
if [ ! -L /etc/localtime -a -e "$SYSCONFIG_CLOCK" ] ; then
       . "$SYSCONFIG_CLOCK" >/dev/null 2>&1 || :
       if [ -n "$ZONE" -a -e "/usr/share/zoneinfo/$ZONE" ] ; then
              ln -sf "../usr/share/zoneinfo/$ZONE" /etc/localtime >/dev/null 2>&1 || :
       fi
fi
#rm -f "$SYSCONFIG_CLOCK" >/dev/null 2>&1 || :

# Migrate /etc/sysconfig/i18n
SYSCONFIG_I18N=/etc/sysconfig/i18n
if [ -e "$SYSCONFIG_I18N" -a ! -e /etc/locale.conf ]; then
        unset LANG
        unset LC_CTYPE
        unset LC_NUMERIC
        unset LC_TIME
        unset LC_COLLATE
        unset LC_MONETARY
        unset LC_MESSAGES
        unset LC_PAPER
        unset LC_NAME
        unset LC_ADDRESS
        unset LC_TELEPHONE
        unset LC_MEASUREMENT
        unset LC_IDENTIFICATION
        . "$SYSCONFIG_I18N" >/dev/null 2>&1 || :
        [ -n "$LANG" ] && echo LANG=$LANG > /etc/locale.conf 2>&1 || :
        [ -n "$LC_CTYPE" ] && echo LC_CTYPE=$LC_CTYPE >> /etc/locale.conf 2>&1 || :
        [ -n "$LC_NUMERIC" ] && echo LC_NUMERIC=$LC_NUMERIC >> /etc/locale.conf 2>&1 || :
        [ -n "$LC_TIME" ] && echo LC_TIME=$LC_TIME >> /etc/locale.conf 2>&1 || :
        [ -n "$LC_COLLATE" ] && echo LC_COLLATE=$LC_COLLATE >> /etc/locale.conf 2>&1 || :
        [ -n "$LC_MONETARY" ] && echo LC_MONETARY=$LC_MONETARY >> /etc/locale.conf 2>&1 || :
        [ -n "$LC_MESSAGES" ] && echo LC_MESSAGES=$LC_MESSAGES >> /etc/locale.conf 2>&1 || :
        [ -n "$LC_PAPER" ] && echo LC_PAPER=$LC_PAPER >> /etc/locale.conf 2>&1 || :
        [ -n "$LC_NAME" ] && echo LC_NAME=$LC_NAME >> /etc/locale.conf 2>&1 || :
        [ -n "$LC_ADDRESS" ] && echo LC_ADDRESS=$LC_ADDRESS >> /etc/locale.conf 2>&1 || :
        [ -n "$LC_TELEPHONE" ] && echo LC_TELEPHONE=$LC_TELEPHONE >> /etc/locale.conf 2>&1 || :
        [ -n "$LC_MEASUREMENT" ] && echo LC_MEASUREMENT=$LC_MEASUREMENT >> /etc/locale.conf 2>&1 || :
        [ -n "$LC_IDENTIFICATION" ] && echo LC_IDENTIFICATION=$LC_IDENTIFICATION >> /etc/locale.conf 2>&1 || :
fi
#rm -f "$SYSCONFIG_I18N" >/dev/null 2>&1 || :

# Migrate /etc/sysconfig/keyboard and /etc/sysconfig/consolefont
SYSCONFIG_KEYBOARD=/etc/sysconfig/keyboard
SYSCONFIG_CONSOLEFONT=/etc/sysconfig/consolefont
if [ -e "$SYSCONFIG_KEYBOARD" -a -e "$SYSCONFIG_CONSOLEFONT" -a ! -e /etc/vconsole.conf ]; then
        unset SYSFONT
        unset SYSFONTACM
        unset UNIMAP
        unset KEYTABLE
        [ -e "$SYSCONFIG_KEYBOARD" ] && . "$SYSCONFIG_KEYBOARD" >/dev/null 2>&1 || :
        [ -e "$SYSCONFIG_CONSOLEFONT" ] && . "$SYSCONFIG_CONSOLEFONT" >/dev/null 2>&1 || :
        [ -n "$SYSFONT" ] && echo FONT=$SYSFONT > /etc/vconsole.conf 2>&1 || :
        [ -n "$SYSFONTACM" ] && echo FONT_MAP=$SYSFONTACM >> /etc/vconsole.conf 2>&1 || :
        [ -n "$UNIMAP" ] && echo FONT_UNIMAP=$UNIMAP >> /etc/vconsole.conf 2>&1 || :
        [ -n "$KEYTABLE" ] && echo KEYMAP=$KEYTABLE >> /etc/vconsole.conf 2>&1 || :
fi
#rm -f "$SYSCONFIG_KEYBOARD" >/dev/null 2>&1 || :
#rm -f "$SYSCONFIG_CONSOLEFONT" >/dev/null 2>&1 || :

# Migrate HOSTNAME= from /etc/sysconfig/network
SYSCONFIG_NETWORK=/etc/sysconfig/network
if [ -e "$SYSCONFIG_NETWORK" -a ! -e /etc/hostname ]; then
        unset HOSTNAME
        . "$SYSCONFIG_NETWORK" >/dev/null 2>&1 || :
        [ -n "$HOSTNAME" ] && echo $HOSTNAME > /etc/hostname 2>&1 || :
fi
#sed -i '/^HOSTNAME=/d' "$SYSCONFIG_NETWORK" >/dev/null 2>&1 || :


%post_systemd_postponed systemd-timedated.service systemd-hostnamed.service systemd-journald.service systemd-localed.service systemd-userdbd.service systemd-oomd.service


%if_enabled networkd
%pre networkd
groupadd -r -f systemd-network >/dev/null 2>&1 ||:
useradd -g systemd-network -c 'systemd Network Management' \
    -d /var/empty -s /dev/null -r -l -M systemd-network >/dev/null 2>&1 ||:

groupadd -r -f systemd-resolve >/dev/null 2>&1 ||:
useradd -g systemd-resolve -c 'systemd Resolver' \
    -d /var/empty -s /dev/null -r -l -M systemd-resolve >/dev/null 2>&1 ||:

%post networkd
%post_systemd_postponed systemd-networkd.service systemd-networkd.socket systemd-networkd-wait-online.service systemd-network-generator.service systemd-networkd-persistent-storage.service systemd-resolved.service

%preun networkd
%systemd_preun systemd-networkd.service systemd-networkd.socket systemd-networkd-wait-online.service systemd-network-generator.service systemd-networkd-persistent-storage.service systemd-resolved.service
%endif

%if_enabled coredump
%pre coredump
groupadd -r -f systemd-coredump >/dev/null 2>&1 ||:
useradd -g systemd-coredump -c 'systemd Core Dumper' \
    -d /var/empty -s /dev/null -r -l -M systemd-coredump >/dev/null 2>&1 ||:
%endif

%if_enabled timesyncd
%pre timesyncd
groupadd -r -f systemd-timesync >/dev/null 2>&1 ||:
useradd -g systemd-timesync -c 'systemd Time Synchronization' \
    -d /var/empty -s /dev/null -r -l -M systemd-timesync >/dev/null 2>&1 ||:


%post timesyncd
if [ -L %_sharedstatedir/%name/timesync ]; then
    rm %_sharedstatedir/%name/timesync
    mv %_sharedstatedir/private/systemd/timesync %_sharedstatedir/%name/timesync
fi
if [ -f %_sharedstatedir/%name/clock ] ; then
    mkdir -p %_sharedstatedir/%name/timesync
    mv %_sharedstatedir/%name/clock %_sharedstatedir/%name/timesync/
fi

%post_systemd_postponed systemd-timesyncd.service

%preun timesyncd
%systemd_preun systemd-timesyncd.service

%endif

%post homed
%post_systemd_postponed systemd-homed.service

%preun homed
%systemd_preun systemd-homed.service

%post boot-efi
if bootctl --quiet is-installed >/dev/null 2>&1 ; then
        bootctl --no-variables --graceful update || echo "** WARNING: systemd-boot-efi install failed"
fi

%post -n libnss-systemd
if [ -f /etc/nsswitch.conf ] ; then
            grep -E -q '^(passwd|shadow|group|gshadow):.* systemd' /etc/nsswitch.conf ||
            sed -i.rpmorig -r -e '
                s/^(passwd|shadow|gshadow):.*/& systemd/
                s/^(group:.*)(\s+role)?\s*$/\1 [SUCCESS=merge] systemd\2/
                ' /etc/nsswitch.conf >/dev/null 2>&1 || :
    # Fix: add systemd to shadow and gshadow
            grep -E -q '^(shadow|gshadow):.* systemd' /etc/nsswitch.conf ||
            sed -i.rpmorig -r -e '
                s/^(shadow|gshadow):.*/& systemd/
                ' /etc/nsswitch.conf >/dev/null 2>&1 || :
    # Fix: add [SUCCESS=merge] before systemd to group
            grep -E -q '^group:.*[SUCCESS=merge] systemd' /etc/nsswitch.conf ||
            sed -i.rpmorig -r -e '
		s/^(group:.*)(systemd)/\1[SUCCESS=merge] \2/
                ' /etc/nsswitch.conf >/dev/null 2>&1 || :
fi
update_chrooted all

%postun -n libnss-systemd
if [ "$1" = "0" ]; then
        if [ -f /etc/nsswitch.conf ] ; then
                sed -i.rpmorig -r -e '
                        /^(passwd|group):/ !b
                        s/[[:blank:]]+systemd\>//
                        ' /etc/nsswitch.conf >/dev/null 2>&1 || :
        fi
fi
update_chrooted all

%post -n libnss-resolve
if [ -f /etc/nsswitch.conf ] ; then
        grep -E -q '^hosts:.* resolve' /etc/nsswitch.conf ||
        sed -i.rpmorig -r -e '
                s/^(hosts:.*)(files)/\1resolve [!UNAVAIL=return] \2/
                ' /etc/nsswitch.conf >/dev/null 2>&1 || :
fi
update_chrooted all

%postun -n libnss-resolve
if [ "$1" = "0" ]; then
        if [ -f /etc/nsswitch.conf ] ; then
                sed -i.rpmorig -e '
                        /^hosts:/ !b
                        s/[[:blank:]]\+resolve\+[[:blank:]]*\[[^]]*\]*/      /
                        ' /etc/nsswitch.conf >/dev/null 2>&1 || :
        fi
fi
update_chrooted all

%post -n libnss-myhostname
if [ -f /etc/nsswitch.conf ] ; then
        grep -E -q '^hosts:.* myhostname' /etc/nsswitch.conf ||
        sed -i.rpmorig -r -e '
                s/^(hosts:.*)(dns)/\1myhostname \2/
                ' /etc/nsswitch.conf >/dev/null 2>&1 || :
    # Fix: move myhostname before dns
    if grep -E -q '^hosts:.* dns myhostname' /etc/nsswitch.conf ; then
        sed -i.rpmorig -r -e '
                s/^(hosts.*)(dns) (myhostname)/\1\3 \2/
                ' /etc/nsswitch.conf >/dev/null 2>&1 || :
    fi
    # Fix: move myhostname after files
    if grep -E -q '^hosts:.* myhostname.*files' /etc/nsswitch.conf ; then
        sed -i.rpmorig -r -e '
		s/^(hosts):(.*) myhostname(.*) files(.*)/\1:\2 files myhostname\3\4/
                ' /etc/nsswitch.conf >/dev/null 2>&1 || :
    fi
fi
update_chrooted all

%postun -n libnss-myhostname
if [ "$1" = "0" ]; then
        if [ -f /etc/nsswitch.conf ] ; then
                sed -i.rpmorig -e '
                        /^hosts:/ !b
                        s/[[:blank:]]\+myhostname\>//
                        ' /etc/nsswitch.conf >/dev/null 2>&1 || :
        fi
fi
update_chrooted all

%post -n libnss-mymachines
if [ -f /etc/nsswitch.conf ] ; then
        grep -E -q '^hosts:.* mymachines' /etc/nsswitch.conf ||
        sed -i.rpmorig -r -e '
                s/^(hosts):([ \t]*)(\s+)/\1:\2 mymachines\3/
                ' /etc/nsswitch.conf >/dev/null 2>&1 || :

# Cleanup. sinse v246 nss-mymachines: drop support for UID/GID resolving
        grep -v -E -q '^(passwd|group):.* mymachines' /etc/nsswitch.conf ||
        sed -i.rpmorig -r -e '
                /^(passwd|group):/ !b
                s/[[:blank:]]+mymachines\>//
                ' /etc/nsswitch.conf >/dev/null 2>&1 || :
fi
update_chrooted all

%postun -n libnss-mymachines
if [ "$1" = "0" ]; then
        if [ -f /etc/nsswitch.conf ] ; then
                sed -i.rpmorig -e '
                        /^hosts:/ !b
                        s/[[:blank:]]\+mymachines\>//
                        ' /etc/nsswitch.conf >/dev/null 2>&1 || :

        fi
fi

update_chrooted all

%if_enabled microhttpd
%pre journal-remote
groupadd -r -f systemd-journal-remote ||:
useradd -g systemd-journal-remote -c 'Journal Remote' \
    -d %_logdir/journal/remote -s /dev/null -r -l systemd-journal-remote >/dev/null 2>&1 ||:

%post journal-remote
%post_systemd_postponed systemd-journal-gatewayd.service systemd-journal-remote.service
%if_enabled libcurl
%post_systemd_postponed systemd-journal-upload.service
%endif

%preun journal-remote
%systemd_preun systemd-journal-gatewayd.service systemd-journal-remote.service systemd-journal-gatewayd.socket systemd-journal-remote.socket
%if_enabled libcurl
%systemd_preun systemd-journal-upload.service
%endif

if [ $1 -eq 1 ] ; then
    if [ -f %_sharedstatedir/%name/journal-upload/state -a ! -L %_sharedstatedir/%name/journal-upload ] ; then
        mkdir -p %_sharedstatedir/private/systemd/journal-upload
        mv %_sharedstatedir/%name/journal-upload/state %_sharedstatedir/private/systemd/journal-upload/
        rmdir %_sharedstatedir/%name/journal-upload || :
     fi
fi
%endif

%pre -n udev
groupadd -r -f cdrom >/dev/null 2>&1 ||:
groupadd -r -f tape >/dev/null 2>&1 ||:
groupadd -r -f dialout >/dev/null 2>&1 ||:
groupadd -r -f input >/dev/null 2>&1 ||:
groupadd -r -f video >/dev/null 2>&1 ||:
groupadd -r -f render >/dev/null 2>&1 ||:
groupadd -r -f sgx >/dev/null 2>&1 ||:
groupadd -r -f vmusers >/dev/null 2>&1 ||:

%post -n udev
systemd-hwdb update &>/dev/null
%post_service udevd

%preun -n udev
%preun_service udevd

%triggerpostun -n udev -- udev < 1:257.5-alt1
src=/etc/udev/udev.conf
dst=/etc/sysconfig/udevd
if [ -f $src ]; then
        if grep -q udev_tmpfs $src; then
                mv -fv $src $dst
        fi
fi

%pre sysctl-common
src=/etc/sysctl.conf
dst=/etc/sysctl.d/99-sysctl.conf.rpmmove
rm -f $dst
if [ -s $src -a ! -L $src ]; then
        cp -a $src $dst
fi

%post sysctl-common
src=/etc/sysctl.conf.rpmsave
dst=/etc/sysctl.d/99-sysctl.conf
tmp=$dst.rpmmove
new=$dst.rpmnew
if [ -s $tmp ]; then
        if cmp -s $src $tmp; then
            mv -v -f $dst $new
            mv -v $src $dst
        fi
        rm -f $tmp
fi


%pre modules-common
src=/etc/modules
dst=/etc/modules-load.d/modules.conf.rpmmove
rm -f $dst
if [ -s $src -a ! -L $src ]; then
        cp -a $src $dst
fi

%post modules-common
src=/etc/modules.rpmsave
dst=/etc/modules-load.d/modules.conf
tmp=$dst.rpmmove
new=$dst.rpmnew
if [ -s $tmp ]; then
        if cmp -s $src $tmp; then
            mv -v -f $dst $new
            mv -v $src $dst
        fi
        rm -f $tmp
fi

%files filesystem
%dir %_sysconfdir/systemd
%dir %_sysconfdir/systemd/system
%dir %_sysconfdir/systemd/system.conf.d
%dir %_sysconfdir/systemd/user
%dir %_sysconfdir/systemd/user.conf.d
%dir %_sysconfdir/systemd/ntp-units.d
%dir %_sysconfdir/systemd/system-generators
%dir %_sysconfdir/systemd/user-generators
%dir %_sysconfdir/systemd/system-preset
%dir %_sysconfdir/systemd/user-preset
%dir %_systemd_dir
%dir %_systemd_dir/profile.d
%dir %_systemd_dir/system.conf.d
%dir %_systemd_dir/user.conf.d
%dir %_systemd_dir/logind.conf.d
%dir %_systemd_dir/ntp-units.d
%dir %_systemd_dir/system-shutdown
%dir %_systemd_dir/system-sleep
%dir %_systemd_dir/catalog
%dir %_env_dir
%dir %_unitdir
%dir %_user_unitdir
%dir %_user_presetdir
%dir %_user_gen_dir
%dir %_user_env_gen_dir
%dir %_gen_dir
%dir %_env_gen_dir
%dir %_presetdir
%dir %_datadir/systemd
%dir %_sharedstatedir/%name
%dir %_sharedstatedir/%name/catalog
%dir %_sysconfdir/kernel
%dir %_sysconfdir/kernel/install.d
%dir %_prefix/lib/kernel
%dir %_kernel_installdir
%dir %_systemd_dir/initrd-preset

%files -f %name.lang
%_sbindir/init
%_sbindir/reboot
%_sbindir/halt
%_sbindir/poweroff
%_sbindir/shutdown
%_man1dir/init*
%_man8dir/halt*
%_man8dir/reboot*
%_man8dir/shutdown*
%_man8dir/poweroff*
%_initdir/README

%_systemd_dir/user.conf.d/env-path.conf

%config %_sysconfdir/profile.d/systemd.sh
%_sysconfdir/profile.d/*
%_systemd_dir/profile.d/*

%_tmpfilesdir/systemd-nologin.conf
%_tmpfilesdir/systemd.conf
%_tmpfilesdir/journal-nocow.conf
%_tmpfilesdir/provision.conf
%_tmpfilesdir/credstore.conf
%_tmpfilesdir/20-systemd-osc-context.conf
%_tmpfilesdir/20-systemd-shell-extra.conf
%_tmpfilesdir/20-systemd-ssh-generator.conf
%_tmpfilesdir/20-systemd-stub.conf
%_tmpfilesdir/20-systemd-userdb.conf

%_xdgconfigdir/%name
%_x11sysconfdir/xinit.d/50-systemd-user.sh

%ghost %config(noreplace) %_sysconfdir/systemd/journald.conf
%ghost %config(noreplace) %_sysconfdir/systemd/sleep.conf
%ghost %config(noreplace) %_sysconfdir/systemd/system.conf
%ghost %config(noreplace) %_sysconfdir/systemd/user.conf
%_systemd_dir/journald.conf
%_systemd_dir/sleep.conf
%_systemd_dir/system.conf
%_systemd_dir/user.conf

%_systemd_dir/ssh_config.d
%_systemd_dir/sshd_config.d
%_sysconfdir/openssh/ssh_config.d/20-systemd-ssh-proxy.conf
%_sysconfdir/openssh/sshd_config.d/20-systemd-userdb.conf
%config %_sysconfdir/pam.d/systemd-run0

%_rpmlibdir/systemd.filetrigger
%_rpmlibdir/systemd-user.filetrigger

%if "%_libdir" == "/usr/lib64"
%dir %_libdir/%name
%endif
%_libdir/%name/libsystemd-core-%ver_major.so
%_libdir/%name/libsystemd-shared-%ver_major.so

%_modprobedir/README
%_sysctldir/README
%_sysusersdir/README
%_tmpfilesdir/README

%_sbindir/systemctl
%_bindir/systemctl
%_man1dir/systemctl.*

%_bindir/journalctl
%_man1dir/journalctl.*
%if_enabled sysusers
%_sysusersdir/systemd-journal.conf
%endif

%_bindir/systemd-escape
%_mandir/*/*escape*

%_bindir/systemd-creds
%_man1dir/systemd-creds*

%_bindir/systemd-tmpfiles.shared
%_altdir/systemd-tmpfiles-shared
%_mandir/*/*tmpfiles*
%_tmpfilesdir/systemd-tmp.conf
%_systemd_dir/systemd-binfmt
%_rpmlibdir/systemd-binfmt.filetrigger
%_mandir/*/*binfmt*

%_bindir/systemd-sysusers.shared
%_altdir/systemd-sysusers-shared
%_mandir/*/*sysusers*

%_systemd_dir/systemd-modules-load
%_altdir/systemd-modules-load-shared
%_mandir/*/*modules-load*

%_bindir/systemd-repart.shared
%_altdir/systemd-repart-shared
%_mandir/*/*repart*
%_systemd_dir/repart

%_systemd_dir/systemd-shutdown
%_altdir/systemd-shutdown-shared
%_man8dir/systemd-shutdown*

%_systemd_dir/systemd-sysctl
%_altdir/systemd-sysctl-shared
%_mandir/*/*sysctl*

%_systemd_dir/systemd-backlight
%_mandir/*/*backlight*
%ghost %dir %_sharedstatedir/%name/backlight

%_systemd_dir/systemd-battery-check
%_mandir/*/*battery-check*

%_bindir/systemd-machine-id-setup
%_man8dir/systemd-machine-id-*

%_bindir/systemd-confext
%_man8dir/systemd-confext.*

%_bindir/systemd-sysext
%_man8dir/systemd-sysext.*

%_bindir/systemd-cryptenroll
%_man1dir/systemd-cryptenroll.*
%_man5dir/veritytab.*

%_bindir/varlinkctl
%_man1dir/varlinkctl.*

%_systemd_dir/systemd-executor
%_systemd_dir/systemd-storagetm
%_man8dir/systemd-storagetm.*

%_bindir/systemd-pty-forward
%_man1dir/systemd-pty-forward.*

%if_enabled firstboot
%_bindir/systemd-firstboot
%_man8dir/systemd-firstboot.*
%endif

%if_enabled qrencode
%_systemd_dir/systemd-bsod
%_man8dir/systemd-bsod.*
%endif

%ghost %config(noreplace) %_sysconfdir/machine-info
%ghost %config(noreplace) %_sysconfdir/hostname
%ghost %config(noreplace) %_sysconfdir/vconsole.conf
%ghost %config(noreplace) %_sysconfdir/locale.conf

%_sbindir/systemd
%_bindir/systemd-ask-password
%_bindir/systemd-inhibit

%_bindir/systemd-notify
%_bindir/systemd-tty-ask-password-agent

%if_enabled pstore
%ghost %config(noreplace) %_sysconfdir/systemd/pstore.conf
%_systemd_dir/pstore.conf
%_systemd_dir/systemd-pstore
%_man5dir/pstore.*
%_man8dir/systemd-pstore.*
%_tmpfilesdir/systemd-pstore.conf
%endif

%_bindir/busctl.shared
%_altdir/systemd-busctl-shared

%_bindir/systemd-socket-activate
%_bindir/systemd-cat
%_bindir/systemd-cgls
%_bindir/systemd-cgtop
%_bindir/systemd-delta
%_bindir/systemd-detect-virt
%_bindir/systemd-id128
%_bindir/systemd-mount
%_bindir/systemd-umount
%_bindir/systemd-path
%_bindir/systemd-run
%_bindir/systemd-vpick
%_bindir/run0
%_bindir/loginctl
%_systemd_dir/systemd-logind
%_bindir/userdbctl
%_systemd_dir/systemd-userdbd
%_systemd_dir/systemd-userwork
%_bindir/hostnamectl
%_systemd_dir/systemd-hostnamed
%_bindir/localectl
%_systemd_dir/systemd-localed
%_bindir/timedatectl
%_systemd_dir/systemd-timedated
%_bindir/oomctl
%_systemd_dir/systemd-oomd
%ghost %config(noreplace) %_sysconfdir/systemd/oomd.conf
%_systemd_dir/oomd.conf
%if_enabled sysusers
%_sysusersdir/systemd-oom.conf
%endif
%_bindir/systemd-stdio-bridge
%_man1dir/systemd-stdio-bridge*
%_systemd_dir/systemd
%_bindir/systemd-ac-power
%if_enabled libcryptsetup
%_bindir/systemd-cryptsetup
%_systemd_dir/systemd-cryptsetup
%_systemd_dir/systemd-integritysetup
%_systemd_dir/systemd-veritysetup
%_man5dir/crypttab*
%_man5dir/integritytab*
%_mandir/*/*cryptsetup*
%_man8dir/systemd-integritysetup*
%_man8dir/systemd-veritysetup*
%if_enabled tpm2
%_libdir/cryptsetup/libcryptsetup-token-systemd-tpm2.so
%endif
%if_enabled libfido2
%_libdir/cryptsetup/libcryptsetup-token-systemd-fido2.so
%endif
%if_enabled p11kit
%_libdir/cryptsetup/libcryptsetup-token-systemd-pkcs11.so
%endif
%endif
%_systemd_dir/systemd-boot-check-no-failures
%_systemd_dir/systemd-factory-reset
%_systemd_dir/systemd-fsck
%_systemd_dir/systemd-growfs
%_systemd_dir/systemd-hibernate-resume
%_systemd_dir/systemd-journald
%_systemd_dir/systemd-makefs
%_systemd_dir/systemd-quotacheck
%_systemd_dir/systemd-random-seed
%_systemd_dir/systemd-remount-fs
%_systemd_dir/systemd-reply-password
%_systemd_dir/systemd-rfkill
%_systemd_dir/systemd-sleep
%_systemd_dir/systemd-socket-proxyd
%_systemd_dir/systemd-ssh-issue
%_systemd_dir/systemd-ssh-proxy
%_systemd_dir/systemd-update-done
%_systemd_dir/systemd-update-helper
%_systemd_dir/systemd-update-utmp
%_systemd_dir/systemd-user-runtime-dir
%_systemd_dir/systemd-user-sessions
%_systemd_dir/systemd-validatefs
%_systemd_dir/systemd-vconsole-setup
%_systemd_dir/systemd-volatile-root
%_systemd_dir/systemd-sysroot-fstab-check
%_systemd_dir/systemd-sysv-install
%_systemd_dir/systemd-sulogin-shell
%_systemd_dir/systemd-xdg-autostart-condition
%_bindir/bootctl
%_man1dir/bootctl.*
%_man5dir/systemd.pcrlock*
%_systemd_dir/systemd-sbsign
%_man1dir/systemd-sbsign*
%_systemd_dir/systemd-keyutil
%_man1dir/systemd-keyutil*
%if_enabled tpm2
%_systemd_dir/systemd-measure
%_systemd_dir/systemd-pcrlock
%_prefix/lib/pcrlock.d
%if_enabled bootloader
%_systemd_dir/systemd-pcrextend
%_systemd_dir/systemd-tpm2-setup
%_systemd_dir/systemd-tpm2-clear
%_man1dir/systemd-measure*
%_man8dir/systemd-pcrlock*
%_man8dir/systemd-pcrfs*
%_man8dir/systemd-pcrphase*
%_man8dir/systemd-pcrextend*
%_man8dir/systemd-tpm2*
%endif
%endif

%_env_dir/99-environment.conf
%_mandir/man[58]/*environment*
#%%dir %%_systemd_dir/system.conf.d
#%%_systemd_dir/system.conf.d/env-path.conf

%_unitdir/*
%_gen_dir/*
%_user_unitdir/*
%_user_presetdir/*
%_user_gen_dir/*
%_user_env_gen_dir/*
%_systemd_dir/initrd-preset/*

%exclude %_gen_dir/systemd-import-generator
%exclude %_unitdir/system.slice.d/10-oomd-per-slice-defaults.conf
%exclude %_user_unitdir/slice.d/10-oomd-per-slice-defaults.conf

%if_enabled networkd
%exclude %_unitdir/*networkd*
%exclude %_unitdir/systemd-network-generator.service
%exclude %_unitdir/*resolv*
%exclude %_unitdir/*/*resolv*
%endif
%if_enabled timesyncd
%exclude %_unitdir/*timesyncd*
%exclude %_unitdir/*time-wait-sync*
%endif
%if_enabled microhttpd
%exclude %_unitdir/systemd-journal-gatewayd*
%exclude %_unitdir/systemd-journal-remote*
%endif
%if_enabled libcurl
%exclude %_unitdir/systemd-journal-upload*
%endif
%if_enabled efi
%exclude %_unitdir/systemd-boot-random-seed.service
%exclude %_unitdir/*/systemd-boot-random-seed.service
%exclude %_unitdir/systemd-bless-boot.service
%exclude %_unitdir/systemd-boot-update.service
%endif
%if_enabled coredump
%exclude %_unitdir/systemd-coredump*
%exclude %_unitdir/*/systemd-coredump*
%endif
%if_enabled homed
%exclude %_unitdir/systemd-homed*
%endif

%exclude %_unitdir/*udev*
%exclude %_unitdir/*/*udev*

%exclude %_unitdir/*.machine1.*
%exclude %_unitdir/*.import1.*
%exclude %_unitdir/*.portable1.*
%exclude %_unitdir/systemd-machined.service
%exclude %_unitdir/systemd-importd.*
%exclude %_unitdir/sockets.target.wants/systemd-importd.socket
%exclude %_unitdir/machine.slice
%exclude %_unitdir/machines.target
%exclude %_unitdir/*/machines.target
%exclude %_unitdir/var-lib-machines.mount
%exclude %_unitdir/*/var-lib-machines.mount
%exclude %_unitdir/systemd-mountfsd.*
%exclude %_unitdir/systemd-nsresourced.*
%exclude %_unitdir/systemd-nspawn@.service
%if_enabled vmspawn
%exclude %_unitdir/systemd-vmspawn@.service
%endif
%exclude %_unitdir/*/systemd-sysusers.service
%exclude %_unitdir/systemd-sysusers.service
%exclude %_unitdir/systemd-portabled.service

%_man1dir/busctl.*
%_man1dir/run0.*
%_man1dir/systemd-ac-power.*
%_mandir/*/systemd-ask-password*
%_man1dir/systemd-cat.*
%_man1dir/systemd-cgls.*
%_man1dir/systemd-cgtop.*
%_man1dir/systemd-delta.*
%_man1dir/systemd-detect-virt.*
%_man1dir/systemd-dissect.*
%_man1dir/systemd-inhibit.*
%_man1dir/systemd-id128.*
%_man1dir/systemd-mount.*
%_man1dir/systemd-umount.*
%_man1dir/systemd-notify.*
%_man1dir/systemd-path.*
%_man1dir/systemd-run.*
%_man1dir/systemd-vpick.*
%_man1dir/systemd-socket-activate.*
%_mandir/*/systemd-ssh*
%_mandir/*/systemd-tty-ask-password*
%_man1dir/systemd.*
%_mandir/*/*journald*
%_man5dir/capsule*
%_man5dir/localtime*
%_man5dir/*-release*
%_man5dir/*sleep.conf*
%_man5dir/*system.conf*
%_man5dir/*systemd1*
%_man5dir/*user*
%_man5dir/systemd.automount*
%_man5dir/systemd.exec*
%_man5dir/systemd.kill*
%_man5dir/systemd.mount*
%_man5dir/systemd.path*
%_man5dir/systemd.preset*
%_man5dir/systemd.resource-control*
%_man5dir/systemd.scope*
%_man5dir/systemd.service*
%_man5dir/systemd.slice*
%_man5dir/systemd.socket*
%_man5dir/systemd.swap*
%_man5dir/systemd.target*
%_man5dir/systemd.timer*
%_man5dir/systemd.unit*
%_mandir/*/*vconsole*

%_man7dir/*
%exclude %_man7dir/hwdb*
%exclude %_man7dir/udev*
%if_enabled efi
%exclude %_man7dir/systemd-boot*
%exclude %_man7dir/sd-boot*
%endif

%_man8dir/systemd-boot-check*
%_man8dir/systemd-confext-initrd*
%_man8dir/systemd-debug-generator*
%_man8dir/systemd-factory-reset*
%_man8dir/systemd-fsck*
%_man8dir/systemd-fstab-generator*
%_man8dir/systemd-getty-generator*
%_man8dir/systemd-gpt-auto-generator*
%_man8dir/systemd-growfs*
%_man8dir/systemd-loop*
%_man8dir/systemd-sysv-generator*
%_man8dir/systemd-hibernate*
%_man8dir/*sleep*
%_man8dir/systemd-kexec*
%_man8dir/systemd-makefs*
%_man8dir/systemd-mkswap*
%_man8dir/systemd-quota*
%_man8dir/systemd-random-seed*
%_man8dir/systemd-rc-local-generator*
%_man8dir/rc-local.service*
%_man8dir/systemd-remount*
%_man8dir/systemd-rfkill*
%_man8dir/systemd-run-generator*
%_man8dir/systemd-socket-proxyd*
%_man8dir/systemd-soft-reboot*
%_man8dir/systemd-suspend*
%_man8dir/systemd-sysext-initrd*
%_man8dir/systemd-system-update-generator*
%_man8dir/systemd-update-utmp*
%_man8dir/systemd-user-sessions*
%_man8dir/systemd-update-done*
%_man8dir/systemd-halt*
%_man8dir/systemd-reboot*
%_man8dir/systemd-poweroff*
%_man8dir/systemd-validatefs*
%_man8dir/systemd-volatile-root*
%_man8dir/systemd-xdg-autostart-generator*
%_mandir/*/*login*
%_mandir/*/*userdb*
%_mandir/*/*hostname*
%exclude %_man8dir/*myhostname*
%exclude %_man8dir/*mymachines*
%_mandir/*/*locale*
%_mandir/*/*timedate*
%_man5dir/*LogControl1*
%_mandir/*/*oom*

%exclude %_man3dir/*
%exclude %_datadir/factory
%exclude %_tmpfilesdir/etc.conf

%if_enabled efi
%exclude %_gen_dir/systemd-bless-boot-generator
%if_enabled bootloader
%exclude %_systemd_dir/boot
%endif
%endif
%if_enabled tests
%exclude %_systemd_dir/tests
%endif

%_presetdir/85-display-manager.preset
%_presetdir/90-default.preset
%_presetdir/90-systemd.preset
%_presetdir/99-default-disable.preset

%_udev_rulesdir/70-uaccess.rules
%_udev_rulesdir/71-seat.rules
%_udev_rulesdir/73-seat-late.rules
%_udev_rulesdir/90-vconsole.rules
%_udev_rulesdir/99-systemd.rules

%_datadir/systemd/kbd-model-map
%_datadir/systemd/language-fallback-map
%_datadir/mime/packages/io.systemd.xml

%_datadir/dbus-1/services/*
%ghost %config(noreplace) %_sysconfdir/systemd/logind.conf
%_systemd_dir/logind.conf
%_datadir/dbus-1/system.d/*
%exclude %_datadir/dbus-1/system.d/org.freedesktop.resolve1.conf
%exclude %_datadir/dbus-1/system.d/org.freedesktop.network1.conf
%exclude %_datadir/dbus-1/system.d/org.freedesktop.machine1.conf
%exclude %_datadir/dbus-1/system.d/org.freedesktop.import1.conf
%exclude %_datadir/dbus-1/system.d/org.freedesktop.timesync1.conf
%if_enabled homed
%exclude %_datadir/dbus-1/system.d/org.freedesktop.home1.conf
%endif
%_datadir/dbus-1/system-services/*
%exclude %_datadir/dbus-1/system-services/org.freedesktop.resolve1.service
%exclude %_datadir/dbus-1/system-services/org.freedesktop.network1.service
%exclude %_datadir/dbus-1/system-services/org.freedesktop.machine1.service
%exclude %_datadir/dbus-1/system-services/org.freedesktop.import1.service
%exclude %_datadir/dbus-1/system-services/org.freedesktop.portable1.service
%exclude %_datadir/dbus-1/system-services/org.freedesktop.timesync1.service
%if_enabled homed
%exclude %_datadir/dbus-1/system-services/org.freedesktop.home1.service
%endif

%if_enabled polkit
%_datadir/polkit-1/actions/*.policy
%_datadir/polkit-1/rules.d/10-systemd-logind-root-ignore-inhibitors.rules.example
%exclude %_datadir/polkit-1/actions/org.freedesktop.resolve1.policy
%exclude %_datadir/polkit-1/actions/org.freedesktop.network1.policy
%exclude %_datadir/polkit-1/actions/org.freedesktop.machine1.policy
%exclude %_datadir/polkit-1/actions/org.freedesktop.import1.policy
%exclude %_datadir/polkit-1/actions/org.freedesktop.portable1.policy
%if_enabled homed
%exclude %_datadir/polkit-1/actions/org.freedesktop.home1.policy
%endif
%endif

%ghost %dir %attr(2755, root, systemd-journal) %verify(not mode) %_logdir/journal
%ghost %attr(0700,root,root) %dir %_logdir/private
%ghost %attr(0700,root,root) %dir %_cachedir/private
%ghost %attr(0700,root,root) %dir %_sharedstatedir/private
%_logdir/README.logs
%_systemd_dir/catalog/*

%ghost %dir %_sharedstatedir/private/systemd
%_rpmlibdir/journal-catalog.filetrigger
%ghost %_sharedstatedir/%name/catalog/database
%ghost %_sharedstatedir/%name/random-seed
%ghost %_sharedstatedir/%name/linger

%_datadir/bash-completion/completions/*
%exclude %_datadir/bash-completion/completions/udevadm
%_datadir/zsh/site-functions/*
%exclude %_datadir/zsh/site-functions/_udevadm

%_defaultdocdir/%name-%version
# may be need adapt for ALTLinux?
%_bindir/kernel-install
%_man8dir/kernel-install.*
%_kernel_installdir/*
%_prefix/lib/kernel/install.conf
%exclude %_kernel_installdir/50-depmod.install
%exclude %_kernel_installdir/60-ukify.install

%files -n libsystemd
%_libdir/libsystemd.so.*

%files -n libsystemd-devel
%_libdir/*.so
%exclude %_libdir/*udev*.so
%_pkgconfigdir/*.pc
%exclude %_pkgconfigdir/*udev*.pc
%_datadir/pkgconfig/systemd.pc
%_includedir/systemd
%_man3dir/*
%_datadir/dbus-1/interfaces/*
%exclude %_man3dir/udev*
%exclude %_man3dir/libudev*

%if_enabled static_libsystemd
%files -n libsystemd-devel-static
%_libdir/libsystemd.a
%endif

%files -n libnss-systemd
%_libdir/libnss_systemd.so.*
%_man8dir/*nss?systemd.*

%files -n libnss-myhostname
%_libdir/libnss_myhostname.so.*
%_man8dir/*myhostname.*

%files -n libnss-mymachines
%_libdir/libnss_mymachines.so.*
%_man8dir/*mymachines.*

%files -n libnss-resolve
%_libdir/libnss_resolve.so.*
%_man8dir/*nss*resolve*

%files -n pam_%name
%config %_sysconfdir/pam.d/systemd-user
/%_lib/security/pam_systemd.so
/%_lib/security/pam_systemd_loadkey.so
%_man8dir/pam_systemd.*
%_man8dir/pam_systemd_loadkey.*

%if_enabled homed
%files -n pam_%{name}_home
/%_lib/security/pam_systemd_home.so
%_man8dir/pam_systemd_home.*

%files homed
%ghost %config(noreplace) %_sysconfdir/systemd/homed.conf
%_systemd_dir/homed.conf
%_bindir/homectl
%_bindir/systemd-home-fallback-shell
%_systemd_dir/systemd-homed
%_systemd_dir/systemd-homework
%_unitdir/systemd-homed*
%_datadir/dbus-1/system.d/org.freedesktop.home1.conf
%_datadir/dbus-1/system-services/org.freedesktop.home1.service
%if_enabled polkit
%_datadir/polkit-1/actions/org.freedesktop.home1.policy
%endif
%_man1dir/homectl.*
%_man5dir/*home*
%_mandir/*/systemd-homed*
%endif

%files tmpfiles-common
%_tmpfilesdir/legacy.conf
%_tmpfilesdir/x11.conf
%_tmpfilesdir/tmp.conf
%_tmpfilesdir/var.conf
%_tmpfilesdir/home.conf

%files sysctl-common
%config(noreplace) %_sysconfdir/sysctl.d/99-sysctl.conf
%_sysconfdir/sysctl.conf
%_sysctldir/10-map-count.conf
%_sysctldir/49-coredump-disable.conf
%_sysctldir/50-default.conf
%_sysctldir/50-net.conf
%_sysctldir/50-mmap-min-addr.conf
%if %_lib == lib64
%_sysctldir/50-pid-max.conf
%endif

%files modules-common
%config(noreplace) %verify(not md5 size mtime) %_sysconfdir/modules-load.d/modules.conf
%_sysconfdir/modules

%if_enabled networkd
%files networkd
%_bindir/networkctl
%ghost %config(noreplace) %_sysconfdir/systemd/networkd.conf
%ghost %config(noreplace) %_sysconfdir/systemd/resolved.conf
%_systemd_dir/networkd.conf
%_systemd_dir/resolved.conf
%_datadir/dbus-1/system.d/org.freedesktop.resolve1.conf
%_datadir/dbus-1/system.d/org.freedesktop.network1.conf
%_datadir/dbus-1/system-services/org.freedesktop.resolve1.service
%_datadir/dbus-1/system-services/org.freedesktop.network1.service
%if_enabled polkit
%_datadir/polkit-1/rules.d/systemd-networkd.rules
%_datadir/polkit-1/actions/org.freedesktop.network1.policy
%_datadir/polkit-1/actions/org.freedesktop.resolve1.policy
%endif
%_systemd_dir/systemd-network-generator
%_presetdir/85-networkd.preset
%_systemd_dir/systemd-networkd
%_systemd_dir/systemd-networkd-wait-online
%_systemd_dir/systemd-resolved
%_systemd_dir/resolv.conf
%_modprobedir/systemd.conf
%_bindir/resolvectl
%_bindir/systemd-resolve
# TODO: Provides: /sbin/resolvconf ?
%exclude %_sbindir/resolvconf
%_tmpfilesdir/systemd-network.conf
# TODO: package systemd-resolve.conf
%exclude %_tmpfilesdir/systemd-resolve.conf
%_unitdir/*networkd*
%_unitdir/systemd-network-generator.service
%_unitdir/*resolv*
%_unitdir/*/*resolv*
%_systemd_dir/network/80-6rd-tunnel.network
%_systemd_dir/network/80-auto-link-local.network.example
%_systemd_dir/network/80-container-host0.network
%_systemd_dir/network/80-wifi-adhoc.network
%_systemd_dir/network/80-wifi-ap.network.example
%_systemd_dir/network/80-wifi-station.network.example
%_systemd_dir/network/89-ethernet.network.example
%_mandir/*/*networkd*
%_mandir/*/systemd-network-generator*
%_mandir/*/*netdev*
%_mandir/*/*resolved*
%_mandir/*/*resolve1*
%_mandir/*/*network1*
%_mandir/*/*dnssd*
%_man1dir/networkctl.*
%_man1dir/resolvectl.*
%_man1dir/resolvconf.*
%_man5dir/dnssec-trust-anchors.d.*
%_man5dir/systemd.dns-delegate*
%_man5dir/systemd.negative.*
%_man5dir/systemd.positive.*
%_man5dir/systemd.network.*
%if_enabled sysusers
%_sysusersdir/systemd-network.conf
%_sysusersdir/systemd-resolve.conf
%endif
%endif

%files oomd-defaults
%_systemd_dir/oomd.conf.d/10-oomd-defaults.conf
%_unitdir/system.slice.d/10-oomd-per-slice-defaults.conf
%_user_unitdir/slice.d/10-oomd-per-slice-defaults.conf

%files container
%dir %_sysconfdir/systemd/nspawn
%_datadir/dbus-1/system.d/org.freedesktop.machine1.conf
%_datadir/dbus-1/system.d/org.freedesktop.import1.conf
%_bindir/importctl
%_bindir/machinectl
%_bindir/systemd-dissect
%_bindir/systemd-nspawn
%_sbindir/mount.ddi
%_systemd_dir/import-pubring.pgp
%_tmpfilesdir/systemd-nspawn.conf
%_unitdir/*.machine1.*
%_unitdir/*.import1.*
%_unitdir/systemd-machined.service
%_unitdir/systemd-importd.*
%_unitdir/sockets.target.wants/systemd-importd.socket
%_unitdir/systemd-mountfsd.*
%_unitdir/systemd-nsresourced.*
%_unitdir/machine.slice
%_unitdir/machines.target
%_unitdir/*/machines.target
%_unitdir/var-lib-machines.mount
%_unitdir/*/var-lib-machines.mount
%_unitdir/systemd-nspawn@.service
%_systemd_dir/systemd-machined
%_systemd_dir/systemd-export
%_systemd_dir/systemd-import*
%_systemd_dir/systemd-mountfsd
%_systemd_dir/systemd-mountwork
%_systemd_dir/systemd-nsresourced
%_systemd_dir/systemd-nsresourcework
%_systemd_dir/systemd-pull
%_gen_dir/systemd-import-generator
%_systemd_dir/network/80-container-host0-tun.network
%_systemd_dir/network/80-container-vb.network
%_systemd_dir/network/80-container-ve.network
%_systemd_dir/network/80-container-vz.network
%_systemd_dir/network/80-namespace-ns.network
%_systemd_dir/network/80-namespace-ns-tun.network
%_systemd_dir/network/80-vm-vt.network
%_datadir/dbus-1/system-services/org.freedesktop.machine1.service
%_datadir/dbus-1/system-services/org.freedesktop.import1.service
%if_enabled polkit
%_datadir/polkit-1/actions/org.freedesktop.import1.policy
%_datadir/polkit-1/actions/org.freedesktop.machine1.policy
%endif
%_mandir/*/*nspawn*
%_mandir/*/*mountfsd*
%_mandir/*/*nsresourced*
%_mandir/*/*machine*
%_mandir/*/*import*
%_mandir/*/*nspawn*
%_man1dir/mount.ddi.*
%exclude %_man3dir/*machine*
%exclude %_man8dir/*mymachines.*
%exclude %_man8dir/*machine-id*
%if_enabled vmspawn
%_bindir/systemd-vmspawn
%_unitdir/systemd-vmspawn@.service
%_mandir/*/*vmspawn*
%endif

%files portable
%_tmpfilesdir/portables.conf
%_unitdir/systemd-portabled.service
%_unitdir/*.portable1.*
%dir %_systemd_dir/portable
%dir %_systemd_dir/portable/profile
%_systemd_dir/portable/profile/*
%_bindir/portablectl
%_systemd_dir/systemd-portabled
%_datadir/dbus-1/system-services/org.freedesktop.portable1.service
%if_enabled polkit
%_datadir/polkit-1/actions/org.freedesktop.portable1.policy
%endif
%_mandir/*/*portable*

%if_enabled timesyncd
%files timesyncd
%ghost %config(noreplace) %_sysconfdir/systemd/timesyncd.conf
%_systemd_dir/timesyncd.conf
%_presetdir/85-timesyncd.preset
%_systemd_dir/systemd-timesyncd
%_systemd_dir/systemd-time-wait-sync
%_systemd_dir/ntp-units.d/80-systemd-timesync.list
%_datadir/dbus-1/system.d/org.freedesktop.timesync1.conf
%_datadir/dbus-1/system-services/org.freedesktop.timesync1.service
%_unitdir/systemd-timesyncd.service
%_unitdir/systemd-time-wait-sync.service
%_mandir/*/*timesync*
%_mandir/*/*time-wait-sync*
%ghost %dir %_sharedstatedir/%name/timesync
%ghost %_sharedstatedir/%name/timesync/clock
%if_enabled sysusers
%_sysusersdir/systemd-timesync.conf
%endif
%endif

%files analyze
%_bindir/systemd-analyze
%_man1dir/systemd-analyze.*

%if_enabled microhttpd
%files journal-remote
%dir %attr(2755,systemd-journal-remote,systemd-journal-remote) %_logdir/journal/remote
%ghost %config(noreplace) %_sysconfdir/systemd/journal-remote.conf
%_systemd_dir/journal-remote.conf
%_systemd_dir/systemd-journal-gatewayd
%_systemd_dir/systemd-journal-remote
%_unitdir/systemd-journal-gatewayd.*
%_unitdir/systemd-journal-remote*
%_datadir/systemd/gatewayd
%_man8dir/systemd-journal-gatewayd.*
%_man8dir/systemd-journal-remote.*
%_man5dir/journal-remote.conf.*
%_man5dir/journal-upload.conf.*

%if_enabled sysusers
%_sysusersdir/systemd-remote.conf
%endif

%if_enabled libcurl
%ghost %config(noreplace) %_sysconfdir/systemd/journal-upload.conf
%_systemd_dir/journal-upload.conf
%ghost %dir %_sharedstatedir/%name/journal-upload
%ghost %dir %_sharedstatedir/private/systemd/journal-upload
%_systemd_dir/systemd-journal-upload
%_unitdir/systemd-journal-upload.service
%_man8dir/systemd-journal-upload*
%endif
%endif

%if_enabled efi
%files boot-efi
%_man5dir/loader*
%_man7dir/systemd-boot*
%_man7dir/sd-boot*
%_man8dir/systemd-bless*
%_man8dir/systemd-boot*
%exclude %_man8dir/systemd-boot-check*
%if_enabled bootloader
%_gen_dir/systemd-bless-boot-generator
%_systemd_dir/systemd-bless-boot
%_unitdir/systemd-bless-boot.service
%_unitdir/systemd-boot-random-seed.service
%_unitdir/sysinit.target.wants/systemd-boot-random-seed.service
%_unitdir/systemd-boot-update.service
%dir %_systemd_dir/boot
%dir %_systemd_dir/boot/efi
%_systemd_dir/boot/efi/*
%endif

%files boot-efi-checkinstall
%endif

%if_enabled bootloader
%files ukify
%_bindir/ukify
%_systemd_dir/ukify
%_man1dir/ukify.*
%_prefix/lib/kernel/uki.conf
%_kernel_installdir/60-ukify.install
%endif

%if_enabled coredump
%files coredump
%ghost %config(noreplace) %_sysconfdir/systemd/coredump.conf
%_systemd_dir/coredump.conf
%_systemd_dir/systemd-coredump
%_bindir/*coredumpctl
%_sysctldir/50-coredump.conf
%_unitdir/systemd-coredump*
%_unitdir/*/systemd-coredump*
%_man1dir/*coredumpctl.*
%_man5dir/coredump.conf.*
%_man8dir/systemd-coredump*
%dir %_sharedstatedir/%name/coredump
%if_enabled sysusers
%_sysusersdir/systemd-coredump.conf
%endif
%endif

%files stateless
%dir %_datadir/factory
%_datadir/factory/*
%if_enabled ldconfig
%_unitdir/ldconfig.service
%_unitdir/sysinit.target.wants/ldconfig.service
%endif
%if_enabled sysusers
%_unitdir/systemd-sysusers.service
%_unitdir/sysinit.target.wants/systemd-sysusers.service
%_sysusersdir/basic.conf
%_tmpfilesdir/etc.conf
%endif

%if_enabled standalone_binaries
%files utils-standalone
%_bindir/busctl.standalone
%_altdir/systemd-busctl-standalone

%_systemd_dir/systemd-modules-load.standalone
%_altdir/systemd-modules-load-standalone

%_bindir/systemd-repart.standalone
%_altdir/systemd-repart-standalone

%_systemd_dir/systemd-shutdown.standalone
%_altdir/systemd-shutdown-standalone

%_systemd_dir/systemd-sysctl.standalone
%_altdir/systemd-sysctl-standalone

%if_enabled sysusers
%_bindir/systemd-sysusers.standalone
%_altdir/systemd-sysusers-standalone
%endif #sysuser

%_bindir/systemd-tmpfiles.standalone
%_altdir/systemd-tmpfiles-standalone
%endif

%files utils-filetriggers
%_rpmlibdir/systemd-tmpfiles.filetrigger
%_rpmlibdir/systemd-sysusers.filetrigger
%_rpmlibdir/systemd-modules-load.filetrigger
%_rpmlibdir/systemd-sysctl.filetrigger

%if_enabled tests
%files tests
%_systemd_dir/tests
# TODO: fix sisyphus_check
# sisyphus_check: check-systemd ERROR: systemd unit path violation
%exclude %_systemd_dir/tests/mkosi/mkosi.*/%_unitdir/*.service
%exclude %_systemd_dir/tests/mkosi/mkosi.*/*/*/%_unitdir/*.service
%endif

%files -n libudev1
%_libdir/libudev.so.*

%files -n libudev-devel
%_includedir/libudev.h
%_libdir/libudev.so
%_pkgconfigdir/libudev.pc
%_datadir/pkgconfig/udev.pc
%_man3dir/udev*
%_man3dir/libudev*

%if_enabled static_libudev
%files -n libudev-devel-static
%_libdir/libudev.a
%endif

%files -n udev
%dir %_sysconfdir/systemd/network
%dir %_sysconfdir/udev
%dir %_sysconfdir/udev/rules.d
%dir %_sysconfdir/udev/hwdb.d
%ghost %config(noreplace) %_sysconfdir/udev/*.conf
%ghost %_sysconfdir/udev/hwdb.bin
%config(noreplace) %_sysconfdir/scsi_id.config
%config(noreplace) %_sysconfdir/sysconfig/udevd
%_initdir/udev*
%_unitdir/*udev*
%_unitdir/*/*udev*
%dir %_systemd_dir/network
%_systemd_dir/network/*.link
%_tmpfilesdir/static-nodes-permissions.conf
%dir %_udevdir
%_udevdir/*
%_bindir/udevadm
%_sbindir/udevadm
%_sbindir/udevd
%_bindir/systemd-hwdb
%_systemd_dir/systemd-udevd
%_rpmlibdir/udev.filetrigger
%_rpmlibdir/udev-hwdb.filetrigger
%_mandir/*/*udev*
%_mandir/*/*hwdb*
%_mandir/*/*.link*
%_man5dir/systemd.device*
%_man5dir/iocost*
%exclude %_man3dir/*
%_datadir/bash-completion/completions/udevadm
%_datadir/zsh/site-functions/_udevadm

# systemd
%exclude %_udev_rulesdir/70-uaccess.rules
%exclude %_udev_rulesdir/71-seat.rules
%exclude %_udev_rulesdir/73-seat-late.rules
%exclude %_udev_rulesdir/90-vconsole.rules
%exclude %_udev_rulesdir/99-systemd.rules

%changelog
