%def_disable snapshot
%define ver_major 8.0
%define api_ver 3

Name: switchboard
%define xdg_name org.pantheon.%name
%define rdn_name io.elementary.settings
Version: %ver_major.3
Release: alt1

Summary: Modular Desktop Settings Hub for elementary OS
License: LGPL-2.1-or-later
Group: Graphical desktop/Other
Url: https://github.com/elementary/switchboard

Vcs: https://github.com/elementary/switchboard.git

%if_disabled snapshot
Source: %url/archive/%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

Provides: %rdn_name = %EVR
Requires: lib%name = %EVR

%define granite_ver 7.0.0
%define adw_ver 1.4

BuildRequires(pre): rpm-macros-meson rpm-build-vala
BuildRequires: meson vala-tools gcc-c++ sassc
BuildRequires: pkgconfig(granite-7) >= %granite_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver
BuildRequires: vapi(granite-7)

%description
This package provides Switchboard a system settings application for Elementary OS.

%package -n lib%name
Summary: Switchboard Library
Group: System/Libraries

%description -n lib%name
This package provides shared library needed for Switchboard to work.

%package -n lib%name-devel
Summary: Switchboard Library - development files
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
This package contains files that are needed to develop Switchboard plugins.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install
%find_lang %rdn_name

%files -f %rdn_name.lang
%_bindir/%rdn_name
%_desktopdir/%rdn_name.desktop
%_datadir/dbus-1/services/%rdn_name.service
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_iconsdir/hicolor/*x*/*/%rdn_name.*
%_datadir/metainfo/%rdn_name.appdata.xml

%files -n lib%name
%_libdir/lib%name-%api_ver.so.*

%files -n lib%name-devel
%_includedir/%name-%api_ver/
%_libdir/lib%name-%api_ver.so
%_pkgconfigdir/%name-%api_ver.pc
%_vapidir/%name-%api_ver.deps
%_vapidir/%name-%api_ver.vapi

%changelog
