Name: sway
Version: 1.11
Release: alt1
Epoch:   1

Summary: i3wm drop-in replacement for Wayland
License: MIT
Group: Graphical desktop/Other
Url: http://swaywm.org/

Provides: sway-data = %EVR
Obsoletes: sway-data

Source: %name-%version.tar

BuildRequires: asciidoc-a2x
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: libpam-devel
BuildRequires: meson
BuildRequires: pkgconfig(dbus-1)
BuildRequires: pkgconfig(egl)
BuildRequires: pkgconfig(gdk-pixbuf-2.0)
BuildRequires: pkgconfig(json-c)
BuildRequires: pkgconfig(libcap)
BuildRequires: pkgconfig(libdrm)
BuildRequires: pkgconfig(libevdev)
BuildRequires: pkgconfig(libinput) >= 1.26.0
BuildRequires: pkgconfig(libpcre2-8)
BuildRequires: pkgconfig(libsystemd)
BuildRequires: pkgconfig(pango)
BuildRequires: pkgconfig(wayland-client)
BuildRequires: pkgconfig(wayland-cursor)
BuildRequires: pkgconfig(wayland-egl)
BuildRequires: pkgconfig(wayland-protocols)
BuildRequires: pkgconfig(wayland-server)
BuildRequires: pkgconfig(wlroots-0.19)
BuildRequires: pkgconfig(xcb-icccm)
BuildRequires: pkgconfig(xkbcommon) >= 1.5.0
BuildRequires: scdoc
BuildRequires: time

# swaybg is now distributed as a standalone program which is compatible with many Wayland compositors (sway 1.1-rc1)
Requires: swaybg

# swayidle, a new idle management daemon, is available separately (sway 1.0)
Requires: swayidle

Requires: foot
Requires: wmenu

%description
Sway is a drop-in replacement for the i3 window manager, but for Wayland
instead of X11. It works with your existing i3 configuration and
supports most of i3's features, and a few extras.

%prep
%setup

%build
%meson \
	-Dwerror=false \
	-Dzsh-completions=false \
	-Dbash-completions=false \
	-Dfish-completions=false \
	#
%meson_build

%install
%meson_install

mkdir -p %buildroot/%_sysconfdir/%name/config.d
install -pm0755 -D startsway.sh %buildroot%_bindir/startsway
install -pm0644 -D Sway_Wallpaper_Gray.png %buildroot%_datadir/backgrounds/sway/Sway_Wallpaper_Gray.png

%files
%doc LICENSE
%doc README.md
%dir %_sysconfdir/%name
%dir %_sysconfdir/%name/config.d
%config(noreplace) %_sysconfdir/%name/config
%_bindir/sway
%_bindir/startsway
%_bindir/swaybar
%_bindir/swaymsg
%_bindir/swaynag
%_datadir/backgrounds/sway
%_datadir/wayland-sessions/sway.desktop
%_man1dir/*
%_man5dir/*
%_man7dir/*

%changelog
