%define _unpackaged_files_terminate_build 1

%define sover 7

%ifarch %ix86
%def_without check
%else
%def_with check
%endif

Name: superlu
Version: 7.0.1
Release: alt1
Summary: A set of subroutines to solve a sparse linear system A*X=B
License: BSD and GPLv2+
Group: Sciences/Mathematics
Url: https://github.com/xiaoyeli/superlu

VCS: https://github.com/xiaoyeli/superlu.git
Source: %name-%version.tar

# Patch from Gentoo
Patch1: superlu-5.2.2-no-internal-blas.patch

# ALT Patch
Patch10: superlu-6.0.1-respect-flags.patch

Provides: %name = %EVR
Requires: lib%name%sover = %EVR

BuildRequires: cmake
BuildRequires: ctest
BuildRequires: gcc-fortran gcc-c++ libflexiblas-devel
BuildRequires: csh doxygen graphviz ghostscript-utils

%description
SuperLU contains a set of subroutines to solve a sparse linear system
A*X=B. It uses Gaussian elimination with partial pivoting (GEPP).
The columns of A may be preordered before factorization; the
preordering for sparsity is completely separate from the factorization.
SuperLU provides functionality for both real and complex matrices, in both
single and double precision.

%package -n lib%name%sover
Summary: Shared libraries of SuperLU
Group: System/Libraries

%description -n lib%name%sover
SuperLU contains a set of subroutines to solve a sparse linear system
A*X=B. It uses Gaussian elimination with partial pivoting (GEPP).
The columns of A may be preordered before factorization; the
preordering for sparsity is completely separate from the factorization.
SuperLU provides functionality for both real and complex matrices, in both
single and double precision.

This package contains shared libraries of SuperLU.

%package -n lib%name-devel
Summary: Development files of SuperLU
Group: Development/C
Requires: lib%name%sover = %EVR

%description -n lib%name-devel
SuperLU contains a set of subroutines to solve a sparse linear system
A*X=B. It uses Gaussian elimination with partial pivoting (GEPP).
The columns of A may be preordered before factorization; the
preordering for sparsity is completely separate from the factorization.
SuperLU provides functionality for both real and complex matrices, in both
single and double precision.

This package contains development files of SuperLU.

%package -n lib%name-devel-doc
Summary: Documentation for SuperLU
Group: Development/Documentation
BuildArch: noarch

%description -n lib%name-devel-doc
SuperLU contains a set of subroutines to solve a sparse linear system
A*X=B. It uses Gaussian elimination with partial pivoting (GEPP).
The columns of A may be preordered before factorization; the
preordering for sparsity is completely separate from the factorization.
SuperLU provides functionality for both real and complex matrices, in both
single and double precision.

This package contains documentation for SuperLU.

%prep
%setup
%patch1 -p1
%patch10 -p1

%build
%cmake \
	-DCMAKE_BUILD_TYPE:STRING=Release \
	-DCMAKE_INSTALL_INCLUDEDIR="include/superlu" \
	-DBUILD_SHARED_LIBS=ON \
	-Denable_internal_blaslib=OFF \
	-DTPL_BLAS_LIBRARIES="`pkg-config --libs flexiblas`" \
	-Denable_tests=ON \
	%nil

%cmake_build

%install
%cmake_install

%check
cd %_cmake__builddir
ctest

%files -n lib%name%sover
%doc License.txt
%doc README
%_libdir/*.so.%{sover}
%_libdir/*.so.%{sover}.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%_libdir/cmake/*

%files -n lib%name-devel-doc
%doc DOC/html
%doc EXAMPLE
%doc FORTRAN

%changelog
