Name: ssmtp
Summary: ssmtp - extremely simple MTA to get mail off the system to a mail hub
Version: 2.64
Release: alt6
License: GPL-2.0-or-later
Group: System/Servers
BuildRequires: libssl-devel
Url: https://packages.debian.org/stable/mail/ssmtp
VCS: https://salsa.debian.org/debian/ssmtp.git
Source: %name-%version.tar
Patch1: ssmtp-2.64-fedora-md5auth-non-rsa.patch
Patch2: ssmtp-2.64-fedora-garbage_writes.patch
Patch3: ssmtp-2.64-fedora-authpass.patch
Patch4: ssmtp-2.64-fedora-aliases.patch
Patch5: ssmtp-2.64-fedora-remote-addr.patch
Patch6: ssmtp-2.64-fedora-validate-TLS-server-cert.patch
Patch7: ssmtp-2.64-defaultvalues.patch
Patch8: ssmtp-2.64-fedora-c99.patch
Patch9: ssmtp-2.64-fedora-configure-c99.patch
Conflicts: sendmail sendmail-submit
Conflicts: postfix
Conflicts: masqmail
Conflicts: exim exim-common
Provides: MTA
Requires: ssmtp-common = %version-%release

%description
extremely simple MTA to get mail off the system to a mail hub
A secure, effective and simple way of getting mail off a system to your
mail hub. It contains no suid-binaries or other dangerous things - no mail
spool to poke around in, and no daemons running in the background. Mail is
simply forwarded to the configured mailhost. Extremely easy configuration.
WARNING: the above is all it does; it does not receive mail, expand aliases
or manage a queue. That belongs on a mail hub with a system administrator.


%package common
Summary: ssmtp - common files
Group: System/Servers
Conflicts: exim-common
Requires: sendmail-common %_sbindir/mailq %_sbindir/newaliases
Requires: ssmtp-tools = %EVR

%description common
extremely simple MTA to get mail off the system to a mail hub
A secure, effective and simple way of getting mail off a system to your
mail hub. It contains no suid-binaries or other dangerous things - no mail
spool to poke around in, and no daemons running in the background. Mail is
simply forwarded to the configured mailhost. Extremely easy configuration.
WARNING: the above is all it does; it does not receive mail, expand aliases
or manage a queue. That belongs on a mail hub with a system administrator.

%package tools
Summary: ssmtp - ssmtp and ssmtp-ssl executables
Group: System/Servers

%description tools
ssmtp-tools contains ssmtp and ssmtp-ssl executables.

%package docs
Summary: ssmtp documentation
Group: System/Servers

%description docs
extremely simple MTA to get mail off the system to a mail hub
A secure, effective and simple way of getting mail off a system to your
mail hub. It contains no suid-binaries or other dangerous things - no mail
spool to poke around in, and no daemons running in the background. Mail is
simply forwarded to the configured mailhost. Extremely easy configuration.
WARNING: the above is all it does; it does not receive mail, expand aliases
or manage a queue. That belongs on a mail hub with a system administrator.


%prep
%setup
%autopatch -p1

%build
%configure --enable-ssl --enable-md5suth  --enable-inet6
%make_build

%install
mkdir -p %buildroot{%_sbindir,%_sysconfdir/%name,%_man8dir}
install %name %buildroot%_sbindir/%name
install -m 644 %name.conf %buildroot%_sysconfdir/%name
install -m 644 revaliases %buildroot%_sysconfdir/%name
install -m 644 %name.8 %buildroot%_man8dir
ln -sf %_sbindir/%name %buildroot%_sbindir/sendmail

%files
%_sbindir/sendmail

%files tools
%_sbindir/%name
%_man8dir/*
%config(noreplace) %_sysconfdir/%name/%name.conf

%files common
%config(noreplace) %_sysconfdir/%name/revaliases

%files docs
%doc README TLS CHANGELOG_OLD INSTALL COPYING debian/changelog

%changelog
