%define _unpackaged_files_terminate_build 1

Name:     srpm-cleanup
Version:  0.1.4
Release:  alt1

Summary:  Remove unused source files from SRPM packages
License:  GPL-3.0-or-later
Group:    Development/Tools
Url:      http://git.altlinux.org/people/manowar/packages/srpm-cleanup.git

Packager: Paul Wolneykien <manowar@altlinux.org>

Source:   %name-%version.tar

BuildArch: noarch
BuildRequires: ronn perl(Pod/Usage.pm) pandoc >= 2

Requires: make apt-repo-tools rsync time findutils coreutils gear
Requires: %name-parallel = %version-%release
Requires: %name-common = %version-%release

%description
srpm-cleanup(1) removes unused source files from SRPM packages.
The list of unused files can be obtained with hsh-separate-sources(1).

This package should be installed on the main management host.


%package audit
Summary:  Default audit on/off scripts for %name
Group:    Development/Tools
License:  GPL-3.0-or-later
Requires: audit
Requires: %name-common = %version-%release

%description audit
Provides the default audit on/off scripts for %name.

This package should be installed on the hosts that build packages.


%package parallel
Summary:  "GNU" Parallel used in srpm-cleanup scripts
Group:    Development/Tools
License:  GPL-3.0-or-later

%description parallel
A "GNU" Parallel version with special patches used in srpm-cleanup
scripts.


%package common
Summary:  Common files for %name
Group:    Development/Tools
License:  GPL-3.0-or-later

%description common
Provides common files for %name.


%prep
%setup

%build
%autoreconf
%configure
%make_build

%install
%makeinstall_std

%files
%_bindir/hsh-separate-sources
%_bindir/srpm-cleanup
%_datadir/%name/import-logs.pl
%_datadir/%name/main.mk
%_datadir/%name/exceptions.list
%_datadir/%name/exclude.list
%_datadir/%name/nprofile
%_man1dir/hsh-separate-sources.1*
%_man1dir/srpm-cleanup.1*
%_man7dir/make-srpm-cleanup.7*
%dir %_docdir/%name
%_docdir/%name/*

%files audit
%_datadir/%name/audit_on
%_datadir/%name/audit_off

%files parallel
%_bindir/parallel_alt

%files common
%dir %_datadir/%name


%changelog
