Name: squashfs-tools
Version: 4.7
Release: alt1

Summary: squashfs support
License: GPLv2
Group: System/Kernel and hardware
Url: https://github.com/plougher/squashfs-tools
Source: %name-%version.tar
Patch0: %name-%version-%release.patch
BuildRequires: zlib-devel
BuildRequires: liblzma-devel
BuildRequires: liblzo2-devel
BuildRequires: libzstd-devel
BuildRequires: liblz4-devel
Provides: squashfsprogs = %version-%release
Obsoletes: squashfsprogs

%description
Squashfs is a compressed read-only filesystem for Linux. Squashfs is
intended for general read-only filesystem use, for archival use
(i.e. in cases where a .tar.gz file may be used), and in constrained
block device/memory systems (e.g. embedded systems) where low overhead
is needed.

This package contains the utilities to (un)compress squashfs images.

%prep
%setup
%patch0 -p1

%build
export CFLAGS="%optflags"
pushd squashfs-tools
%make_build XZ_SUPPORT=1 LZO_SUPPORT=1 ZSTD_SUPPORT=1 COMP_DEFAULT=xz
popd

%install
pushd Documentation/manpages
install -pDm755 mksquashfs.1 %buildroot%_man1dir/mksquashfs.1
install -pDm755 unsquashfs.1 %buildroot%_man1dir/unsquashfs.1
install -pDm755 sqfstar.1 %buildroot%_man1dir/sqfstar.1
install -pDm755 sqfscat.1 %buildroot%_man1dir/sqfscat.1
popd

pushd squashfs-tools
install -pDm755 mksquashfs %buildroot%_sbindir/mksquashfs
install -pDm755 unsquashfs %buildroot%_bindir/unsquashfs
install -pDm755 sqfstar %buildroot%_bindir/sqfstar
install -pDm755 sqfscat %buildroot%_bindir/sqfscat
ln -sf mksquashfs %buildroot%_sbindir/mkfs.squashfs
ln %buildroot%_sbindir/mksquashfs %buildroot%_bindir/mksquashfs
popd

%files
%doc CHANGES Documentation/%version/*
%_sbindir/*
%_bindir/*
%_man1dir/*

%changelog
