%define rel -beta
%global _localstatedir %_var
%def_with mysql
%def_with pgsql

Name: sphinx
Version: 2.3.2
Release: alt5.1

Summary: Free open-source SQL full-text search engine

Group: Text tools
License: GPLv2+
Url: http://sphinxsearch.com

# Source0-url: http://sphinxsearch.com/files/%name-%version%rel.tar.gz
Source0: %name-%version.tar
Source1: %name.init
Source2: %name.unit

Patch0: sphinx-crash.patch
Patch1: sphinx-2.3.2-alt-fix-gcc14-build.patch

BuildRequires: gcc-c++ libexpat-devel
BuildRequires: libssl-devel zlib-devel libstemmer-devel
BuildRequires: libunixODBC-devel
%if_with mysql
BuildRequires: libmysqlclient-devel
%endif
%if_with pgsql
BuildRequires: postgresql-devel
%endif

# due /usr/share/man/man1/indexer.1.xz and created by mnogosearch link /usr/bin/indexer
Conflicts: mnogosearch

%description
Sphinx is a full-text search engine, distributed under GPL version 2.
Commercial licensing (eg. for embedded use) is also available upon request.

Generally, it's a standalone search engine, meant to provide fast,
size-efficient and relevant full-text search functions to other applications.
Sphinx was specially designed to integrate well with SQL databases and
scripting languages.

Currently built-in data source drivers support fetching data either via direct
connection to MySQL, or PostgreSQL, or from a pipe in a custom XML format.
Adding new drivers (eg. to natively support some other DBMSes) is designed to
be as easy as possible.

Search API is natively ported to PHP, Python, Perl, Ruby, Java, and also
available as a pluggable MySQL storage engine. API is very lightweight so
porting it to new language is known to take a few hours.

As for the name, Sphinx is an acronym which is officially decoded as SQL Phrase
Index. Yes, I know about CMU's Sphinx project.

%package -n libsphinxclient
Summary: Pure C searchd client API library
Group: System/Libraries

%description -n libsphinxclient
Pure C searchd client API library
Sphinx search engine, http://sphinxsearch.com

%package -n libsphinxclient-devel
Summary: Development libraries and header files for libsphinxclient
Group: System/Libraries
Requires: libsphinxclient = %version-%release

%description -n libsphinxclient-devel
Pure C searchd client API library
Sphinx search engine, http://sphinxsearch.com

%package -n libsphinxclient-devel-static
Summary: Development libraries and header files for libsphinxclient
Group: System/Libraries
Requires: libsphinxclient-devel = %version-%release
Conflicts: libsphinxclient-static

%description -n libsphinxclient-devel-static
Pure C searchd client API library
Sphinx search engine, http://sphinxsearch.com

%prep
%setup
%patch0 -p2
%patch1

# Fix wrong-file-end-of-line-encoding
sed -i 's/\r//' api/ruby/spec/sphinx/sphinx_test.sql
sed -i 's/\r//' api/java/mk.cmd
sed -i 's/\r//' api/ruby/spec/fixtures/keywords.php
sed -i 's/\r//' api/ruby/lib/sphinx/response.rb

%build
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%configure --sysconfdir=/etc/sphinx %{subst_with mysql} %{subst_with pgsql} --with-libstemmer

%make_build

# Build libsphinxclient
pushd api/libsphinxclient/
export CCPP=/usr/bin/cpp
export CXXCPP=/usr/bin/cpp
%configure
make
popd

%install
make install DESTDIR=%buildroot INSTALL="%__install -p -c"

# Install sphinx initscript
install -p -D -m 0755 %SOURCE1 %buildroot%_initdir/searchd
install -p -D -m 0644 %SOURCE2 %buildroot%_unitdir/searchd.service

# Create /var/log/sphinx
mkdir -p %buildroot%_var/log/sphinx

# Create /var/lib/sphinx
mkdir -p %buildroot%_var/lib/sphinx

# Create sphinx.conf
cp %buildroot%_sysconfdir/sphinx/sphinx-min.conf.dist \
    %buildroot%_sysconfdir/sphinx/sphinx.conf

# Modify sphinx.conf
sed -i 's/\/var\/log\/searchd.log/\/var\/log\/sphinx\/searchd.log/g' \
%buildroot%_sysconfdir/sphinx/sphinx.conf

sed -i 's/\/var\/log\/query.log/\/var\/log\/sphinx\/query.log/g' \
%buildroot%_sysconfdir/sphinx/sphinx.conf

sed -i 's/\/var\/log\/searchd.pid/\/var\/run\/sphinx\/searchd.pid/g' \
%buildroot%_sysconfdir/sphinx/sphinx.conf

sed -i 's|/var/data|/var/lib/sphinx|g' \
%buildroot%_sysconfdir/sphinx/sphinx.conf

# Create /etc/logrotate.d/sphinx
mkdir -p %buildroot%_sysconfdir/logrotate.d
cat > %buildroot%_sysconfdir/logrotate.d/sphinx << EOF
/var/log/sphinx/*.log {
       weekly
       rotate 10
       copytruncate
       delaycompress
       compress
       notifempty
       missingok
       su _sphinx _sphinx
       postrotate
       killall -SIGUSR1 searchd
       endscript
}
EOF

# Create tmpfiles run configuration
mkdir -p %buildroot%_tmpfilesdir
cat > %buildroot%_tmpfilesdir/%name.conf << EOF
d /run/sphinx 755 _sphinx root -
EOF

# Install libsphinxclient
cd api/libsphinxclient/
make install DESTDIR=%buildroot INSTALL="%__install -p -c"

%pre
%_sbindir/groupadd -r -f _sphinx &>/dev/null
%_sbindir/useradd -r -n -g _sphinx -d /var/empty -s /bin/false -c "Sphinx Searchd pseudo user" _sphinx >/dev/null 2>&1 ||:

%post
%post_service searchd

%preun
%preun_service searchd

%files
%doc COPYING doc/sphinx.txt sphinx-min.conf.dist sphinx.conf.dist example.sql
%dir %attr(775,root,_sphinx) %_sysconfdir/sphinx
%config(noreplace) %attr(644,root,_sphinx) %_sysconfdir/sphinx/sphinx.conf
%config(noreplace) %attr(644,root,root) %_tmpfilesdir/%name.conf
%exclude %_sysconfdir/sphinx/*.conf.dist
%exclude %_sysconfdir/sphinx/example.sql
%_initdir/*
%_unitdir/*
%config(noreplace) %_sysconfdir/logrotate.d/sphinx
%_bindir/*
%dir %attr(775,root,_sphinx) %_var/log/sphinx
%dir %attr(775,root,_sphinx) %_var/lib/sphinx
%_man1dir/*

%files -n libsphinxclient
%doc api/java api/ruby api/*.php api/*.py api/libsphinxclient/README
%_libdir/libsphinxclient-0*.so

%files -n libsphinxclient-devel
%_libdir/libsphinxclient.so
%_includedir/*

%files -n libsphinxclient-devel-static
%_libdir/libsphinxclient.a

%changelog
