%define gtkver 2

Name: spacefm
Version: 1.0.6
Release: alt5
Summary: Multi-panel tabbed file and desktop manager
License: GPLv3+ and LGPLv3+
Group: File tools
Url: http://ignorantguru.github.io/spacefm
Source0: %name-%version.tar
Source1: %name.conf
Source2: session

Patch0: spacefm-1.0.6-major-glibc228.patch
# Patch to compile with gcc10 -fno-common
Patch1: spacefm-1.0.6-gcc10-fno-common.patch

Patch2: spacefm-1.0.6-deb-fix-ftbfs-gcc14.patch
Patch3: spacefm-1.0.6-deb-update_desktop_files.patch
Patch4: spacefm-1.0.6-deb-fix_thumbnails.patch
Patch5: spacefm-1.0.6-deb-add_optional_close_last_tab.patch
Patch6: spacefm-1.0.6-deb-drop-gnome-common-macros.patch
Patch7: spacefm-1.0.6-deb-drop_spacefm-installer.patch

BuildRequires: intltool libgtk+%gtkver-devel libudev-devel

Requires: unzip zip
# Mount without root requirement.
Requires: udisks2

%description
SpaceFM is a multi-panel tabbed file and desktop manager for GNU/Linux
with built-in VFS, udev-based device manager, customizable menu system
and bash integration. SpaceFM is popular among novice and power users
alike for its stability, speed, convenience and flexibility.

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1

%build
%autoreconf
%configure \
  --with-preferable-sudo=%_bindir/xdg-su \
  --htmldir=%_docdir/%name-%version \
  --disable-video-thumbnails \
  --with-gtk%gtkver
%make_build

%install
%makeinstall_std
#install -Dp -m 0644 %SOURCE1 %buildroot/%_sysconfdir/%name/%name.conf
install -Dp -m 0644 %SOURCE2 %buildroot/%_sysconfdir/xdg/%name/session

%find_lang %name

%files -f %name.lang
%doc AUTHORS ChangeLog README data/spacefm-manual-en.html
%_sysconfdir/%name/
%_sysconfdir/xdg/%name/
%_bindir/*
%config(noreplace) %_sysconfdir/%name/%name.conf
%_datadir/%name/
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/%{name}*.png
%_iconsdir/Faenza/
%_datadir/mime/packages/%name-mime.xml

%changelog
