%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%def_with fftw
%define slicerver 5.8

Name: slicer
Version: %slicerver.1
Release: alt1
Summary: Medical Visualization and Processing Environment for Research
%if_with fftw
License: GPL-2.0-or-later
%else
License: 3D-Slicer-1.0
%endif
Group: Sciences/Medicine
Url: https://www.slicer.org/
VCS: https://github.com/Slicer/Slicer.git

# Exclusion source: pythonqt, CTK
ExcludeArch: i586

# https://github.com/Slicer/Slicer.git
Source: %name-%version.tar

# Copied from CTK
Source2: FindPythonQt.cmake

Source3: slicer.desktop

Patch1: slicer-5.3.0-upstream-wc-last-change-date-fix.patch
Patch2: slicer-5.6.1-alt-itk-compat.patch
Patch3: slicer-5.8.0-alt-build.patch
Patch4: slicer-5.8.0-alt-python3-compat.patch
Patch5: slicer-5.8.0-alt-vtk-compat-findpoint.patch
Patch6: slicer-5.8.0-alt-vtk-compat-unused-headers.patch
Patch7: slicer-5.8.0-alt-vtk-compat-version-check.patch
Patch8: slicer-5.8.1-alt-BUG-Cast-u8-prefix-literals-to-const-char.patch

BuildRequires(pre): rpm-macros-qt5
BuildRequires(pre): rpm-build-cmake
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-qt5-webengine
%{?_with_fftw:BuildRequires: libfftw3-devel}
BuildRequires: python3-devel
BuildRequires: gcc-c++ cmake
BuildRequires: qt5-base-devel qt5-multimedia-devel qt5-script-devel qt5-svg-devel qt5-tools-devel-static qt5-xmlpatterns-devel qt5-x11extras-devel
BuildRequires: libpcre2-devel libbrotli-devel
%ifarch %qt5_qtwebengine_arches
BuildRequires: qt5-webengine-devel
%endif
BuildRequires: libitk-devel
BuildRequires: libminc-devel
BuildRequires: libvtk-devel
BuildRequires: CTK-devel
BuildRequires: teem-devel
BuildRequires: vtkaddon-devel
BuildRequires: slicerexecutionmodel-devel
BuildRequires: libcurl-devel
BuildRequires: libqrestapi-devel
BuildRequires: CTKAppLauncherLib-devel
BuildRequires: pythonqt-devel
BuildRequires: rapidjson-devel
BuildRequires: bzip2-devel
BuildRequires: libniftilib-devel liblpsolve-devel
BuildRequires: doxygen /usr/bin/dot
BuildRequires: libcpp-base64-devel

%add_python3_path %_libdir/Slicer-%slicerver

%add_python3_req_skip EditorLib
%add_python3_req_skip SegmentEditorEffects SegmentEditorEffects.AbstractScriptedSegmentEditorEffect SegmentEditorEffects.AbstractScriptedSegmentEditorLabelEffect
%add_python3_req_skip Slicer slicer slicer.ScriptedLoadableModule slicer.util
%add_python3_req_skip SimpleITK __main__ github github.GithubObject
%add_python3_req_skip vtk.util vtk.util.numpy_support

%description
Desktop software to solve advanced image computing challenges
with a focus on clinical and biomedical applications.

Development platform to quickly build and deploy custom solutions
for research and commercial products, using free, open source software.

Community of knowledgeable users and developers working together
to improve medical computing.

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %EVR
Requires: %name-qt5-designer-plugin = %EVR

%description devel
Desktop software to solve advanced image computing challenges
with a focus on clinical and biomedical applications.

Development platform to quickly build and deploy custom solutions
for research and commercial products, using free, open source software.

Community of knowledgeable users and developers working together
to improve medical computing.

This package contains development files for Slicer.

%package qt5-designer-plugin
Summary: Medical Visualization and Processing Environment for Research
Group: Development/C++

%description qt5-designer-plugin
Desktop software to solve advanced image computing challenges
with a focus on clinical and biomedical applications.

Development platform to quickly build and deploy custom solutions
for research and commercial products, using free, open source software.

Community of knowledgeable users and developers working together
to improve medical computing.

This package contains Slicer plugins for qt5 designer.

%prep
%setup
%autopatch -p1
%ifarch %e2k
sed -i 's/~DiffusionTensor3D.*() = default;//' \
	Modules/CLI/ResampleDTIVolume/itkDiffusionTensor3D*Correction.h
sed -i 's/~ConstrainedValueMultiplication() *= default;//' \
	Libs/vtkITK/itkConstrainedValueMultiplicationImageFilter.h
%endif

# Compat with VTK 9.4
# https://github.com/Slicer/Slicer/pull/8238
grep -rl 'SetNthControlPointPositionMissing' |\
  xargs sed -i 's/SetNthControlPointPositionMissing/SetControlPointPositionMissing/'

install %SOURCE2 ./CMake/

# change python shebangs to python3
find . -name '*.py' | xargs sed -i \
	-e '1s|^#!/usr/bin/env python$|#!/usr/bin/env python3|' \
	-e '1s|^#!/usr/bin/python$|#!/usr/bin/python3|' \
	%nil


%build
%add_optflags -D_FILE_OFFSET_BITS=64

%cmake -Wno-dev \
	-DCMAKE_INSTALL_LIBDIR:PATH=%_libdir \
	-DSlicer_DEFAULT_RELEASE_TYPE:STRING=Stable \
	-DSlicer_VERSION:STRING=%slicerver \
	-DSlicer_VERSION_FULL:STRING=%version \
	-DSlicer_VTK_VERSION_MAJOR=9 \
	-DSlicer_SUPERBUILD:BOOL=OFF \
	-DSlicer_BUILD_I18N_SUPPORT:BOOL=ON \
	-DSlicer_INSTALL_DEVELOPMENT:BOOL=ON \
	-DSlicer_INSTALL_NO_DEVELOPMENT:BOOL=OFF \
	-DSlicer_WITH_LIBRARY_VERSION:BOOL=ON \
	-DBUILD_TESTING:BOOL=OFF \
	-DSlicer_USE_PYTHONQT:BOOL=ON \
	-DSlicer_USE_QtTesting:BOOL=OFF \
	-DSlicer_USE_SYSTEM_DCMTK:BOOL=ON \
	-DSlicer_USE_SYSTEM_CTK:BOOL=ON \
	-DSlicer_USE_SYSTEM_OpenSSL:BOOL=ON \
	-DSlicer_USE_SYSTEM_TBB:BOOL=ON \
	-DSlicer_USE_SYSTEM_python:BOOL=ON \
	-DSlicer_USE_SYSTEM_QT:BOOL=ON \
	-DSlicer_BUILD_WEBENGINE_SUPPORT:BOOL=%{?_qt5_qtwebengine_arches:ON}%{!?_not_qt5_qtwebengine_arches:OFF} \
	-DSlicer_USE_SYSTEM_ITK:BOOL=ON \
	-DSlicer_USE_SYSTEM_LibArchive:BOOL=ON \
	-DSlicerExecutionModel_DEFAULT_CLI_INSTALL_RUNTIME_DESTINATION:PATH=%_libdir/Slicer-%slicerver/cli-modules \
	-DSlicerExecutionModel_DEFAULT_CLI_INSTALL_LIBRARY_DESTINATION:PATH=%_libdir/Slicer-%slicerver/lib/Slicer-%slicerver/cli-modules \
	-DSlicer_STORE_SETTINGS_IN_APPLICATION_HOME_DIR:BOOL=OFF \
	%nil

%cmake_build

%install
%cmakeinstall_std

install -d %buildroot%_bindir
cat > %buildroot%_bindir/Slicer << END
#!/bin/sh
exec %_libdir/Slicer-%slicerver/Slicer "\$@"
END

chmod +x %buildroot%_bindir/Slicer

# install symlinks for library discovery: they are loaded dynamically, but they have dependencies on each other as well
# separate library is used for dynamic loading, symlink in generic directory is used for loading as dependency

install -d %buildroot%_libdir
find %buildroot%_libdir/Slicer-%slicerver -name '*.so*' | while read i ; do
	ln -sr $i %buildroot%_libdir/
done


# install desktop file and icon
install -d %buildroot%_desktopdir
install -m644 %SOURCE3 %buildroot%_desktopdir/

install -d %buildroot%_datadir/%name
install -m644 Resources/3DSlicer-DesktopIcon.png %buildroot%_datadir/%name/

# remove unpackaged files
find %buildroot%_libdir -name '*.a' -delete
find %buildroot%_libdir/Slicer-%slicerver/share/Slicer-%slicerver/Wizard/Templates -name '*.h' -delete

# generated cmake files require a lot of fixing before they'd become useable
rm -rf %buildroot%_libdir/cmake
rm -rf %buildroot%_libdir/Slicer-%slicerver/lib/Slicer-%slicerver/cmake

%files
%doc COPYRIGHT.txt License.txt
%doc README.md CONTRIBUTING.md AUTHORS.md
%_bindir/Slicer
%_libdir/*.so
%_libdir/*.so.*
%dir %_libdir/Slicer-%slicerver
%_libdir/Slicer-%slicerver/Slicer
%_libdir/Slicer-%slicerver/bin
%_libdir/Slicer-%slicerver/cli-modules
%_libdir/Slicer-%slicerver/lib
%_libdir/Slicer-%slicerver/libexec
%_libdir/Slicer-%slicerver/share
%_qt5_plugindir/iconengines/*.so
%_qt5_plugindir/styles/*.so
%_datadir/MRMLCore
%_desktopdir/*.desktop
%dir %_datadir/%name
%_datadir/%name/3DSlicer-DesktopIcon.png

%files devel
%_includedir/*

%files qt5-designer-plugin
%_qt5_plugindir/designer/*.so

%changelog
