%set_verify_elf_method strict
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%define _unpackaged_files_terminate_build 1
%def_enable static

Name: slang2
Version: 2.3.3
Release: alt1

Summary: The shared library for the S-Lang extension language
License: GPL-2.0-or-later
Group: System/Libraries
Url: http://www.jedsoft.org/slang/

# https://www.jedsoft.org/releases/slang/slang-2.3.2.tar.bz2
Source: slang-%version.tar

Patch2: slang-2.3.3-owl-alt-fixes.patch
Patch3: slang-2.2.4-alt-doc.patch

Patch11: slang-2.2.4-deb-demos-make.patch
Patch12: slang-2.2.4-deb-hostent-haddr.patch

# Automatically added by buildreq on Tue Sep 25 2012
# optimized out: gnu-config pkg-config xorg-xproto-devel zlib-devel
BuildRequires: libICE-devel libX11-devel libncurses-devel libpcre-devel libpng-devel

# for src/test/posixio.sl
BuildRequires: /dev/pts

%package slsh
Summary: S-Lang shell
Group: System/Libraries
Requires: lib%name = %version-%release

%package -n lib%name
Summary: The shared library for the S-Lang extension language
Group: System/Libraries
Provides: slang = %version

%package -n lib%name-devel
Summary: The development environment for S-Lang
Group: Development/C
Requires: lib%name = %version-%release
Provides: libslang-devel = %version
Obsoletes: libslang-devel < %version

%if_enabled static
%package -n lib%name-devel-static
Summary: The static library for development using S-Lang
Group: Development/C
Requires: lib%name-devel = %version-%release
%endif

%description
S-Lang is an interpreted language and a programming library.  The
S-Lang language was designed so that it can be easily embedded into
a program to provide the program with a powerful extension language.
The S-Lang library, provided in this package, provides the S-Lang
extension language.  S-Lang's syntax resembles C, which makes it easy
to recode S-Lang procedures in C if you need to.

%description slsh
S-Lang is an interpreted language and a programming library.  The
S-Lang language was designed so that it can be easily embedded into
a program to provide the program with a powerful extension language.
The S-Lang library, provided in this package, provides the S-Lang
extension language.  S-Lang's syntax resembles C, which makes it easy
to recode S-Lang procedures in C if you need to.

This package contains a stand-alone interpreter for scripts written
in the S-Lang language.

%description -n lib%name
S-Lang is an interpreted language and a programming library.  The
S-Lang language was designed so that it can be easily embedded into
a program to provide the program with a powerful extension language.
The S-Lang library, provided in this package, provides the S-Lang
extension language.  S-Lang's syntax resembles C, which makes it easy
to recode S-Lang procedures in C if you need to.

%description -n lib%name-devel
This package contains the S-Lang extension language development libraries
and header files which you'll need if you want to develop S-Lang based
applications.

%if_enabled static
%description -n lib%name-devel-static
This package contains the S-Lang extension language static libraries
which you'll need if you want to develop S-Lang based statically linked
applications.
%endif

%prep
%setup -n slang-%version
%patch2 -p1
%patch3 -p1

%patch11 -p1
%patch12 -p1

%build
%add_optflags %(getconf LFS_CFLAGS)

export ac_cv_func_snprintf=yes ac_cv_func_vsnprintf=yes
%configure \
	--includedir=%_includedir/slang \
	--with-{pcre,png,z}lib=%_libdir \
	--with-pcreinc=$(pkg-config libpcre --cflags |sed 's/^[^/]*//') \
	--with-pnginc=$(pkg-config libpng --cflags |sed 's/^[^/]*//') \
	--with-zinc=%_includedir \
	#
mkdir -p modules/objs slsh/objs src/elfobjs src/objs
%make_build RPATH= SLANG_LIB="-L$PWD/src/elfobjs -lslang"
%{?_enable_static:%make_build -C src static}

%install
%makeinstall_std RPATH= %{?_enable_static:install-static}
%define docdir %_docdir/slang-%version
mv %buildroot%_docdir/slang/v2 %buildroot%docdir
rmdir %buildroot%_docdir/slang
mv %buildroot%_docdir/slsh/html %buildroot%docdir/slsh
rmdir %buildroot%_docdir/slsh

%check
# for test_slsmg.sl
export TERM=xterm
%make check

%files slsh
%_sysconfdir/slsh.rc
%_bindir/slsh
%_datadir/slsh
%_man1dir/*
%dir %docdir/
%docdir/slsh/

%files -n lib%name
%_libdir/*.so.*
%_libdir/slang
%docdir/
%exclude %docdir/slsh/

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
