Name:           siril
Version:        1.2.6
Release:        alt1
Summary:        Astronomical image processing software
Group: 		Graphics
Packager: Ilya Mashkin <oddity@altlinux.ru>
# Selected portions of the software derived from SLEEF
# are licensed under Boost license:
# - src/core/sleef.h
License:        GPLv3+ and Boost
URL:            https://siril.org
Source0:        https://free-astro.org/download/%{name}-%{version}.tar.bz2

Patch1:         siril-1.0.0-opencv_flann.patch
Patch2: 	0001-Fix-compilation-with-exiv2-0.28.patch
Patch3:		siril-skip-update-check.patch 

# Notes on dependencies:
# No ffms and heif support 

BuildRequires:  make
BuildRequires:  cmake
BuildRequires:  curl-devel
BuildRequires:  desktop-file-utils
BuildRequires:  ffmpeg libavcodec-devel
# libffmpegthumbnailer-devel libopenmpt-devel
BuildRequires:  gcc-c++
BuildRequires:  libgif-devel libopencv-devel  libgomp-devel libopenmpt-devel libheif-devel libffms2-devel libavformat-devel libswscale-devel  libswresample-devel
BuildRequires:  intltool
BuildRequires:  libappstream-glib
BuildRequires:  meson
BuildRequires:  pkgconfig(cfitsio)
BuildRequires:  pkgconfig(exiv2)
BuildRequires:  pkgconfig(fftw3)
BuildRequires:  pkgconfig(gsl)
BuildRequires:  pkgconfig(gtk+-3.0)
BuildRequires:  pkgconfig(json-glib-1.0)
BuildRequires:  pkgconfig(libconfig)
BuildRequires:  pkgconfig(libjpeg)
BuildRequires:  pkgconfig(libpng)
BuildRequires:  pkgconfig(libraw)
BuildRequires:  pkgconfig(libtiff-4)
#BuildRequires:  pkgconfig(rtprocess)
#BuildRequires:  pkgconfig(opencv)
BuildRequires:  pkgconfig(wcslib)

#Recommends:     gvfs

#Provides:       bundled(kplot) = 0.1.14

%description
Siril is an image processing tool specially tailored for noise reduction and
improving the signal/noise ratio of an image from multiple captures, as
required in astronomy. Siril can align automatically or manually, stack and
enhance pictures from various file formats, even images sequences (movies and
SER files)


%prep
#setup -c -n siril-%version
%setup
#patch1 -p1
#patch2 -p1
#patch3 -p1

%ifarch %e2k
sed -i -E ":a;/\\\\$/{N;ba};\
/^[[:space:]]*#pragma omp .*[[:space:]](num_threads|if|schedule)\(/{s/#/for(long &/;\
s/(#.*num_threads\()([^()]*)\)/_xxxn=\\2,\\1_xxxn)/;\
s/(#.*if *\()([^()]*(\([^()]*(\([^()]*\)[^()]*)*\)[^()]*)*)\)/_xxxi=\\2,\\1_xxxi)/;\
s/(#.*schedule\([^()]*, *)([^()]*)\)/_xxxs=\\2,\\1_xxxs)/;\
s/#/_xxxc=1;_xxxc;_xxxc=0)\n&/}" \
	src/{registration,filters,stacking,rt,algos,gui,compositing,pixelMath,core,io}/*.c \
	src/filters/{deconvolution/*.{c,hpp},nlbayes/*.cpp}
sed -i '/omp critical (fftw)/d;/<fftw3.h>/a \
__attribute__((noinline)) static void*fftwf_malloc_(std::size_t n){\
#pragma omp critical(fftw)\
void*p=fftwf_malloc(n);return p;}\
__attribute__((noinline)) static void fftwf_free_(void*p){\
#pragma omp critical(fftw)\
fftwf_free(p);}\
#define fftwf_malloc fftwf_malloc_\
#define fftwf_free fftwf_free_' \
	src/filters/deconvolution/fftw_allocator.hpp
%add_optflags -Wno-unused-but-set-variable -Wno-maybe-uninitialized -Wno-unused-variable

%endif

%build
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%meson \
    -Drelocatable-bundle=no \
    -Dopenmp=true \
    -Denable-libcurl=yes

%meson_build


%install
%meson_install

desktop-file-install \
    --dir=%{buildroot}%{_datadir}/applications \
    platform-specific/linux/org.siril.Siril.desktop

%find_lang %{name}


%check
appstream-util validate-relax --nonet %{buildroot}%{_datadir}/metainfo/org.siril.Siril.appdata.xml

%files -f %{name}.lang

%doc AUTHORS ChangeLog NEWS README.md LICENSE.md LICENSE_sleef.txt
%{_bindir}/%{name}*
%{_datadir}/applications/org.siril.Siril.desktop
%{_datadir}/mime/packages/%{name}.xml
%{_datadir}/icons/hicolor/*/*/*.svg
%{_datadir}/metainfo/org.siril.Siril.appdata.xml
%{_datadir}/%{name}/
%{_mandir}/man1/%{name}*


%changelog
