%def_disable bootstrap
%def_enable profile
%def_enable sanitizers
%def_enable coverage
%ifarch %e2k
%def_without fortran
%endif

Name:     simpletest
Version:  12
Release:  alt2

Summary:  Simple toolchain test
License:  GPL-3
Group:    Other
Url:      http://git.altlinux.org/people/bircoph/packages/simpletest.git

Packager: Andrew Savchenko <bircoph@altlinux.org>

Source:   %name-%version.tar

BuildRequires: gcc-c++
%{?!_without_fortran:BuildRequires: gcc-fortran}
%{?!_enable_bootstrap:BuildRequires: libgomp-devel}
%if_enabled sanitizers
BuildRequires: /proc libasan-devel-static
%ifarch %e2k
BuildRequires: liblsan-devel-static libmsan-devel-static
%else
%ifarch i586 armh
BuildRequires: libubsan-devel-static
%else
BuildRequires: liblsan-devel-static libtsan-devel-static libubsan-devel-static
%endif
%endif
%endif

%description
Simple suit for testing basic runtime toolchain functionality:
- build chroot installability;
- C/C++/Fortran base testing (compiles & works);
- OpenMP tests for both C and Fortran (C++ OpenMP is the same as C);
- profiler testing;
- coverage testing.

Also provides useful information about system:
- running CPU version and architecture;
- active instruction set, bitness, optlevel;
- uname information;
- effective compiler version and supported standards.

%prep
%setup

%build
# armv7a (armh) build hosts tells us it's aarch64, so set arch explicitly
%configure \
%ifarch armh
    --arch=armv7a \
%endif
    %{subst_enable bootstrap} \
    %{subst_enable profile} \
    %{subst_enable sanitizers} \
    %{subst_enable coverage} \
    %{?_without_fortran: --disable-fortran}

%make_build -O

# No need to check since all checks are done during build

%install
%makeinstall_std

%files
%_bindir/*
%doc README

%changelog
