%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict,lint=relaxed

Name: shfmt
Version: 3.10.0
Release: alt1
Summary: Format shell programs
License: BSD-3-Clause
Group: Development/Tools
Url: https://github.com/mvdan/sh

Source: %name-%version.tar
BuildRequires: golang
BuildRequires: scdoc
%{?!_without_check:%{?!_disable_check:
BuildRequires: /dev/pts
}}

%description
shfmt formats (indents) shell scripts.

%prep
%setup

%build
%ifnarch armh %ix86 loongarch64 riscv64
export CGO_ENABLED=0
%endif
go build -v -buildmode=pie -ldflags='-X main.version=%version' ./cmd/shfmt
scdoc < cmd/%name/%name.1.scd > %name.1

%install
install -Dp shfmt -t %buildroot%_bindir
install -Dm0644 %name.1 -t %buildroot%_man1dir

%check
./shfmt -version | grep -Fx '%version'
go test ./...

%files
%doc LICENSE README.md CHANGELOG.md
%_bindir/shfmt
%_man1dir/shfmt.1.*

%changelog
