Name: shellcheck

Version: 0.11.0
Release: alt1
License: GPL-3.0-or-later
Url: https://github.com/koalaman/shellcheck
Group: Development/Tools

Source: %name-%version.tar
Source1: vendor.tar

BuildRequires(pre): ghc
BuildRequires(pre): rpm-build-haskell-vendored

BuildRequires: pandoc

Summary: Shell script analysis tool

%description
The goals of ShellCheck are:
* To point out and clarify typical beginner's syntax issues, that causes
a shell to give cryptic error messages;
* To point out and clarify typical intermediate level semantic problems,
that causes a shell to behave strangely and counter-intuitively;
* To point out subtle caveats, corner cases and pitfalls, that may cause
an advanced user's otherwise working script to fail under future
circumstances.

%prep
%setup -a 1

%build
%cabal_vendor_build exe:shellcheck

pandoc -s -f markdown-smart -t man shellcheck.1.md -o shellcheck.1

%install
%cabal_vendor_install exe:shellcheck

mkdir -p %buildroot%_man1dir
cp shellcheck.1 %buildroot%_man1dir

%check
%cabal_vendor_test

%files
%_bindir/shellcheck
%_man1dir/shellcheck.1*

%changelog
