%def_enable snapshot

%define ver_major 12
%define pypi_name gsecrets
%define xdg_name org.gnome.World.Secrets

%def_disable check

Name: secrets
Version: %ver_major.0
Release: alt1

Summary: A password manager for GNOME
License: GPL-3.0
Group: Graphical desktop/GNOME
Url: https://gitlab.gnome.org/World/secrets

Vcs: https://gitlab.gnome.org/World/secrets.git

%if_disabled snapshot
Source: %url/-/archive/v%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.80
%define gtk_ver 4.20
%define adwaita_ver 1.8
%define pygobject_ver 3.52
%define gtksource_api_ver 5

Requires: python3-module-pygobject3 >= %pygobject_ver
Requires: typelib(Adw) = 1
Requires: typelib(GtkSource) = %gtksource_api_ver
Requires: yelp

BuildArch: noarch
%py3_provides %pypi_name

BuildRequires(pre): rpm-macros-meson rpm-build-python3 rpm-build-gir
BuildRequires: meson yelp-tools
BuildRequires: pkgconfig(gtk4) >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: pkgconfig(gtksourceview-%gtksource_api_ver)
BuildRequires: pkgconfig(pygobject-3.0) >= %pygobject_ver
BuildRequires: pkgconfig(gobject-introspection-1.0)
BuildRequires: pkgconfig(dbus-1)
BuildRequires: python3(pykeepass) python3(pyotp) python3(validators)
BuildRequires: python3(zxcvbn_rs_py) python3(PyKCS11) python3(yubico)
%{?_enable_check:
BuildRequires: desktop-file-utils /usr/bin/appstreamcli
BuildRequires: python3(pytest) python3(gi) typelib(Gtk) = 4.0 ruff}

%description
A password manager which integrates perfectly with the GNOME desktop and
provides an easy and uncluttered interface for the management of password
databases.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%check
export PYTHONPATH=%buildroot%python3_sitelibdir_noarch
%__meson_test -v

%files -f %name.lang
%_bindir/%name
%_datadir/%name/
%_desktopdir/%xdg_name.desktop
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_iconsdir/hicolor/*/apps/%{xdg_name}*.svg
%_datadir/metainfo/%xdg_name.metainfo.xml
%_datadir/mime/packages/%xdg_name.xml
%python3_sitelibdir_noarch/%pypi_name/
%doc README*

%changelog
