Name:          scummvm
Version:       2.9.1.8955
Release:       alt0.1
Summary:       Graphic adventure game interpreter
Group:         Games/Adventure
License:       GPLv2
Url:           https://www.scummvm.org
Vcs:           https://github.com/scummvm/scummvm.git

Source:        %name-%version.tar
BuildRequires: gcc-c++
BuildRequires: libSDL_net-devel
BuildRequires: liba52-devel
BuildRequires: libalsa-devel
BuildRequires: libcurl-devel
BuildRequires: libfaad-devel
BuildRequires: libfluidsynth-devel
BuildRequires: libfribidi-devel
BuildRequires: libgif-devel
BuildRequires: libgtk+3-devel
BuildRequires: libjpeg-devel
BuildRequires: libmad-devel
BuildRequires: libmikmod-devel
BuildRequires: libmpeg2-devel
BuildRequires: libreadline-devel
BuildRequires: libspeechd-devel
BuildRequires: libtheora-devel

Provides:      %_gamesdatadir/%name

%description
ScummVM is a collection of interpreters, capable of emulating several
adventure game engines. ScummVM mainly supports games created using
SCUMM (Script Creation Utility for Maniac Mansion), used in various
LucasArts games such as Monkey Island, Day of the Tentacle, and others.

%prep
%setup

%build
export CXXFLAGS=-DFS_API_VERSION=0x0202
./configure \
	--prefix=%prefix \
	--bindir=%_bindir \
	--mandir=%_mandir \
	--libdir=%_libdir \
	--enable-release \
	--enable-plugins --default-dynamic \
	--disable-nasm --disable-tremor \
	--enable-text-console \
	--enable-all-engines \
	--enable-vkeybd
%make_build

%install
%makeinstall_std

# Menu, themes and extra files
cp -a dists/engine-data %buildroot%_datadir/%name
install -D dists/maemo/scummvm64.png %buildroot%_iconsdir/hicolor/64x64/apps/%name.png
install -D dists/maemo/scummvm48.png %buildroot%_iconsdir/hicolor/48x48/apps/%name.png
install -D dists/emscripten/assets/scummvm-192.png buildroot%_iconsdir/hicolor/192x192/apps/%name.png
install -D dists/emscripten/assets/scummvm-512.png buildroot%_iconsdir/hicolor/512x512/apps/%name.png
install -D icons/scummvm.svg %buildroot%_iconsdir/hicolor/scalable/apps/%name.svg

%files
%doc AUTHORS* README* NEWS* TODO* COPYING*
%exclude %_defaultdocdir/%name
%_bindir/scummvm
%_man6dir/scummvm.6*
%_pixmapsdir/*.xpm
%_datadir/applications/*.desktop
%_datadir/metainfo/*
%_iconsdir/hicolor/*/apps/*
%dir %_libdir/%name
%_libdir/%name/*
%dir %_datadir/%name
%_datadir/%name/*


%changelog
