%define oname scapy

Name: scapy
Version: 2.6.1
Release: alt2

Summary: Scapy is a powerful interactive packet manipulation program written in Python

Group: Networking/Other
License: GPLv2
Url: https://scapy.net/

##Source-url: https://github.com/secdev/scapy/archive/v%version.zip
# Source-url: %__pypi_url %oname
Source: %name-%version.tar

BuildArch: noarch

Requires: python3-module-scapy = %EVR

Requires: tcpdump

BuildRequires(pre): rpm-build-python3 rpm-build-intro
BuildRequires: python3-module-wheel python3-module-setuptools

%add_python3_req_skip scapy.libs.six.moves scapy.libs.six.moves.queue
# far away now
%add_python3_req_skip pyannotate_runtime

# contrib
%add_python3_req_skip can
%add_python3_req_skip can.interface

%description
Scapy is a powerful interactive packet manipulation program.
It is able to forge or decode packets of a wide number of protocols,
send them on the wire, capture them, match requests and replies, and
much more.
It can easily handle most classical tasks like scanning, tracerouting,
probing, unit tests, attacks or network discovery.

%package -n python3-module-%name
Summary: Python module for %name.
Group: Development/Python

%description -n python3-module-%name
Powerful interactive packet manipulation python module scapy.

%prep
%setup
echo %version > scapy/VERSION

%build
%pyproject_build

%install
%pyproject_install
%python3_prune
rm -rv %buildroot%python3_sitelibdir/%name/arch/windows

%files
%_bindir/*scapy
%_man1dir/*

%files -n python3-module-scapy
%python3_sitelibdir/%name/
%python3_sitelibdir/%name-*dist-info/

%changelog
