Name: scalpel
Version: 2.0
Release: alt2

Summary: A Frugal, High Performance File Carver
License: GPLv2+
Group: Text tools

Url: https://github.com/machn1k/Scalpel-2.0
Source0: %name-%version.tar.gz
Source1: scalpel.conf.odf

# Automatically added by buildreq on Sun Apr 13 2014
# optimized out: gnu-config libcloog-isl4
BuildRequires: libtre-devel

%description
Scalpel is a fast file carver that reads a database of header and footer
definitions and extracts matching files from a set of image files or raw
device files. Scalpel is filesystem-independent and will carve files from
FATx, NTFS, ext2/3/4, or raw partitions. It is useful for both digital
forensics investigation and file recovery.

%prep
%setup
sed -i 's|scalpel.conf|%_sysconfdir/&|' src/scalpel.h
chmod -x gpl.txt README Changelog src/*.h src/*.c
rm -f *.exe *.dll

%build
%configure
%make_build

%install
%makeinstall_std
install -pDm644 scalpel.conf %buildroot%_sysconfdir/scalpel.conf

# modify configuration to have some usable one out of box:
# everything is commented out within the stock file;
# this sed script uncomments common file extensions
sed -i -e "s/^#[ ]*$//;
           s/\t/        /g;
           s/^#   [ ]*\([a-z][a-z] \)/        \1/;
           s/^#   [ ]*\([a-z][a-z][a-z] \)/        \1/;
           s/^#   [ ]*\([a-z][a-z][a-z][a-z] \)/        \1/;
           s/^\(.*case[ ]*size\)/#\1/" %buildroot%_sysconfdir/scalpel.conf

# a few more more bits
cat %SOURCE1 >> %buildroot%_sysconfdir/scalpel.conf

%files
%config(noreplace) %_sysconfdir/scalpel.conf
%_bindir/*
%_man1dir/*
%doc Changelog README %name.conf

%changelog
