%define _unpackaged_files_terminate_build 1
%def_with check

Name: sane-airscan
Version: 0.99.36
Release: alt1

Summary: This package contains SANE backend for AirScan (eSCL) and WSD document scanners

License: GPLv2
Group: Graphics
Url: https://github.com/alexpevzner/sane-airscan
#Git: https://github.com/alexpevzner/sane-airscan.git

Source: %name-%version.tar

Patch0: %name-%version-%release.patch

BuildRequires: libavahi-glib-devel
BuildRequires: libjpeg-devel
BuildRequires: libpng-devel
BuildRequires: libsane-devel
BuildRequires: libxml2-devel
BuildRequires: libgnutls-devel
BuildRequires: libtiff-devel

%description
Similar to how most modern network printers support "driverless" printing, using
the universal vendor-neutral printing protocol, many modern network scanners and
MFPs support "driverless" scanning.

Driverless scanning comes in two flavors:

    Apple AirScan or AirPrint scanning (official protocol name is eSCL)
    Microsoft WSD, or WS-Scan (term WSD means "Web Services for Devices)

This backend implements both protocols, choosing automatically between them. It
was successfully tested with many devices from Brother, Canon, Kyocera, Lexmark,
Epson, HP, Ricoh, Samsung and Xerox both in WSD and eSCL modes.

For eSCL devices, Apple maintains a comprehensive list of compatible devices,
but please note, this list contains not only scanners and MFP, but pure printers
as well.

This backend doesn't require to install and doesn't conflict with
vendor-provided proprietary software like ScanGear from Canon, HPLIP from HP and
so on.

%prep
%setup
%patch0 -p1
%ifarch %e2k
# as of lcc 1.27.14
sed -i 's/-Werror/-Wno-error/g' Makefile
%endif

%build
%make_build

%install
%makeinstall_std STRIP=''

%check
%make_build check

%files
%_bindir/*
%config(noreplace) %_sysconfdir/sane.d/*.conf
%config(noreplace) %_sysconfdir/sane.d/dll.d/*
%_libdir/sane/libsane-airscan.so.*
%_man1dir/*.1.xz
%_man5dir/*.5.xz

%changelog
