%define oname %name-backends

Name: sane
Version: 1.4.0
Release: alt1

Summary: This package contains the SANE docs and utils
Summary(ru_RU.UTF-8): Документация и утилиты для SANE

License: GPL
Group: Graphics
Url: http://www.sane-project.org/
Vcs: https://gitlab.com/sane-project/backends

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://gitlab.com/sane-project/backends/-/archive/%version/backends-%version.tar.bz2
Source: %oname-%version.tar
#Source1: %name-%version.ru.po
Source2: %name.xinetd

Patch3: sane-1.0.19-hp-psc.patch
Patch4: sane-backends-1.0.18-epson-1270.patch
Patch5: sane-backends-1.4.0-xerox-blacklist-workcentre-322x.patch

# Support for Avision FB2280E
Patch6: sane-backends-1.0.32-avision-FB2280E.patch
Patch7: sane-backends-1.0.32-avision-add-AD345F-support-as-basic.patch
Patch8: sane-backends-1.1.1-alt-update-ru-translation.patch

# Mandriva patches
Patch201: sane-backends-1.0.18-plustek-s12.patch

# FIXME: check module linking without provides
#add_findprov_lib_path %_libdir/%name

BuildRequires: autoconf-archive

Requires: lib%name = %version-%release
Requires: udev
Provides: %oname-drivers-scanners = %version-%release

BuildRequires: rpm-build-intro

# needed for genesys plugin
BuildRequires: gcc-c++

# manually removed: libsane-devel
# Automatically added by buildreq on Sat Oct 12 2019
# optimized out: ghostscript-classic glib2-devel glibc-kernheaders-generic glibc-kernheaders-x86 gnu-config gnustep-base-devel libdb4-devel libgpg-error libgphoto2-6 libgphoto2_port-12 libnet-snmp35 libnl-devel libpng-devel libssl-devel libstdc++-devel net-snmp-config netpbm pkg-config python-base python-modules python3 python3-base python3-dev python3-module-mpl_toolkits python3-module-paste python3-module-zope ruby ruby-stdlibs sh4 sssd-client
BuildRequires: libavahi-devel libgphoto2-devel libieee1284-devel libjpeg-devel libnet-snmp-devel libsystemd-devel libtiff-devel libusb-devel libv4l-devel

# The pixma backend requires libxml2
BuildRequires: libxml2-devel

BuildRequires: rpm-build-python3 python3

%package -n %name-server
Summary: SANE as network server
Group: System/Libraries
License: LGPL
Requires: lib%name = %version-%release

%package doc
Summary: Documentation for SANE
Summary(ru_RU.UTF-8): Документация для SANE
Group: Graphics
BuildArch: noarch

%description doc
Documentation for SANE

%description doc -l ru_RU.UTF-8
Документация для SANE


%package -n lib%name
Summary: SANE shared libraries
Group: System/Libraries
License: LGPL
Provides: %oname = %version-%release
Provides: %oname-libs = %version-%release

%package -n lib%name-gphoto2
Summary: SANE libraries for gphoto2
Group: System/Libraries
Requires: lib%name = %version-%release
Provides: %oname-drivers-cameras = %version-%release

%description -n lib%name-gphoto2
This package contains the SANE libraries which are needed by applications that
want to access digital cameras via GPhoto2.

%package -n lib%name-devel
Summary: Development environment for SANE
Group: Development/C
License: LGPL
Requires: lib%name = %version-%release
Provides: %name-devel = %version
Obsoletes: %name-devel
Provides: %oname-devel = %version-%release

%package -n lib%name-devel-static
Summary: SANE static libraries
Group: Development/C
License: LGPL
Requires: lib%name-devel = %version-%release

%description
SANE (Scanner Access Now Easy) is a sane and simple interface to both
local and networked scanners and other image acquisition devices like
digital still and video cameras. SANE currently includes modules for
accessing:

Scanners: Abaton, Agfa, Apple, Artec, Avision, Bell+Howell, Canon,
Epson, Fujitsu, HP, LEO, Microtek, Mustek, NEC, Nikon, Panasonic, PIE,
Plustek, Ricoh, Sceptre, Sharp, Siemens, Tamarack, Teco, UMAX
HP Scanjet 3900 series scanners (hp3970,
hp4070, hp4370 and those which use RTS8822 chipset).

Digital cameras: Kodak, Polaroid, Connectix QuickCam
and other SANE devices via network (see sane-server package
and read the saned(1) manpage).

Please see http://sane-project.org/sane-supported-devices.html
for the full list corresponding to this version (%version).

%description -l ru_RU.UTF-8
SANE (Scanner Access Now Easy) -- это достаточно разумный
и в то же время простой интерфейс для локальных и сетевых
сканеров и других устройств оцифровки изображений, таких как
цифровые фотоаппараты и видеокамеры. В настоящее время SANE
включает модули для использования широкого круга сканеров,
включая модели

Сканеров: Abaton, Agfa, Apple, Artec, Avision, Bell+Howell, Canon,
Epson, Fujitsu, HP, LEO, Microtek, Mustek, NEC, Nikon, Panasonic, PIE,
Plustek, Ricoh, Sceptre, Sharp, Siemens, Tamarack, Teco, UMAX

Цифровых фотоаппаратов: Kodak, Polaroid, Connectix QuickCam
и других SANE-устройств по сети (установите пакет sane-server и
прочитайте страницу руководства man saned(1)).

Обратитесь к http://sane-project.org/sane-supported-devices.html
за полным списком совместимости, соответствующим этой версии (%version).

%description -n %name-server
This package contains SANE network server components.

%description -n lib%name
This package contains SANE shared libraries
and scanner backend modules.
Install this package for scan programs.

%description -n lib%name -l ru_RU.UTF-8
Этот пакет содержит разделяемые библиотеки SANE
и модули поддержки различных сканеров.
Именно этот пакет требуется программам сканирования.

%description -n lib%name-devel
This package contains development environment for SANE.

%description -n lib%name-devel -l ru_RU.UTF-8
Этот пакет содержит файлы для разработки программ с использованием SANE.

%description -n lib%name-devel-static
This package contains SANE static libraries.

%description -n lib%name-devel-static -l ru_RU.UTF-8
Этот пакет содержит статические библиотеки SANE.

%prep
%setup -n %oname-%version
%patch3
%patch4
%patch5 -p2
%patch6 -p2
#patch7 -p2
#patch8 -p1

# Mandriva patches
%patch201 -p1 -b .plusteks12

# Disable v4l backend by default
sed -i 's/^\(v4l\)/#\1/g' backend/dll.conf.in

# Remove the backend/dll.conf file generated by the patches, it prevents
# the Makefile from generating  the real dll.conf file
rm -f backend/dll.conf

#-%version
#cp -f %%SOURCE1 po/%oname.ru.po

%ifarch %e2k
# strip UTF-8 BOM for lcc < 1.24
find -type f -print0 -name '*.cpp' -o -name '*.cc' -o -name '*.h' |
	xargs -r0 sed -ri 's,^\xEF\xBB\xBF,,'
%endif

sed -i "s|m4_esyscmd_s(\[.*git.*\])|%version|" configure.ac
#sed -i "s|python |%__python3 |" backend/Makefile.am
sed -i "s|AM_PATH_PYTHON(2.7)|AM_PATH_PYTHON(3.3)|" configure.ac

%build
%autoreconf
%configure --enable-translations --with-gphoto2 \
	--with-usb \
	--with-systemd \
	--with-gphoto2 \
	--with-v4l \
	--with-snmp \
	--enable-avahi \
	--enable-locking \
	--disable-rpath \
	--with-lockdir=%_lockdir/%name \
	--enable-shared \
	--disable-static

%make_build

%install
%makeinstall_std

# fix default path to firmware
sed -i "s|/path/to/your/firmware|%_libdir/hotplug/firmware|" %buildroot%_sysconfdir/sane.d/*.conf

# install udev rules
install -D -m0644 tools/udev/libsane.rules %buildroot%_udevrulesdir/25-libsane.rules
# follow fix drops GROUP! (alt bug #29425)
#remove ownership setup (was conflict with other services) see altbug #21808
#sed 's/,[[:space:]]\+GROUP=\"[^"]\+\"[[:space:]]*//' -i %buildroot%_udevrulesdir/25-libsane.rules

install -D %SOURCE2 -m0644 %buildroot%_sysconfdir/xinetd.d/%name
mkdir -p %buildroot%_lockdir/%name/
mkdir -p %buildroot%_tmpfilesdir/
echo "D %_lockdir/%name 0770 root scanner -" >%buildroot%_tmpfilesdir/%name.conf

rm -f %buildroot%_libdir/%name/*.la

%find_lang %oname

%pre -n lib%name
%groupadd -f scanner || :

%pre -n %name-server
%useradd -d /var/empty -s /dev/null -G scanner _saned || :

%files
%_bindir/sane-find-scanner
%_bindir/scanimage
%_bindir/gamma4scanimage
%_bindir/umax_pp
%_man1dir/*
%exclude %_man8dir/saned*
%exclude %_man1dir/sane-config*
%_man7dir/*

%files -n %name-server
%config(noreplace) %_sysconfdir/xinetd.d/%name
%config(noreplace) %_sysconfdir/sane.d/saned.conf
%_sbindir/saned
%_man8dir/saned*

%files doc
%_docdir/sane-backends/

%files -n lib%name -f %oname.lang
%_libdir/*.so.1
# to check we updated correctly
%_libdir/*.so.%version
%_udevrulesdir/*
%_man5dir/*
%dir %_sysconfdir/sane.d/
%config(noreplace) %_sysconfdir/sane.d/*
%exclude %_sysconfdir/sane.d/saned.conf
%dir %_libdir/%name/
%_libdir/%name/*.so.*
%_libdir/%name/*.so
%exclude %_libdir/sane/*gphoto2.so.*
%exclude %_libdir/sane/*gphoto2.so
# used in sane-frontends, xsane
%dir %_datadir/%name/
%attr(0775,root,scanner) %dir %_lockdir/%name/
%_tmpfilesdir/%name.conf

%files -n lib%name-gphoto2
%_libdir/sane/*gphoto2.so.*
%_libdir/sane/*gphoto2.so

%files -n lib%name-devel
%_bindir/sane-config
%_man1dir/sane-config*
%_libdir/*.so
%_includedir/sane/
%_pkgconfigdir/%oname.pc

%changelog
