Name: s3backer
Version: 2.1.6
Release: alt1

Summary: FUSE-based single file backing store via Amazon S3
License: GPLv2
Group: System/Kernel and hardware
Url: https://github.com/archiecobbs/s3backer

Requires: nbdkit %_sbindir/nbd-client

Source: %name-%version-%release.tar
BuildRequires: libcurl-devel libexpat-devel libfuse3-devel libssl-devel
BuildRequires: libzstd-devel nbdkit-devel zlib-devel

%description
s3backer is a filesystem that contains a single file backed by the Amazon S3.
As a filesystem, it is very simple: it provides a single normal file having
a fixed size.  Underneath, the file is divided up into blocks, and the content
of each block is stored in a unique Amazon S3 object.  In other words, what
s3backer provides is really more like an S3-backed virtual hard disk device,
rather than a filesystem.

%prep
%setup

%build
export ac_cv_path_NBD_CLIENT_EXECUTABLE=%_sbindir/nbd-client
export ac_cv_path_MODPROBE_EXECUTABLE=%_sbindir/modprobe
%add_optflags -D_FILE_OFFSET_BITS=64
%autoreconf
%configure
%make_build

%install
%makeinstall_std

%global _customdocdir %_defaultdocdir/%name

%files
%doc README
%_bindir/s3backer
%_libdir/nbdkit/plugins/nbdkit-s3backer-plugin.so
%_man1dir/s3backer.1*

%changelog
