%define        _unpackaged_files_terminate_build 1
%define        ruby_version_core 3.3
%define        ruby_version %{ruby_version_core}.0
%define        lname lib%name
%define        ruby_arch %(echo %_target | sed 's/^ppc/powerpc/')%([ -z "%_gnueabi" ] || echo "-eabi")
%define        _version %{ruby_version_core}.8
%define        __ruby env GEM_HOME=%_libexecdir/%name/gemie RUBYLIB=./:./lib ./miniruby -rerb -rrbconfig
%def_disable   html

Name:          ruby
Version:       %_version
Release:       alt2
Summary:       An Interpreted Object-Oriented Scripting Language
License:       BSD-2-Clause or Ruby
Group:         Development/Ruby
Url:           http://www.%name-lang.org/
Vcs:           https://github.com/ruby/ruby.git

Source0:       %name-%_version.tar
Source1:       %name.sh.erb
Source2:       ruby.macros.erb
Source3:       ruby.env
Source4:       ruby.alternatives.erb
Source5:       ruby-stdlibs.alternatives.erb
Patch1:        use_system_dirs.patch
Patch2:        single_instantiating.patch
Patch3:        alt_support_multiple_gem_trees.patch
Patch5:        alt_block_install_gems.patch
Patch6:        ac.patch
Patch7:        rearrange_loadpath.patch
%ifarch %e2k
Patch2000:     %name-e2k.patch
%endif
BuildRequires(pre): rpm-macros-valgrind
#NOTE enabled or a while
BuildRequires: ruby
BuildRequires: rvm-devel
BuildRequires: autoconf >= 2.71
# at least while bootstrapping on %%e2k
BuildRequires: /proc
%if_with check
BuildRequires: gem(rake) >= 0
BuildRequires: gem(benchmark_driver) >= 0
BuildRequires: gem(test-unit) >= 3.3.5
BuildRequires: gem(ipaddr) >= 0
%endif
%if_without check
#NOTE disabled for a while
#BuildConflicts: ruby
%endif

Requires(pre): alternatives >= 0:0.2.0-alt0.12
Requires:      %name-stdlibs = %EVR
Requires:      /bin/install
Provides:      /usr/bin/ruby

# Ruby built using LTO cannot rebuild itself because of segfaults
%define        optflags_lto %nil

%description
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing
system management tasks (as in Perl). It is simple, straight-forward, and
extensible.

This package contains interpreter of object-oriented scripting language Ruby.


%package       -n %lname
Summary:       Ruby shared libraries
Group:         System/Libraries
Provides:      ruby(enumerator)
Provides:      ruby(%ruby_version)

%description   -n %lname
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing system
management tasks (as in Perl). It is simple, straight-forward, and extensible.

This package contains Ruby shared libraries.


%package       -n %lname-devel
Summary:       Files for compiling extension modules for Ruby
Group:         Development/C
Requires:      %lname = %EVR

%description   -n %lname-devel
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing system
management tasks (as in Perl). It is simple, straight-forward, and extensible.

This package contains files, necessary to make extension library for Ruby.


%package       -n %name-devel
Summary:       Files for development and testing with Ruby
Group:         Development/C
BuildArch:     noarch

Requires:      %name = %EVR
Requires:      rvm >= 1.29.12.126-alt0.1
Requires:      libruby-devel = %EVR
Requires:      gem(rake) >= 0
Requires:      gem(benchmark_driver) >= 0
Requires:      gem(test-unit) >= 3.3.5
Requires:      gem(bundler) >= 0

%description   -n %name-devel
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing system
management tasks (as in Perl). It is simple, straight-forward, and extensible.

This package contains files, necessary to develop with ruby and for ruby testing
purposes.


%package       -n %name-stdlibs
Summary:       Standard Ruby libraries
Group:         Development/Ruby
Requires(pre): alternatives >= 0:0.2.0-alt0.12
Requires:      %lname = %EVR
Requires:      ruby = %EVR
Provides:      rubygems = 3.3.26
Provides:      rdoc = 6.4.0
Provides:      bundle = 2.3.26
Provides:      %name-libs = %EVR
Provides:      gem(fcntl) = 1.1.0
Provides:      gem(io-nonblock) = 0.3.0
Provides:      gem(stringio) = 3.1.1
Provides:      gem(abbrev) = 0.1.2
Provides:      gem(base64) = 0.2.0
Provides:      gem(benchmark) = 0.3.0
Provides:      gem(delegate) = 0.3.1
Provides:      gem(erb) = 4.0.3
Provides:      gem(fileutils) = 1.7.2
Provides:      gem(find) = 0.2.0
Provides:      gem(getoptlong) = 0.2.1
Provides:      gem(mutex_m) = 0.2.0
Provides:      gem(observer) = 0.1.2
Provides:      gem(open-uri) = 0.4.1
Provides:      gem(ostruct) = 0.6.0
Provides:      gem(pp) = 0.5.0
Provides:      gem(prettyprint) = 0.2.0
Provides:      gem(pstore) = 0.1.3
Provides:      gem(readline) = 0.0.4
Provides:      gem(resolv-replace) = 0.1.1
Provides:      gem(weakref) = 0.1.3
Provides:      gem(un) = 0.3.0
Provides:      gem(tsort) = 0.2.0
Provides:      gem(tmpdir) = 0.2.0
Provides:      gem(timeout) = 0.4.1
Provides:      gem(time) = 0.3.0
Provides:      gem(tempfile) = 0.2.1
Provides:      gem(singleton) = 0.2.0
Provides:      gem(shellwords) = 0.2.0
Provides:      gem(securerandom) = 0.3.1
Provides:      gem(ruby2_keywords) = 0.0.5
Provides:      gem(resolv) = 0.3.0
Provides:      gem(english) = 0.8.0
Provides:      gem(drb) = 2.2.0
Provides:      gem(cgi) = 0.4.1
Provides:      gem(csv) = 3.2.8
Provides:      gem(uri) = 0.13.0
Provides:      gem(set) = 1.1.0
Provides:      gem(irb) = 1.13.1
Provides:      gem(net-protocol) = 0.2.2
Provides:      gem(nkf) = 0.1.3
Provides:      gem(etc) = 1.4.3
Provides:      gem(zlib) = 3.1.1
Provides:      gem(json) = 2.7.1
Provides:      gem(yaml) = 0.3.0
Provides:      gem(rdoc) = 6.6.3.1
Provides:      gem(date) = 3.3.4
Provides:      gem(rinda) = 0.2.0
Provides:      gem(psych) = 5.1.2
Provides:      gem(open3) = 0.2.1
Provides:      gem(prism) = 0.19.0
Provides:      gem(logger) = 1.6.0
Provides:      gem(reline) = 0.5.7
Provides:      gem(syslog) = 0.1.2
Provides:      gem(fiddle) = 1.1.2
Provides:      gem(digest) = 3.1.1
Provides:      gem(bundler) = 2.5.11
Provides:      gem(strscan) = 3.0.9
Provides:      gem(openssl) = 3.2.0
Provides:      gem(io-wait) = 0.2.1
Provides:      gem(win32ole) = 1.8.10
Provides:      gem(pathname) = 0.3.0
Provides:      gem(delegate) = 0.2.0
Provides:      gem(net-http) = 0.4.1
Provides:      gem(optparse) = 0.4.0
Provides:      gem(io-console) = 0.7.1
Provides:      gem(bigdecimal) = 3.1.5
Provides:      gem(forwardable) = 1.3.3
Provides:      gem(did_you_mean) = 1.6.3
Provides:      gem(syntax_suggest) = 2.0.0
Provides:      gem(error_highlight) = 0.6.0

%description   -n %name-stdlibs
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing
system management tasks (as in Perl). It is simple, straight-forward, and
extensible.

This package contains standard Ruby runtime libraries.


%package       doc-html
Summary:       Ruby manuals and documentation
Group:         Development/Documentation
Requires:      ruby = %EVR

%description   doc-html
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing
system management tasks (as in Perl). It is simple, straight-forward, and
extensible.

Ruby manuals and documentation.


%package       doc
Summary:       Ruby executable document in ri format
Group:         Development/Documentation
Requires:      %name = %EVR
BuildArch:     noarch

%description   doc
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing
system management tasks (as in Perl). It is simple, straight-forward, and
extensible.

This package contains Ruby documentation in ri format.


%package       -n rpm-macros-ruby
Epoch:         1
Summary:       rpm macros for Ruby packages
Group:         Development/Ruby

%description   -n rpm-macros-ruby
rpm macros for Ruby packages.


%prep
%setup
%autopatch -p1

%install
DESTDIR=%buildroot INSTALL=/bin/install rvm reinstall . \
   --gems-path=/tmp/ \
   --rubies-path=/tmp \
   --log-path=/tmp/ \
   --enable-shared \
%ifarch %valgrind_arches
   --enable-valgrind \
%endif
%ifarch %e2k
   --disable-jit-support \
%endif
   --enable-rubygems \
   --enable-use-system-dirs \
   --enable-single-instantiating \
   --enable-install-doc \
   --enable-install-rdoc \
   --enable-install-capi \
   --disable-rpath \
   --mandir=%_mandir \
   --libdir=%_libdir \
   --datarootdir=%_datadir \
   --libexecdir=%_libexecdir \
   --bindir=%_libexecdir/%name/bin \
   --sysconfdir=%_sysconfdir \
   --sharedstatedir=%_localstatedir \
   --localstatedir=%_localstatedir \
   --runstatedir=%_runtimedir \
   --docdir=%_defaultdocdir/%name \
   --with-baseruby=/usr/bin/ruby \
   --with-cachedir=%_cachedir/%name \
   --with-ridir=%_datadir/ri/ \
   --with-exec-prefix=%_libexecdir/%name/bin \
   --with-rubylibdir=%_libexecdir/%name \
   --with-archlibdir=%_libdir/%name \
   --with-rubylibprefix=%_libexecdir/%name \
   --with-rubyarchprefix=%_libdir/%name \
   --with-rubyarchdir=%_libdir/%name \
   --with-rubyhdrdir=%_includedir \
   --with-rubyarchhdrdir=%_includedir/%name/arch \
   --with-sitedir=%_usr/local/lib \
   --with-sitelibdir=%_usr/local/lib/%name \
   --with-sitearchdir=%_usr/local/%_lib/%name \
   --with-sitearchlibdir=%_usr/local/%_lib/%name \
   --with-sitearchdir=%_usr/local/%_lib/%name \
   --with-sitehdrdir=%_usr/local/include \
   --with-sitearchincludedir=%_usr/local/include/%name \
   --with-sitearchhdrdir=%_usr/local/include/%name \
   --with-rubysitearchprefix=%_usr/local/%_lib/%name \
   --with-vendordir=%_libexecdir/%name/vendor_ruby \
   --with-vendorlibdir=%_libexecdir/%name/vendor_ruby \
   --with-vendorarchdir=%_libexecdir/%name/vendor_ruby \
   --with-rdoc=ri%{?_enable_html:,html} \
   -C --prefix=%_prefix \

mkdir -p \
   %buildroot%_libexecdir \
   %buildroot%_cachedir/%name/gemie/bin \
   %buildroot%_bindir/ \
   %buildroot%_sysconfdir/bashrc.d/ \
   %buildroot%_libdir \
   %buildroot%_altdir \
   %buildroot%_docdir/%name

cp COPYING LEGAL NEWS* README.md README.EXT *.ja %buildroot%_docdir/%name/
ln -s %name-%{ruby_version_core}.pc %buildroot%_pkgconfigdir/%name.pc
# install ruby macros
install -D -p -m 0644 %SOURCE3 %buildroot%_rpmmacrosdir/ruby.env
%__ruby -e 'File.open("%buildroot%_sysconfdir/bashrc.d/%name.sh", "w") { |f| f.puts ERB.new(IO.read("%SOURCE1")).result }'
%__ruby -e 'File.open("%buildroot%_rpmmacrosdir/ruby", "w") { |f| f.puts ERB.new(IO.read("%SOURCE2")).result }'
%__ruby -e 'File.open("%buildroot%_altdir/%name", "w") { |f| f.puts ERB.new(IO.read("%SOURCE4")).result }'
%__ruby -e 'File.open("%buildroot%_altdir/%name-stdlibs", "w") { |f| f.puts ERB.new(IO.read("%SOURCE5")).result }'

# cleanup gems folder for default ones
rm -rf %buildroot%_libexecdir/%name/gemie/gems/*

%check
%make test

%files
%_altdir/%name
%_man1dir/%name.*
%dir %_datadir/ri
%attr(0755,root,root) %_sysconfdir/bashrc.d/%name.sh
%dir %attr(775,root,root) %_cachedir/%name/
%dir %attr(775,root,root) %_cachedir/%name/gemie
%dir %attr(775,root,root) %_cachedir/%name/gemie/bin

%files         -n %lname
%_libdir/*.so.*

%files         -n %lname-devel
%_pkgconfigdir/*
%_includedir/%name
%_includedir/%name.h
%_libdir/*.so

%files         -n %name-devel

%files         stdlibs
%_libexecdir/%name
%_altdir/%name-stdlibs
%_libdir/%name
%_man1dir/erb.*
%lang(ja) %doc doc/irb/*.ja
%_man1dir/irb.*

%files         doc-html
%doc %_docdir/%name/COPYING
%doc %_docdir/%name/LEGAL
%doc %_docdir/%name/NEWS*
%doc %_docdir/%name/README.md
%doc %_docdir/%name/README.EXT
%doc %_docdir/%name
%lang(ja) %doc %_docdir/%name/*.ja

%files         doc
%doc %_docdir/%name/README.md
%_man1dir/ri.*
%_datadir/ri/system

%files         -n rpm-macros-ruby
%_rpmmacrosdir/ruby
%_rpmmacrosdir/ruby.env

%changelog
