Name: rubberband
Version: 4.0.0
Release: alt1

Summary: High quality library for audio time-stretching and pitch-shifting
License: GPL-2.0-or-later
Group: Sound
Url: http://www.breakfastquay.com/rubberband/

Vcs: https://github.com/breakfastquay/rubberband.git
Source: %name-%version.tar

BuildRequires: gcc-c++ meson
BuildRequires: ladspa_sdk libfftw3-devel libsamplerate-devel libsndfile-devel libvamp-devel lv2-devel

%package -n librubberband3
Summary: High quality library for audio time-stretching and pitch-shifting
Group: System/Libraries

%package -n librubberband-devel
Summary: Headers for %name
Group: Development/C

%package -n ladspa-rubberband
Summary: An audio time-stretching and pitch-shifting LADSPA plugin
Group: Sound

%package -n lv2-rubberband
Summary: An audio time-stretching and pitch-shifting LV2 plugin
Group: Sound

%package -n vamp-rubberband
Summary: An audio time-stretching and pitch-shifting Vamp plugin
Group: Sound

%define desc \
Rubber Band Library is a high quality software library for audio time-stretching\
and pitch-shifting. It permits you to change the tempo and pitch of an audio\
recording or stream dynamically and independently of one another.

%description %desc

%description -n librubberband3 %desc

%description -n librubberband-devel %desc
Headers for building software that uses %name

%description -n ladspa-rubberband
An audio time-stretching and pitch-shifting LADSPA plugin

%description -n lv2-rubberband
An audio time-stretching and pitch-shifting LV2 plugin

%description -n vamp-rubberband
An audio time-stretching and pitch-shifting Vamp plugin

%prep
%setup

%build
%meson -Dfft=fftw -Dresampler=libsamplerate -Ddefault_library=shared
%meson_build

%install
%meson_install

%files
%_bindir/rubberband*

%files -n librubberband3
%doc README* CHANGELOG
%_libdir/*.so.*

%files -n librubberband-devel
%_includedir/rubberband
%_libdir/*.so
%_pkgconfigdir/*.pc

%files -n ladspa-rubberband
%_libdir/ladspa/ladspa-rubberband*
%_datadir/ladspa/rdf/ladspa-rubberband*

%files -n lv2-rubberband
%_libdir/lv2/rubberband.lv2

%files -n vamp-rubberband
%_libdir/vamp/vamp-rubberband*

%changelog
