%def_disable check

Name: rpmlint
Version: 2.4.0
Release: alt2

Summary: Tool for checking common errors in RPM packages
License: GPL-2
Group: Development/Other
URL: https://github.com/rpm-software-management/rpmlint

Source0: %name-%version.tar
Patch0: %name-%version.patch
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel

%if_enabled check
# for tests
BuildRequires: /proc
BuildRequires: python3-module-pyxdg python3-module-rpm python3-module-toml python3-module-zstd python3-module-pybeam
BuildRequires: python3-module-pytest python3-module-pytest-cov python3-module-pytest-flake8 python3-module-pytest-xdist
BuildRequires: python3-module-enchant hunspell-en hunspell-cs glibc-locales
BuildRequires: glibc-utils binutils
BuildRequires: dash
BuildRequires: /usr/bin/appstream-util
BuildRequires: /usr/bin/checkbashisms
BuildRequires: /usr/bin/desktop-file-validate
%endif

Requires: rpm-build glibc-utils binutils
#Requires: /usr/bin/appstream-util
Requires: /usr/bin/bzip2
Requires: /usr/bin/checkbashisms
Requires: /bin/cpio
Requires: /usr/bin/desktop-file-validate
Requires: /usr/bin/groff
Requires: /usr/bin/gtbl
Requires: /usr/bin/ldd
Requires: /usr/bin/man
Requires: /usr/bin/perl
Requires: /usr/bin/readelf
Requires: /usr/bin/xz
Requires: /usr/bin/zstd
%py3_requires tomli
%py3_requires magic
%py3_provides rpmlint.checks

%description
Rpmlint is a tool to check common errors on rpm packages.
Binary and source packages can be checked.

%prep
%setup -q
%patch0 -p1

%build
%python3_build

%install
%python3_install

mkdir -p %buildroot%_sysconfdir/xdg/rpmlint
cp -a configs/ALT/*.toml %buildroot%_sysconfdir/xdg/rpmlint/

%check
python3 -m pytest

%files
%doc README.md
%config(noreplace) %_sysconfdir/xdg/rpmlint/*.toml
%_bindir/*
%python3_sitelibdir/*

%changelog
