Name: rpm-build-python3
Version: 0.1.28
Release: alt1

Summary: RPM helper macros to rebuild python3 packages
License: GPLv2+
Group: Development/Other
Packager: Python Development Team <python@packages.altlinux.org>

Source: %name-%version.tar
BuildArch: noarch

Requires: rpm-macros-python3 = %EVR
Requires: file >= 4.26-alt11
# Since the .so handling code in python3.req.py with the help of
# objdump is borrowed from rpm-build, we borrow the dependency, too
# (in the form of a Conflicts not to encumber python3 users' envinronment;
# anyway, if the user is able to compile an .so, he would have got binutils):
Conflicts: binutils < 1:2.20.51.0.7

# We want that the following directory gets detected as a dep of the built python3 pkgs;
# this happens automatically of the packages that owns it is installed.
Requires: %_rpmlibdir/python3-site-packages-files.req.list
# (The lib64 variant must be owned by the same package; thus it must be detected as well.)

# For convenience of the developers:
Requires: tests-for-installed-python3-pkgs

Conflicts: python3 < 3.5

AutoReqProv: yes, nopython

BuildRequires: python3-dev python3-module-py3dephell

%description
These helper macros provide possibility to build python3 modules.

%package -n rpm-macros-python3
Summary: Set of RPM macros for packaging python3 modules and scripts
Group: Development/Other
BuildArch: noarch
Conflicts: %name < %version
# due to %%_is_libsuff and %%_libsuff macros.
Conflicts: rpm-build < 4.0.4-alt112

%description -n rpm-macros-python3
This packages provides RPM macros for packaging python3 modules and scripts.

%package -n tests-for-installed-python3-pkgs
Summary: Tests that can be run to test any installed Python3 package
Group: Development/Other

Requires: /usr/bin/python3

%description -n tests-for-installed-python3-pkgs
The included scripts are primarily to be run by package maintainers
(or automated testing systems) to test any Python3 package
in an environment where it has been installed by RPM.

Contents:

* check-python3-provs-importable -- a script to test installed Python3 packages
* py3-* -- helper scripts (for such tests)

Example:

apt-repo --hsh-apt-config="$HOME"/.hasher/sisyphus/apt.conf test NNNNNN python3-module-FOOBAR \
&& hsh-run /usr/lib/rpm/check-python3-provs-importable python3-module-FOOBAR; echo $?

will report which modules provided by python3-module-FOOBAR are not importable
(if any) in the minimal environment. This is a packaging error if there are any.

%prep
%setup

%install
install -pD -m0644 python3 -t %buildroot%_rpmmacrosdir/
install -pD -m0644 python3.env -t %buildroot%_rpmmacrosdir/
install -pD -m0644 python3.buildreq -T %buildroot%_sysconfdir/buildreqs/files/ignore.d/%name
install -pD -m0755 python3.prov -t %buildroot%_rpmlibdir/
install -pD -m0755 python3.prov.py -t %buildroot%_rpmlibdir/
install -pD -m0755 python3.prov.files -t %buildroot%_rpmlibdir/
install -pD -m0755 python3.req -t %buildroot%_rpmlibdir/
install -pD -m0755 python3.req.py -t %buildroot%_rpmlibdir/
install -pD -m0755 python3.req.constraint.py -t %buildroot%_rpmlibdir/
install -pD -m0755 python3.req.files -t %buildroot%_rpmlibdir/
install -pD -m0755 python3.compileall.py -t %buildroot%_rpmlibdir/
install -pD -m0755 check-python3-provs-importable -t %buildroot%_rpmlibdir/
install -pD -m0755 py3-scan-reqprovs -t %buildroot%_rpmlibdir/
install -pD -m0755 py3-check-importable -t %buildroot%_rpmlibdir/
install -pD -m0755 brp-bytecompile_python3 -T %buildroot%_rpmlibdir/brp.d/096-bytecompile_python3.brp
# It's like brp.d/128-hardlink_pyo_pyc.brp from rpm-build (but for python3-3.5):
install -pD -m0755 brp-hardlink_opt_pyc -T %buildroot%_rpmlibdir/brp.d/128-hardlink_opt_pyc.brp
install -pD -m0755 brp-fix_python3_site-packages_location -T %buildroot%_rpmlibdir/brp.d/000-fix_python3_site-packages_location.brp
#install -pd -m0755 %buildroot%python_tooldir/rpm-build
#install -pD -m0644 bdist_altrpm.py -t %buildroot%_libdir/python%__python_version/distutils/command/
#install -pD -m0755 tools/*py -t %buildroot%python_tooldir/rpm-build
#install -pd -m0755 %buildroot%python_tooldir/rpm-build/find
#install -pD -m0644 tools/find/*py -t %buildroot%python_tooldir/rpm-build/find
#install -pd -m0755 %buildroot%_bindir

#ln -s --relative %buildroot%python_tooldir/rpm-build/imalyzer.py -T %buildroot%_bindir/imalyzer
#ln -s --relative %buildroot%python_tooldir/rpm-build/requires.py -T %buildroot%_bindir/py_requires
#ln -s --relative %buildroot%python_tooldir/rpm-build/provides.py -T %buildroot%_bindir/py_provides

#unset RPM_PYTHON

%define _unpackaged_files_terminate_build 1

%check
rpm_builddir="$PWD"
pushd %buildroot/%_rpmlibdir
# It calls ./python3.req, therefore we've changed the CWD:
"$rpm_builddir"/test_req.sh
"$rpm_builddir"/test_check-provs-importable.sh
popd

%files -n rpm-macros-python3
%_rpmmacrosdir/python3
%_rpmmacrosdir/python3.env
%_rpmlibdir/python3.req
%_rpmlibdir/python3.req.files
%_rpmlibdir/python3.prov
%_rpmlibdir/python3.prov.files

%files
%_sysconfdir/buildreqs/files/ignore.d/%name
%_rpmlibdir/brp.d/096-bytecompile_python3.brp
%_rpmlibdir/brp.d/128-hardlink_opt_pyc.brp
%_rpmlibdir/brp.d/000-fix_python3_site-packages_location.brp
%_rpmlibdir/python3.compileall.py
%_rpmlibdir/python3.req.py
%_rpmlibdir/python3.req.constraint.py
%_rpmlibdir/python3.prov.py

%files -n tests-for-installed-python3-pkgs
%_rpmlibdir/check-python3-provs-importable
%_rpmlibdir/py3-scan-reqprovs
%_rpmlibdir/py3-check-importable

%changelog
