# vim: set ft=spec: -*- rpm-spec -*-

%define _name licenses

Name: rpm-build-%_name
Version: 3.0.0
Release: alt1

Summary: RPM macros for well-known licenses
# We can't use our own macros...
License: GPLv2
Group: Development/Other
Url: http://www.altlinux.org/License

Source: %name-%version.tar

Packager: Aleksey Avdeev <solo@altlinux.ru>
BuildArch: noarch

Requires: common-licenses

%description
This package contains RPM macros for license names commonly used in
Open Source software. Use these macros in License tags of your specfiles.

%prep
%setup -n %name-%version
ln -sf %_licensedir/GPL-2 COPYING

%install
cat <<__EOF__ >%_name.rpmmacros
%%gpl2only GPLv2
%%gpl2plus GPLv2+
%%gpl3only GPLv3
%%gpl3plus GPLv3+
%%lgpl2only LGPLv2
%%lgpl21only LGPLv2.1
%%lgpl2plus LGPLv2+
%%lgpl21plus LGPLv2.1+
%%lgpl3only LGPLv3
%%lgpl3plus LGPLv3+
%%bsd_orig BSD-4-Clause-UC
%%bsd BSD
%%bsdstyle BSD-4-Clause
%%mit MIT
%%mpl MPL-2.0
%%w3cl W3C
%%asl Apache-2.0
%%jpackage_license GPL2+ or Apache-2.0
%%sendmail_license Sendmail
%%artistic_license Artistic-1.0
%%artistic_license_v2 Artistic-2.0
%%perl_license Perl
%%fdl FDL-1.2
%%gfdl GFDL-1.3+
%%lppl LPPL-1.3c
%%qpl1 QPL-1.0
%%ccbysa30 CC-BY-SA-3.0
%%ccby30 CC-BY-3.0
%%ccbysa25 CC-BY-SA-2.5
%%ccby25 CC-BY-2.5
%%epl ErlPL
%%pubdomain ALT-Public-Domain
%%gagpl3only AGPL-3.0
%%gagpl3plus AGPL-3.0+

# Not sure whether these ones should exist at all. Too clumsy names and vague
# semantics.
%%gpllgpl2only \
%{warning Hopefully you have read the README section about %%gpllgpl* macros.}\
GPLv2 and LGPLv2
%%gpllgpl2plus \
%{warning Hopefully you have read the README section about %%gpllgpl* macros.}\
GPLv2+ and LGPLv2+
%%gpllgpl3only \
%{warning Hopefully you have read the README section about %%gpllgpl* macros.}\
GPLv3 and LGPLv3
%%gpllgpl3plus \
%{warning Hopefully you have read the README section about %%gpllgpl* macros.}\
GPLv3+ and LGPLv3+
__EOF__
install -pD -m644 %_name.rpmmacros %buildroot%_rpmmacrosdir/%_name

%files
%_rpmmacrosdir/%_name
%doc README
%doc --no-dereference COPYING

%changelog
