# fakechroot is currently broken on 32-bit arches
%ifarch i586 armh
    %def_disable check
%else
    %def_enable check
%endif
%def_with libarchive
%def_without libimaevm
%def_enable plugins
%def_disable rpmbuild
%def_with xz
%def_with zstd
%def_with memcached
%def_enable default_priority_distbranch
%def_with profile

%define rpmhome /usr/lib/rpm

%define bdbname libdb4
%define dbprefix db

%define sover 7

Summary: The RPM package management system
Name: rpm
Version: 4.13.0.1
Release: alt42
Group: System/Configuration/Packaging
Url: http://www.rpm.org/
# http://git.altlinux.org/gears/r/rpm.git
Source0: rpm-%version.tar

# Partially GPL/LGPL dual-licensed and some bits with BSD
# SourceLicense: (GPLv2+ and LGPLv2+ with exceptions) and BSD
License: GPLv2+

%define eggver %version

Requires: coreutils
Requires: popt >= 1.10.2.1
Requires: librpm%sover
Conflicts: apt < 0.5.15lorg2-alt54

# Can find pkgs by N-EPOCH:V-R
# (a feature present in rpm-4.13, but not in all releases of rpm-4.0.4):
Provides: RPMQ(EPOCH)
# Can find pkgs by N[-E:V-R]@BUILDTIME
Provides: RPMQ(BUILDTIME)
# Can find pkgs by N-E:V-R:DISTTAG[@T]
Provides: RPMQ(DISTTAG)

BuildRequires(pre): rpm-build-python3
BuildRequires: %bdbname-devel

BuildRequires: gawk
BuildRequires: elfutils-devel >= 0.112
BuildRequires: libelf-devel
BuildRequires: readline-devel zlib-devel
BuildRequires: libsha1detectcoll-devel
BuildRequires: libgcrypt-devel
#BuildRequires: nss-softokn-freebl-devel
# The popt version here just documents an older known-good version
BuildRequires: popt-devel >= 1.10.2
BuildRequires: libmagic-devel
BuildRequires: gettext-devel
BuildRequires: bzip2-devel
BuildRequires: python-devel >= 2.6
BuildRequires: python3-devel >= 3.2
BuildRequires: liblua5.3-devel
BuildRequires: libcap-devel
BuildRequires: libacl-devel
%if_with xz
BuildRequires: liblzma-devel >= 4.999.8
%endif
%if_with zstd
BuildRequires: libzstd-devel
%endif
%if_with libarchive
BuildRequires: libarchive-devel
%endif
# Couple of patches change makefiles so, require for now...
BuildRequires: automake libtool

%if_enabled plugins
BuildRequires: libselinux-devel
BuildRequires: libdbus-devel
%endif

%if_with libimaevm
BuildRequires: ima-evm-utils
%endif

%if_with memcached
BuildRequires: libmemcached-devel liblzo2-devel
%endif

%{?!_without_check:%{?!_disable_check:BuildRequires: fakechroot strace}}

%description
The RPM Package Manager (RPM) is a powerful command line driven
package management system capable of installing, uninstalling,
verifying, querying, and updating software packages. Each software
package consists of an archive of files along with information about
the package like its version, a description, etc.

%package -n rpm2archive
Summary: Program which converts rpm payload to tar archive
Group: Archiving/Other
Requires: librpm%sover

%description -n rpm2archive
This package contains rpm2archive utility. It can be used to convert rpm
package into tarball.

%package -n rpmspec
Summary: Program which allows to query rpm specfile.
Group: Archiving/Other
Conflicts: rpm < 4.13.0-alt6
Requires: librpmbuild%sover

%description -n rpmspec
This package contains rpmspec utility. It can be used to query rpm specfile.

%package -n librpm%sover
Summary: Libraries for manipulating RPM packages
Group: System/Libraries
License: GPLv2+ and LGPLv2+ with exceptions
Provides: rpm-plugin-selinux = %EVR
Provides: librpmio(PGPHASHALGO_BLAKE2B)%{?_is_libsuff:(%{_libsuff}bit)} = 100
Obsoletes: rpm-plugin-selinux < %EVR
Conflicts: librpm < 4.0.4-alt102
# due to liblua update
# libapt 0.5.15lorg2-alt56 was rebuilt with lua 5.3.
Conflicts: libapt < 0.5.15lorg2-alt56

%description -n librpm%sover
This package contains the RPM shared libraries.

%package -n librpmbuild%sover
Summary: Libraries for building and signing RPM packages
Group: System/Libraries
License: GPLv2+ and LGPLv2+ with exceptions
Requires: librpm%sover

%description -n librpmbuild%sover
This package contains the RPM shared libraries for building and signing
packages.

%package -n librpm-devel
Summary: Development files for manipulating RPM packages
Group: Development/C
License: GPLv2+ and LGPLv2+ with exceptions
Requires: rpm
Requires: librpm%sover
Requires: librpmbuild%sover
Provides: rpm-devel = %EVR

%description -n librpm-devel
This package contains the RPM C library and header files. These
development files will simplify the process of writing programs that
manipulate RPM packages and databases. These files are intended to
simplify the process of creating graphical package managers or any
other tools that need an intimate knowledge of RPM packages in order
to function.

This package should be installed if you want to develop programs that
will manipulate RPM packages and databases.

%package build
Summary: Scripts and executable programs used to build packages
Group: Development/Other
Requires: rpm
Requires: elfutils >= 0.128 binutils
Requires: findutils sed grep gawk diffutils file patch >= 2.5
Requires: tar unzip gzip bzip2 cpio xz
Requires: pkgconfig >= 1:0.24
Requires: rpm-build-perl

%description build
The rpm-build package contains the scripts and executable programs
that are used to build packages using the RPM Package Manager.

%package sign
Summary: Package signing support
Group: Development/Other
Requires: librpmbuild%sover

%description sign
This package contains support for digitally signing RPM packages.

%package -n python-module-rpm
Summary: Python 2 bindings for apps which will manipulate RPM packages
Group: Development/Python
Requires: rpm
Provides: rpm-python = %EVR

%description -n python-module-rpm
The rpm-python package contains a module that permits applications
written in the Python programming language to use the interface
supplied by RPM Package Manager libraries.

This package should be installed if you want to develop Python 2
programs that will manipulate RPM packages and databases.

%package -n python3-module-rpm
Summary: Python 3 bindings for apps which will manipulate RPM packages
Group: Development/Python3
Requires: rpm

%description -n python3-module-rpm
The rpm-python3 package contains a module that permits applications
written in the Python programming language to use the interface
supplied by RPM Package Manager libraries.

This package should be installed if you want to develop Python 3
programs that will manipulate RPM packages and databases.

%package apidocs
Summary: API documentation for RPM libraries
Group: Documentation
BuildArch: noarch

%description apidocs
This package contains API documentation for developing applications
that will manipulate RPM packages and databases.

%package plugin-syslog
Summary: Rpm plugin for syslog functionality
Group: System/Configuration/Packaging
Requires: librpm%sover

%description plugin-syslog
%summary

%package plugin-systemd-inhibit
Summary: Rpm plugin for systemd inhibit functionality
Group: System/Configuration/Packaging
Requires: librpm%sover

%description plugin-systemd-inhibit
This plugin blocks systemd from entering idle, sleep or shutdown while
an rpm transaction is running using the systemd-inhibit mechanism.

%package plugin-ima
Summary: Rpm plugin ima file signatures
Group: System/Configuration/Packaging
Requires: librpm%sover

%description plugin-ima
%summary

%package plugin-hdrcache
Summary: Rpm plugin for caching headers in memecached
Group: System/Configuration/Packaging
Requires: librpm%sover
Provides: rpmhdrmemcache = 0.1.2-alt4
Obsoletes: rpmhdrmemcache <= 0.1.2-alt3.1

%description plugin-hdrcache
%summary

%package checkinstall
Summary: Run tests for %name immediately when this package is installed
Group: Other
BuildArch: noarch
Requires: %name
Requires: rpminstall-tests-archcompat-checkinstall
Requires: rpminstall-tests-checkinstall

%description checkinstall
%summary

%prep
%setup

%build
_PRIORITY_DISTBRANCH=%{?!_disable_default_priority_distbranch:%{?disttag}}
_PRIORITY_DISTBRANCH="${_PRIORITY_DISTBRANCH#*:}" # skip the optional padding
case "$_PRIORITY_DISTBRANCH" in
*+*) _PRIORITY_DISTBRANCH="${_PRIORITY_DISTBRANCH%%+*}" ;;
*) _PRIORITY_DISTBRANCH= ;;
esac
[ -n "$_PRIORITY_DISTBRANCH" ] || _PRIORITY_DISTBRANCH='%%nil'
export _PRIORITY_DISTBRANCH

CPPFLAGS="$CPPFLAGS -I/usr/include/beecrypt -DLUA_COMPAT_APIINTCASTS"
export CPPFLAGS
%add_optflags -DLUA_COMPAT_APIINTCASTS

%autoreconf

for i in $(find . -name ltmain.sh) ; do
     sed -i.backup -e 's~compiler_flags=$~compiler_flags="%optflags"~' $i
done;

%configure \
	--with-vendor=alt \
	--with-external-db \
	%{subst_enable plugins} \
	--with-lua \
	--with-selinux \
	--with-cap \
	--with-acl \
	--enable-python \
	#

%make_build

rpmquery -a --provides |fgrep '= set:' |sort >P
rpmquery -a --requires |fgrep '= set:' |sort >R
join -o 1.3,2.3 P R |shuf >setcmp-data
time ./setcmp <setcmp-data >/dev/null
rm lib/set.lo lib/librpm.la
set_c_cflags="$(sed -n 's/^CFLAGS = //p' lib/Makefile) -W -Wno-override-init %{!?_enable_debug:-O3} -fno-builtin-memcmp"
%make_build -C lib set.lo librpm.la CFLAGS="$set_c_cflags"

%if_with profile
time ./setcmp <setcmp-data >/dev/null
rm lib/set.lo lib/librpm.la
%make_build -C lib set.lo librpm.la CFLAGS="$set_c_cflags -fprofile-generate"
./setcmp <setcmp-data >/dev/null
%ifnarch %e2k
ls -l lib/.libs/set.gcda
%else
mv eprof*.sum* lib
%endif
rm lib/set.lo lib/librpm.la
%make_build -C lib set.lo CFLAGS="$set_c_cflags -fprofile-use"
%endif #with profile

%make_build
time ./setcmp <setcmp-data >/dev/null

pushd python
%python_build
%python3_build
popd

%install
%makeinstall_std

# We need to build with --enable-python for the self-test suite, but we
# actually package the bindings built with setup.py (#531543#c26)
rm -rf %buildroot/%python_sitelibdir
rm -rf %buildroot/%python3_sitelibdir
pushd python
%python_install
export RPM_LD_PRELOAD_py2_rpmb=%buildroot%python_sitelibdir/rpm/_rpmb.so
export RPM_FILES_TO_LD_PRELOAD_py2_rpmb=%python_sitelibdir/rpm/_rpms.so
%python3_install
export RPM_LD_PRELOAD_py3_rpmb=%buildroot%python3_sitelibdir/rpm/_rpmb%_python3_extension_suffix
export RPM_FILES_TO_LD_PRELOAD_py3_rpmb=%python3_sitelibdir/rpm/_rpms%_python3_extension_suffix
popd

mkdir -p %buildroot/lib/tmpfiles.d
echo "r /var/lib/rpm/__db.*" > %buildroot/lib/tmpfiles.d/rpm.conf

mkdir -p %buildroot%_sysconfdir/rpm
mkdir -p %buildroot%_sysconfdir/rpm/macros.d
mkdir -p %buildroot%rpmhome/macros.d

mkdir -p %buildroot/var/lib/rpm
for dbi in \
    Basenames Conflictname Dirnames Group Installtid Name Obsoletename \
    Packages Providename Requirename Triggername Sha1header Sigmd5 \
    Enhancename Filetriggername Recommendname Suggestname Supplementname \
    Transfiletriggername \
    __db.001 __db.002 __db.003 __db.004 __db.005 __db.006 __db.007 \
    __db.008 __db.009
do
    touch %buildroot/var/lib/rpm/$dbi
done

# plant links to relevant db utils as rpmdb_foo for documention compatibility
# ALT (glebfm@): adds conflict (rpm -> db_utils vs other-db_utils)
%if 0
for dbutil in dump load recover stat upgrade verify
do
    ln -s ../../bin/%{dbprefix}_${dbutil} %buildroot/%rpmhome/rpmdb_${dbutil}
done
%endif

mkdir -p %buildroot/bin
ln -sr %buildroot%_bindir/rpm %buildroot/bin/rpm

sed -i '1i .\\" -*- mode: troff; coding: utf8 -*-' \
	%buildroot%_mandir/*/man1/*.1 \
	%buildroot%_mandir/*/man8/*.8

#%%if_enabled rpmbuild
#chmod a+x scripts/find-lang.sh
#RPMCONFIGDIR=./scripts ./scripts/find-lang.sh %name --output %name.lang
#%%else
%find_lang %name
#%%endif

find %buildroot -name "*.la"|xargs rm -f

# These live in perl-generators now
rm -f %buildroot/%rpmhome/{perldeps.pl,perl.*}
# Axe unused cruft
rm -f %buildroot/%rpmhome/{tcl.req,osgideps.pl}

touch %buildroot%_sysconfdir/%name/macros

touch %buildroot%_localstatedir/%name/delay-posttrans-filetriggers
touch %buildroot%_localstatedir/%name/files-awaiting-filetriggers

%check
if ! make check; then
	[ ! -s tests/rpmtests.log ] || sed '\!## ../config.log ##!q' tests/rpmtests.log
	exit 1
fi

# Run no-pass-on-failure test(s).
rpmio/test_digest_blake2b
rpmio/test_digest_sha1dc
tools/pdeath_execute.test

#%%pre
#[ ! -L %%_rpmlibdir/noarch-alt-%%_target_os ] || rm -f %%_rpmlibdir/noarch-alt-%%_target_os ||:

%post
if [ -f %_localstatedir/PackageKit/disable-rpm-triggers ]; then
        exit 0
fi

#chgrp %%name %%_localstatedir/%%name/[A-Z]*
[ -n "$DURING_INSTALL" -o -n "$BTE_INSTALL" ] ||
        %_rpmlibdir/pdeath_execute $PPID %_rpmlibdir/postupdate

# Invalidate apt cache, due to e.g. rpmlib(PayloadIsLzma).
if set /var/cache/apt/*.bin && [ -f "$1" ]; then
        %_rpmlibdir/pdeath_execute $PPID rm -f "$@"
fi
:

%triggerpostun -- rpm <= 4.0.4
touch /var/lib/rpm/delay-posttrans-filetriggers

%files -f %name.lang
%doc CREDITS doc/manual/[a-z]*

/lib/tmpfiles.d/rpm.conf
%dir %_sysconfdir/rpm

%attr(0755, root, root) %dir /var/lib/rpm
%attr(0644, root, root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/lib/rpm/*
%config(noreplace,missingok) %_sysconfdir/%name/macros

/bin/rpm
%_bindir/rpm
%_bindir/rpm2cpio
%_bindir/rpmdb
%_bindir/rpme
%_bindir/rpmi
%_bindir/rpmkeys
%_bindir/rpmquery
%_bindir/rpmsign
%_bindir/rpmu
%_bindir/rpmverify

%_bindir/rpmevrcmp
%_bindir/rpmvercmp

%_mandir/man8/rpm.8*
%_mandir/man8/rpm2cpio.8*
%_mandir/man8/rpmdb.8*
%_mandir/man8/rpmkeys.8*
%_mandir/man8/rpmsign.8*

%dir %_sysconfdir/rpm/macros.d
%rpmhome/macros.d
%rpmhome/rpmpopt*
%rpmhome/GROUPS

%rpmhome/rpmd
%rpmhome/rpme
%rpmhome/rpmi
%rpmhome/rpmk
%rpmhome/rpmq
%rpmhome/rpmu
%rpmhome/rpmv
%rpmhome/rpmdb_*

%rpmhome/.provides.sh
%rpmhome/functions

%rpmhome/0ldconfig.filetrigger
%rpmhome/find-package
%rpmhome/posttrans-filetriggers

%rpmhome/postupdate

%rpmhome/pdeath_execute

%rpmhome/platform

%files -n rpm2archive
%_bindir/rpm2archive

%files -n rpmspec
%_bindir/rpmspec
%_mandir/man8/rpmspec.8*

%define rpmdirattr %attr(2755,root,%name) %dir

%files -n librpm%sover
%rpmdirattr %dir %rpmhome
%_libdir/librpm.so.*
%_libdir/librpmio.so.*
%_libdir/librpmsign.so.*
%_libdir/rpm-plugins/selinux.so
%rpmhome/macros
%rpmhome/rpmrc

%if_enabled plugins
%dir %_libdir/rpm-plugins

%files plugin-syslog
%_libdir/rpm-plugins/syslog.so

%files plugin-systemd-inhibit
%_libdir/rpm-plugins/systemd_inhibit.so

%files plugin-ima
%_libdir/rpm-plugins/ima.so

%files plugin-hdrcache
%_libdir/rpm-plugins/hdrcache.so
%endif

%files checkinstall

%files -n librpmbuild%sover
%_libdir/librpmbuild.so.*

%if_enabled rpmbuild
%files build
%_bindir/rpmbuild
%_bindir/gendiff

%_mandir/man1/gendiff.1*
%_mandir/man8/rpmbuild.8*
%_mandir/man8/rpmdeps.8*

%rpmhome/brp-*
%rpmhome/check-*
%rpmhome/rpm2cpio.sh
%rpmhome/find-lang.sh
%rpmhome/*provides*
%rpmhome/*requires*
%rpmhome/*deps*
%rpmhome/*.prov
%rpmhome/*.req
#%%{rpmhome}/config.*
%rpmhome/mkinstalldirs
%rpmhome/macros.p*
%exclude %rpmhome/fileattrs

%endif # enabled rpmbuild

%files -n python-module-rpm
%python_sitelibdir/rpm
%python_sitelibdir/rpm_python-%eggver-py2.7.egg-info

%files -n python3-module-rpm
%python3_sitelibdir/rpm
%python3_sitelibdir/rpm_python-%eggver-py%_python3_version.egg-info

%files -n librpm-devel
%_mandir/man8/rpmgraph.8*
%_bindir/rpmgraph
%_libdir/librp*[a-z].so
%_libdir/pkgconfig/rpm.pc
%rpmhome/rpm.supp
%_includedir/rpm

%changelog
