%define testname alt-alternatives-vs-filesystem

Name: repocop-unittest-%testname
Version: 0.07
Release: alt1
BuildArch: noarch
Packager: Igor Yu. Vlasenko <viy@altlinux.org>

Summary: repocop test for alternatives/filesystem intersections.
Group: Development/Other
License: GPL or Artistic
Url: http://repocop.altlinux.org 
Requires: repocop >= 0.59
Requires: repocop-collector-altlinux-alternatives > 0.01
Requires: sqlite3


%description
Repocop integration test for alternatives/filesystem intersections.
ALT Linux specific.

%prep

%build
cat > %testname.distrotest <<'EOF'
#!/bin/sh
#--select rpm_files.pkgid, group_concat(FILENAME), group_concat(altlinux_alternatives.pkgid) from altlinux_alternatives, rpm_files WHERE ALTALTERNATIVE=FILENAME GROUP BY rpm_files.pkgid;
sqlite3 "$REPOCOP_DISTROTEST_DBDIR/altlinux-alternatives.db" <<EOSQL
attach database '$REPOCOP_DISTROTEST_DBDIR/rpm.db' as rpm;
.mode tabs
.output $REPOCOP_TEST_TMPDIR/warn
-- note: 580 is RPMFILE_DONOTUSE (1 << 2) + RPMFILE_GHOST (1 << 6) + RPMFILE_EXCLUDE (1 << 9)
select rpm_files.pkgid, FILENAME, altlinux_alternatives.pkgid from altlinux_alternatives LEFT JOIN rpm as c ON altlinux_alternatives.pkgid = c.pkgid, rpm_files LEFT JOIN rpm as d ON altlinux_alternatives.pkgid = d.pkgid WHERE ALTALTERNATIVE=FILENAME and FILEFLAG & 580 = 0 AND c.name <> d.NAME;
EOSQL
perl -ne 'chomp;@a=split /\t/;system("repocop-test-warn -k $a[0] file $a[1] is alternative in package: $a[2]")' $REPOCOP_TEST_TMPDIR/warn
rm $REPOCOP_TEST_TMPDIR/warn
EOF

%install

mkdir -p $RPM_BUILD_ROOT%_datadir/repocop/pkgtests/%testname/
%__install -m 755 %testname.distrotest $RPM_BUILD_ROOT%_datadir/repocop/pkgtests/%testname/distrotest

%files
#doc README ChangeLog
%_datadir/repocop/pkgtests/%testname

%changelog
