%define testname rpm-ext

Name: repocop-collector-%testname
Version: 0.07
Release: alt1
BuildArch: noarch
Packager: Igor Yu. Vlasenko <viy@altlinux.org>

Summary: repocop postcollector for extended rpm database.
Group: Development/Other
License: GPL or Artistic
Url: http://repocop.altlinux.org
Requires: repocop > 0.59
Requires: sqlite3


%description
Repocop postcollector creates rpm-ext database
with the following tables:
* explicit package conflicts table.

%prep

%build
cat > %testname.distrotest <<'EOF'
#!/bin/sh
#--select rpm_files.pkgid, group_concat(FILENAME), group_concat(altlinux_alternatives.pkgid) from altlinux_alternatives, rpm_files WHERE ALTALTERNATIVE=FILENAME GROUP BY rpm_files.pkgid;
rm -f "$REPOCOP_DISTROTEST_DBDIR/rpm-ext.db"
repocop-sqlite "$REPOCOP_DISTROTEST_DBDIR/rpm-ext.db" <<EOSQL
attach database '$REPOCOP_DISTROTEST_DBDIR/rpm.db' as rpm;
CREATE TABLE EXPLICIT_CONFLICT (CONFLICTER TEXT, CONFLICTEE TEXT);
-- note: asymmetric;
insert INTO EXPLICIT_CONFLICT select distinct a.pkgid, b.pkgid FROM rpm_conflicts as a, rpm_provides as b WHERE a.pkgid<>b.pkgid AND b.providename = a.conflictname;
CREATE INDEX EXPLICIT_CONFLICT_IDX_NAME ON EXPLICIT_CONFLICT(CONFLICTER);
-- 
CREATE TABLE EXPLICIT_OBSOLETE (OBSOLETER TEXT, OBSOLETEE TEXT);
-- note: asymmetric; 
-- TODO: index left join is possible if RPM will have an index on NAME
-- simple version: 
-- insert INTO EXPLICIT_OBSOLETE select distinct a.pkgid, b.pkgid FROM rpm_obsoletes as a, rpm as b WHERE a.pkgid<>b.pkgid AND b.name = a.obsoletename AND (obsoleteversion IS NULL OR obsoleteversion;
INSERT INTO EXPLICIT_OBSOLETE select distinct a.pkgid, b.pkgid FROM rpm_obsoletes as a, rpm as b WHERE a.pkgid<>b.pkgid AND b.name = a.obsoletename AND (obsoleteversion='' OR obsoleteversion IS NULL OR rpm_compare_op_evr_e_v_r(obsoleteFLAG,obsoleteversion,epoch,version,release)>0);
CREATE INDEX EXPLICIT_OBSOLETE_IDX_NAME ON EXPLICIT_OBSOLETE(OBSOLETER);
EOSQL
#rm "$REPOCOP_TEST_TMPDIR/"*
EOF

%install
install -D -m 755 %testname.distrotest $RPM_BUILD_ROOT%_datadir/repocop/pkgcollectors/%testname/distrotest

%files
#doc README ChangeLog
%_datadir/repocop/pkgcollectors/%testname

%changelog
