%define _sbindir /sbin
%define libname libreiserfsprogs

Name: reiserfsprogs
Version: 3.6.27
Release: alt1

Summary: The utilities to create Reiserfs volume
License: GPLv2 with "Anti-Plagiarism" modification
Group: System/Kernel and hardware

Url: http://git.kernel.org/?p=linux/kernel/git/jeffm/%name.git;a=summary
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Obsoletes: reiserfs-utils
Provides: reiserfs-utils = %version-%release
Conflicts: progsreiserfs < 0.3.0.5-alt3

BuildRequires: libuuid-devel libcom_err-devel libacl-devel

%description
Reiserfs is a file system using a plug-in based object oriented variant
on classical balanced tree algorithms.
This package contains utilities for create, resize, check, repair, tune, debug
Reiserfs.

%package -n %libname
Summary:  The utilities to create reiserfs volumes
Group:    System/Kernel and hardware

%description -n %libname
This package contains tools for reiserfs filesystems.
Reiserfs is a file system using a plug-in based object oriented
variant on classical balanced tree algorithms.

%package -n %{libname}-devel
Summary:  Development files for reiserfs
Group:    Development/C

%description -n %{libname}-devel
This package contains tools for reiserfs filesystems.
Reiserfs is a file system using a plug-in based object oriented
variant on classical balanced tree algorithms.


%prep
%setup
%patch -p1


%build
%add_optflags "-std=gnu89"
%autoreconf
%configure --enable-largefile
%make_build V=1


%install
%makeinstall_std
find %buildroot%_libdir -name "*.*a" -delete


%files
%doc README COPYING
%_sbindir/*
%_man8dir/*

%files -n %libname
%_libdir/*.so.*

%files -n %{libname}-devel
%_includedir/reiserfs/
%_libdir/*.so
%_libdir/pkgconfig/reiserfscore.pc

%changelog
