%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%def_enable minimal

Name: reiser4progs
Version: 1.2.1
Release: alt3
Summary: Utilities for reiser4 filesystems
License: GPLv2
Group: System/Kernel and hardware
URL: http://reiser4.sourceforge.net/

%define reiser_libver %(echo %version | cut -d . -f 1-2)

Source: %name-%version.tar
Patch1: %name-1.1.0-alt-format.patch
Patch2: %name-1.1.0-alt-linking.patch
Patch3: %name-1.2.1-alt-libaal-check-dynamic-library.patch

# Automatically added by buildreq on Wed Mar 17 2010
BuildRequires: libaal-devel libaal-minimal-devel libncurses-devel libreadline-devel libuuid-devel

%description
Utilities for manipulating reiser4 filesystems.

%package -n libreiser4
Summary: Libraries for use by reiser4 tools
Group: Development/C

%description -n libreiser4
Libraries for use by reiser4 tools.

%package -n libreiser4-devel
Summary: Development libraries and headers for developing reiser4 tools
Group: Development/C
Requires: libreiser4 = %EVR
Requires: libaal-devel

%description -n libreiser4-devel
Development libraries and headers for developing reiser4 tools.

%package -n libreiser4-minimal
Summary: Minimal utilities for reiser4 filesystem
Group: Development/C
Requires: libaal-minimal
Requires: libreiser4 = %EVR

%description -n libreiser4-minimal
Development libraries and headers for developing minimal reiser4 tools.

%package -n libreiser4-minimal-devel
Summary: Development libraries and headers for developing minimal reiser4 tools
Group: Development/C
Requires: libreiser4-minimal = %EVR
Requires: libaal-minimal-devel
Requires: libreiser4-devel = %EVR

%description -n libreiser4-minimal-devel
Development libraries and headers for developing minimal reiser4 tools.

%prep
%setup
%patch1 -p2
%patch2 -p2
%patch3 -p2
sed -i -r '/^[[:blank:]]+\.\/run-ldconfig/d' Makefile.{am,in}

%build
%autoreconf
%configure \
	--sbindir=/sbin \
	--libdir=/%_lib \
%if_enabled minimal
	--enable-libminimal \
	--disable-fnv1-hash \
	--disable-rupasov-hash \
	--disable-tea-hash \
	--disable-deg-hash \
	--disable-short-keys \
	--disable-special \
	--disable-dot_o_fibre \
	--disable-ext_3_fibre \
	--disable-lexic_fibre \
%endif
	--with-readline \
	--disable-static \
	%nil

# Hackish way to fix underlinking in 1.0.7:
subst 's@LDFLAGS =@LDFLAGS = ../libmisc/.libs/libmisc.a -luuid@' libreiser4/Makefile

# We need these to be built before build in libreiser4 directory:
for d in lib{aux,misc}; do
	%make_build -C $d
done
%make_build

%install
install -d -m 0755 %buildroot/%_libdir
%makeinstall_std

pushd %buildroot
for f in ./%_lib/*.so; do
	v=$(objdump -p "$f" | sed -n '/^[[:blank:]]*SONAME[[:blank:]]/s/^.*[[:blank:]]\(lib.*$\)/\1/p')
	[ -n "$v" ] && ln -sf $(relative /%_lib/"$v" /%_prefix/"$f") "$f"
done
popd

mv %buildroot{/%_lib/*.so,%_libdir/}

%files
/sbin/*
%_man8dir/*

%files -n libreiser4
/%_lib/libreiser4-%{reiser_libver}.so.*
/%_lib/librepair-%{reiser_libver}.so.*

%files -n libreiser4-devel
%_includedir/reiser4
%_includedir/repair
%_datadir/aclocal/libreiser4.m4
%_libdir/libreiser4.so
%_libdir/librepair.so

%if_enabled minimal
%files -n libreiser4-minimal
/%_lib/libreiser4-minimal-%{reiser_libver}.so.*

%files -n libreiser4-minimal-devel
%_libdir/libreiser4-minimal.so
%endif

%changelog
