%define _libexecdir %_prefix/libexec
%def_enable drm
%def_enable randr
%def_enable vidmode
%def_enable gui

Name: redshift
Version: 1.12
Release: alt1

Summary: Redshift adjusts the color temperature of your screen
Summary(ru_RU.UTF-8): Redshift изменяет температуру цвета вашего экрана для снижения утомляемости глаз
Group: Graphical desktop/GNOME
License: GPLv3+
Url: http://jonls.dk/redshift

#VCS:    https://github.com/jonls/redshift.git
#Source: https://github.com/jonls/%name/releases/download/v%version/%name-%version.tar.xz
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: geoclue2
Requires: typelib(Gtk) = 3.0

# use python3
AutoReqProv: nopython
%define __python %nil

%{?_enable_gui:BuildRequires(pre): rpm-build-python3}
BuildRequires(pre): rpm-build-gir
%{?_enable_drm:BuildRequires: libdrm-devel}
%{?_enable_randr:BuildRequires: libxcb-devel}
%{?_enable_vidmode:BuildRequires: libXxf86vm-devel libXrandr-devel}
BuildRequires: libgio-devel geoclue2-devel
BuildRequires: systemd-devel intltool libappstream-glib-devel

# libaptindicator is not package in ALT Linux
%add_typelib_req_skiplist typelib(AppIndicator3)

%description
Redshift adjusts the color temperature of your screen according to your
surroundings. This may help your eyes hurt less if you are working in
front of the screen at night. The color temperature is set according to
the position of the sun. A different color temperature is set during
night and daytime. During twilight and early morning, the color
temperature transitions smoothly from night to daytime temperature to
allow your eyes to slowly adapt.

%description -l ru_RU.UTF-8
Redshift изменяет температуру цвета экрана вашего компьютера. Это может
снизить утомляемость глаз, особенно если вы работаете за компьютером
ночью. Температура цвета устанавливается в зависимости от позиции солнца
на небе (определяется на основе географических координат) и текущего
времени суток. Изменение температуры цвета происходит плавно, давая Вашим
глазам время на адаптацию.

%prep
%setup
%patch -p1
%autoreconf

%build
%configure \
    %{subst_enable drm} \
    %{subst_enable randr} \
    %{subst_enable vidmode} \
    %{subst_enable gui}
%make_build

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%_bindir/%name
%_prefix/lib/systemd/user/%name.service
%_desktopdir/%name.desktop
%_man1dir/%name.1.*

%if_enabled gui
%_bindir/%name-gtk
%_prefix/lib/systemd/user/%name-gtk.service
%python3_sitelibdir_noarch/%{name}_gtk/
%_desktopdir/%name-gtk.desktop
%_iconsdir/hicolor/*/*/*.*
%_datadir/appdata/%name-gtk.appdata.xml
%endif

%doc DESIGN NEWS* README* redshift.conf.sample

%changelog
