#set_automake_version 1.11

%define beta %nil
%def_disable static

Name: recode
Version: 3.7.15
Release: alt1

Summary: The `recode' library converts files between character sets and usages
# COPYING:              GPLv3 text
# COPYING-LIB:          LGPLv3 text
# doc/recode.info:      OFSFDL
# doc/recode.texi:      OFSFDL
# lib/error.h:              GPLv3+
# lib/strerror-override.c:  GPLv3+
# lib/vasnprintf.c:         GPLv3+
# src/ansellat1.l:      BSD
# src/lat1asci.c:       GPLv3+
# src/merged.c:         BSD
# src/recode.h:         LGPLv3+
# src/ucs.c:            LGPLv3+
## Not in any binary package
# aclocal.m4:               FSFULLR
# build-aux/bootstrap.in:   MIT or GPLv3+ (bundled gnulib-modules/bootstrap)
# build-aux/compile:        GPLv2+ with exceptions
# build-aux/config.guess:   GPLv3+ with exceptions
# build-aux/config.rpath:   FSFULLR
# build-aux/config.sub:     GPLv3+ with exceptions
# build-aux/depcomp:        GPLv2+ with exceptions
# build-aux/extract-trace:  MIT or GPLv3+ (bundled gnulib-modules/bootstrap)
# build-aux/funclib.sh:     MIT or GPLv3+ (bundled gnulib-modules/bootstrap)
# build-aux/inline-source:  MIT or GPLv3+ (bundled gnulib-modules/bootstrap)
# build-aux/install-sh:     MIT
# build-aux/ltmain.sh:      GPLv2+ with exceptions and GPLv3+ with exceptions
#                           and GPLv3+
# build-aux/mdate-sh:       GPLv2+ with exceptions
# build-aux/missing:        GPLv2+ with exceptions
# build-aux/options-parser: MIT or GPLv3+ (bundled gnulib-modules/bootstrap)
# build-aux/texinfo.tex:    GPLv3+ with exceptions
# config.rpath:         FSFULLR
# configure:            FSFUL and GPLv2+ with exceptions
# doc/Makefile.am:      GPLv3+
# doc/Makefile.in:      FSFULLR and GPLv3+
# doc/texinfo.tex:      GPLv2+ with exceptions
# INSTALL:              FSFAP
# Makefile.am:          GPLv3+
# m4/gettext.m4:        FSFULLR
# m4/gnulib-cache.m4:   GPLv3+ with exceptions
# m4/libtool.m4:        GPLv2+ with exceptions and FSFUL
# m4/mbstate_t.m4:      FSFULLR
# m4/minmax.m4:         FSFULLR
# m4/ssize_t.m4:        FSFULLR
# m4/sys_stat_h.m4:     FSFULLR
# tables.py:            GPLv3+
# tests/Makefile.am:    GPLv3+
# tests/Makefile.in:    FSFULLR and GPLv3+
# tests/Recode.pyx:     GPLv3+
License:    GPLv3+ and LGPLv3+ and BSD and OFSFDL

Group: Text tools

Url: https://github.com/rrthomas/recode/
Source: %name-%version%beta.tar.gz
Patch0: recode4python.patch
Patch1: recode-3.6-debian-boolsize.patch
Patch2: recode-3.6-alt-unicode-in-docs.patch
Patch3: recode-3.6-alt-e2k.patch
Patch5: recode-3.7.1-Rename-coliding-hash-functions.patch

Patch6:      recode-3.7.13-Rename-coliding-hash-functions.patch
# https://github.com/rrthomas/recode/issues/48
Patch7:      0001-src-task.c-only-close-input-stream-when-we-opened-it.patch


Packager: Michael Shigorin <mike@altlinux.org>

Requires: lib%name = %version-%release
BuildRequires: chrpath help2man git libgpgme-devel gettext gnupg flex gcc gcc-c++ iconv

BuildRequires: python3-devel
BuildRequires: rpm-build-python3


# explicitly added texinfo for info files
BuildRequires: texinfo

Summary(ru_RU.UTF-8): Библиотека recode конвертирует файлы из разных кодировок

%description
The `recode' program is a handy front-end to the `recode' library;
it converts files between character sets and usages.

The `recode' program and library have been written by Francois Pinard.
It is an evolving package, and specifications might change in future
releases.  Option `-f' is now fairly implemented, yet not fully.

%package -n lib%name
Summary: Recode library
Group: System/Libraries

%description -n lib%name
The `recode' library converts files between character sets and usages.
The library recognises or produces nearly 150 different character sets
and is able to transliterate files between almost any pair.  When
exact transliteration are not possible, it may get rid of the
offending characters or fall back on approximations.  Most RFC 1345
character sets are supported.

%package -n lib%name-devel
Summary: Headers for developing applications with `recode' library
Group: Development/Other
Requires: lib%name = %version-%release
Provides: %name-devel = %version-%release
Obsoletes: %name-devel < 3.6-alt7

%description -n lib%name-devel
This package provides the necessary development libraries and include
files to allow you to develop applications using the `recode' libraries.

%if_enabled static
%package -n lib%name-devel-static
Summary: Static library for developing applications with `recode' library
Group: Development/Other
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
This package provides the necessary development libraries and include
files to allow you to develop applications using the `recode' libraries.
%endif

%prep
%setup -n %name-%version%beta
#patch0 -p1
#patch1 -p1
#patch2 -p2
%ifarch %e2k
#patch3 -p1
%endif
#patch6 -p1
#patch7 -p1

%build
#rm acinclude.m4 m4/libtool.m4 m4/flex.m4
#sed -i 's/ad_AC_PROG_FLEX/AC_PROG_LEX/' configure.in
%autoreconf -fi

sed -i 's/--no-verify//' configure
#configure %{subst_enable static}
%configure \
    --without-dmalloc \
    --disable-gcc-warnings \
    --enable-largefile \
    --enable-nls \
    --disable-rpath \
    --enable-shared \
    --disable-static
%make_build

%install
%makeinstall
%find_lang %name
chrpath -d %buildroot%_bindir/%name

%files -f %name.lang
%_bindir/*
%_infodir/*
%_man1dir/*
%doc ABOUT-NLS AUTHORS COPYING COPYING-LIB ChangeLog INSTALL THANKS TODO

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

# TODO:
# - keep an eye on 3.7 (now in beta) and eventually 4.0 // if upstream's there
# - configure.in:18: error: automatic de-ANSI-fication support has been removed

%changelog
