%define sover 8

Name: readline
%define rl_version 8.2
%define rl_patch .10
%define srcname readline-%rl_version
Version: %rl_version%rl_patch
Release: alt1

Summary: A library for editing typed in command lines
License: GPL-3.0-or-later
Group: System/Libraries
Url: https://www.gnu.org/software/readline/

# ftp://ftp.gnu.org/gnu/readline/readline-%rl_version.tar.gz
# ftp://ftp.gnu.org/gnu/readline/readline-%rl_version-patches/
Source: readline-%version.tar

Patch: readline-%version-%release.patch

# Automatically added by buildreq on Mon Sep 02 2002
BuildRequires: libtinfo-devel makeinfo

%package -n lib%name%sover
Summary: A library for editing typed in command lines
Group: System/Libraries
Obsoletes: readline
# rpm-build issues a warning regarding this 'Provides' tag:
# warning: libreadline8 provides another subpackage: readline
# This appears to be a bug on the rpm-build side.  'readline' is the name of
# the source package, there is no corresponding binary package with this name.
Provides: readline = %EVR
Provides: libreadline = %EVR

%package -n lib%name-devel
Summary: Files needed to develop programs which use the readline library
Group: Development/C
Provides: readline-devel = %EVR
Obsoletes: readline-devel
Requires: lib%name = %EVR

%package -n lib%name-devel-static
Summary: Files needed to develop statically linked programs which use the readline library
Group: Development/C
Requires: lib%name-devel = %EVR

%description
The readline library reads a line from the terminal and returns it,
allowing the user to edit the line with standard emacs editing keys.

%description -n lib%name%sover
The readline library reads a line from the terminal and returns it,
allowing the user to edit the line with standard emacs editing keys.

%description -n lib%name-devel
The readline library reads a line from the terminal and returns it,
allowing the user to edit the line with standard emacs editing keys.

This package contains the files needed to develop programs which use
the readline library to provide an easy to use and more intuitive
command line interface for users.

%description -n lib%name-devel-static
The readline library reads a line from the terminal and returns it,
allowing the user to edit the line with standard emacs editing keys.

This package contains the files needed to develop statically linked
programs which use the readline library to provide an easy to use
and more intuitive command line interface for users.

%prep
%setup
%patch -p1
rm examples/*.tar*

%build
%global optflags_lto %optflags_lto -ffat-lto-objects

# Link with libtinfo unconditionally.
export bash_cv_termcap_lib=libtinfo

# Workaround for buildreq/strace.
%{?__buildreqs:export bash_cv_must_reinstall_sighandlers=no}

# Fix temporary file handling.
sed -i 's,/tmp/,,g' *.m4
autoconf

%configure
rm doc/*.info

%make_build all examples documentation

%install
%makeinstall_std

# Relocate shared libraries from %_libdir/ to /%_lib/.
soname=$(readlink "%buildroot%_libdir/libreadline.so")
mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/*.so; do
	t=$(readlink "$f")
	ln -snf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

# Replace libreadline.so symlink with a linker script.
rm %buildroot%_libdir/libreadline.so
cat >%buildroot%_libdir/libreadline.so <<__EOF__
/* GNU ld script */
GROUP(/%_lib/$soname AS_NEEDED(-lhistory))
__EOF__

# Relocate and fix documentation.
%define docdir %_docdir/readline
rm -rf %buildroot%docdir
mkdir -p %buildroot%docdir
cp -a README CHANGE* USAGE examples \
	%buildroot%docdir/
xz -9 %buildroot%docdir/CHANGE*
cp -p config.h posixstat.h xmalloc.h \
	%buildroot%docdir/examples/
pushd %buildroot%docdir/examples
	sed -i 's,\.\./shlib/lib\([^.]\+\)\.so,-l\1,' Makefile
	sed -i 's,^\(top_srcdir *=\).*,\1 %_includedir/readline,g;s,^\(LDFLAGS *=\).*,\1,g' Makefile
	make clean
popd

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%files -n lib%name%sover
/%_lib/*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_mandir/man?/*
%_infodir/*.info*
%_pkgconfigdir/history.pc
%_pkgconfigdir/readline.pc
%docdir

%files -n lib%name-devel-static
%_libdir/*.a

%changelog
