%def_disable snapshot

%define rev %nil
%define beta %nil
%if_enabled snapshot
%define git_distance 1175
%endif

%define xdg_name com.rawtherapee.RawTherapee

Name: rawtherapee
Version: 5.12%{?_enable_snapshot:.%git_distance}
Release: alt1.1%(echo %beta| tr - .)

Summary: THe Experimental RAw Photo Editor
License: GPL-3.0-or-later
Group: Graphics
Url: https://www.rawtherapee.com

Vcs: https://github.com/Beep6581/RawTherapee

%if_enabled snapshot
Source: rawtherapee-%version%beta.tar
%else
# use full archive not git-archive to avoid dancing around version
#Source: https://rawtherapee.com/shared/source/%name-%version.tar.xz
Source: https://github.com/Beep6581/RawTherapee/releases/download/%version%beta/%name-%version%beta.tar.xz
%endif
Patch2000: rawtherapee-e2k.patch

%define gtk_ver 3.24.3
%define tiff_ver 4.0.4
%define rsvg_ver 2.52

Requires: %name-data = %EVR
Requires: libgtk+3 >= %gtk_ver

BuildRequires(pre): rpm-macros-cmake >= 2.8.8
BuildRequires: cmake >= 2.8.8 gcc-c++ libgomp-devel
%{?_enable_snapshot:BuildRequires: git}
BuildRequires: libgtkmm3-devel >= %gtk_ver librsvg-devel >= %rsvg_ver
BuildRequires: libtiff-devel >= %tiff_ver
BuildRequires: bzlib-devel libiptcdata-devel
BuildRequires: libjpeg-devel liblcms2-devel libpng-devel libfftw3-devel
BuildRequires: libexpat-devel libpixman-devel libcanberra-gtk3-devel
BuildRequires: libexiv2-devel libharfbuzz-devel
BuildRequires: liblensfun1-devel
# since 5.11
BuildRequires: libraw-devel libjxl-devel

%description
Raw Therapee is a free RAW converter and digital photo processing software.

%package data
Summary: Arch independent files for Raw Therapee
Group: Graphics
BuildArch: noarch

%description data
This package provides noarch data needed for Raw Therapee to work.

%prep
%setup -n %name-%version%beta

# Do not install useless rtstart:
subst "s|install (PROGRAMS rtstart|\#install (PROGRAMS rtstart|" CMakeLists.txt
%ifarch %e2k
%patch2000 -p2
sed -i 's/-Werror/-Wno-error/g' CMakeLists.txt
sed -i 's/-Wall/& -Wno-sign-compare -Wno-unused/' CMakeLists.txt
sed -i 's/switch(settings->denoiselabgamma)/if(1) &/' rtengine/color.cc
sed -i -E ":a;/\\\\$/{N;ba};\
/^[[:space:]]*# *pragma omp .*[[:space:])](num_threads|if *|schedule)\(/{s/#/for(long &/;\
s/(#.*num_threads\()([^()]*)\)/_xxxn=\\2,\\1_xxxn)/;\
s/(#.*if *\()([^()]*)\)/_xxxi=\\2,\\1_xxxi)/;\
s/(#.*schedule\([^()]*, *)([^()]*)\)/_xxxs=\\2,\\1_xxxs)/;\
s/#/_xxxc=1;_xxxc;_xxxc=0)\n&/}" \
	rtengine/{cplx_wavelet_level.h,*.cc} rtgui/*.cc
sed -i 's/default(none)//' rtengine/libraw/src/preprocessing/raw2image.cpp
%endif

%build
%define _optlevel 3
%define optflags -O%_optlevel -g
%add_optflags %(getconf LFS_CFLAGS)
%cmake -DCMAKE_BUILD_TYPE:STRING="Release" \
    %{?_disable_snapshot:-DCACHE_NAME_SUFFIX=""} \
    %{?_enable_snapshot:-DCACHE_NAME_SUFFIX="5-dev"}
%cmake_build

%install
%cmake_install

rm -f %buildroot/%_datadir/doc/rawtherapee/*.txt

%files
%_bindir/%name
%_bindir/%name-cli
%doc AUTHORS.txt LICENSE RELEASE_NOTES.txt

%files data
%_desktopdir/%name.desktop
%_datadir/%name/
%_iconsdir/hicolor/*/apps/*
%_man1dir/%name.1.*
%_datadir/metainfo/%xdg_name.appdata.xml

%changelog
