%def_with emacs

Name: ratpoison
Version: 1.4.9
Release: alt3

Group: Graphical desktop/Other
Summary: Simple window manager with no fat library dependencies
License: GPLv2+
Url: http://www.nongnu.org/ratpoison
# VCS: https://git.savannah.nongnu.org/git/ratpoison.git

Source0: %name-%version.tar
Source1: ratpoison-64.xpm
Source2: ratpoison-16.png

# Automatically added by buildreq on Thu Apr 08 2010 (-bi)
# optimized out: elfutils fontconfig fontconfig-devel glibc-pthread libX11-devel libXrender-devel libfreetype-devel pkg-config xorg-inputproto-devel xorg-renderproto-devel xorg-xextproto-devel xorg-xproto-devel
BuildRequires: imake libICE-devel libXext-devel libXft-devel libXi-devel libXinerama-devel libXtst-devel libreadline-devel xorg-cf-files
BuildRequires: libXrandr-devel
# explicitly added texinfo for info files
BuildRequires: texinfo
%if_with emacs
BuildRequires: emacs-devel emacs-common
%endif

%description
ratpoison is a simple Window Manager with no fat library
dependencies, no fancy graphics, no window decorations,
and no flashy wank. It is largely modelled after GNU
Screen which has done wonders in virtual terminal market.

All interaction with the window manager is done through
keystrokes. ratpoison has a prefix map to minimize the
key clobbering that cripples EMACS and other quality
pieces of software.

%if_with emacs
%package -n emacs-%name
Summary: The Emacs Lisp bytecode included in %name
Group: Development/Other
Requires: %name = %EVR
Requires: emacs-common

%description -n emacs-%name
%name-el contains the Emacs Lisp bytecode
included in the %name package, that extends the Emacs editor.

You need to install %name-el only if you intend to modify any of the
%name code or see some Lisp examples.

%package -n emacs-%name-el
Summary: The Emacs Lisp sources for bytecode included in %name
Group: Development/Other
Requires: emacs-%name = %EVR

%description -n emacs-%name-el
%name-el contains the Emacs Lisp sources for the bytecode
included in the %name package, that extends the Emacs editor.

You need to install %name-el only if you intend to modify any of the
%name code or see some Lisp examples.
%endif

%prep
%setup

%build
%autoreconf
%configure \
	--prefix=%prefix \
	--infodir=%_infodir \
	--mandir=%_mandir \
	--with-x

%make_build
%if_with emacs
%byte_compile_file contrib/%name.el
%endif

%install
%makeinstall_std

# startfile
cat > %buildroot/%_bindir/start%name << EOF
#!/bin/sh
exec %_bindir/%name
EOF
chmod 755 %buildroot/%_bindir/start%name

# session file
install -d %buildroot/%_sysconfdir/X11/wmsession.d
install -D -m 644 %SOURCE1 %buildroot%_iconsdir/hicolor/64x64/apps/ratpoison.xpm
install -D -m 644 %SOURCE2 %buildroot%_iconsdir/hicolor/16x16/apps/ratpoison.png
cat > %buildroot/%_sysconfdir/X11/wmsession.d/16%name << EOF
NAME=%name
ICON=%_iconsdir/hicolor/64x64/apps/ratpoison.xpm
EXEC=%_bindir/start%name
DESC=%name window manager
SCRIPT:
exec %_bindir/start%name
EOF
install -d %buildroot/%_datadir/xsessions
cat > %buildroot%_datadir/xsessions/%name.desktop << EOF
[Desktop Entry]
Name=%name
Comment=%name window manager
Icon=%name
Exec=start%name
Type=Application
EOF

%if_with emacs
install -pDm644 contrib/%name.elc %buildroot%_emacslispdir/%name.elc
%endif

%files
%config(noreplace) %_sysconfdir/X11/wmsession.d/16%name
%_defaultdocdir/*
%_bindir/*
%_datadir/%name
%_man1dir/%name.1*
%_infodir/%name.info*
%_miconsdir/ratpoison.png
%_iconsdir/hicolor/64x64/apps/ratpoison.xpm
%_datadir/xsessions/%name.desktop
%doc README TODO AUTHORS NEWS ChangeLog doc/sample.ratpoisonrc doc/ipaq.ratpoisonrc

%if_with emacs
%files -n emacs-%name-el
%_emacslispdir/%name.el

%files -n emacs-%name
%_emacslispdir/%name.elc
%endif

%changelog
