%define optflags_lto %nil
%define gcc_ver 13

Name: radeon-memory-visualizer
Version: 1.12
Release: alt0.1
License: MIT
Summary: Software tool to analyze video memory usage on AMD Radeon GPUs
Url: https://github.com/GPUOpen-Tools/radeon_memory_visualizer
Group: System/Configuration/Hardware

Source: %name-%version.tar
Patch: %name-%version-%release.patch
Patch1: qt_common-qt6-deprecated-fix.patch
Patch2: rmv-remove-libicudata70.patch

BuildRequires(pre): cmake
BuildRequires: gcc%{gcc_ver}-c++ qt6-svg-devel qt6-wayland-devel python3-module-sphinx-sphinx-build-symlink
BuildRequires: python3-module-sphinx_rtd_theme chrpath

Requires: %name-data = %EVR

# doesn't compile on 32-bit
ExclusiveArch: aarch64 x86_64 ppc64le loongarch64

%description
The Radeon Memory Visualizer (RMV) is a software tool that will allow users to
analyze video memory usage on AMD Radeon GPUs. RMV will reveal detailed
information regarding an application's video memory consumption and access
patterns. This will allow users to understand how memory is being leveraged and
open the door to new optimization opportunities.

%package data
Summary: help and samples for RMV
Group: System/Configuration/Hardware
BuildArch: noarch

%description data
Samples and help files for Radeon Memory Visualizer (RMV).

%prep
%setup
%autopatch -p1

%build
export GCC_VERSION=%{gcc_ver}
%cmake \
	-DCMAKE_BUILD_TYPE=RelWithDebInfo \
	-DDISABLE_EXTRA_QT_LIB_DEPLOY=ON
%cmake_build
pushd external/radeon_developer_panel/docs
/usr/bin/sphinx-build ./source %_builddir/%name-%version/%_cmake__builddir/docs/help/rdp/html/. -t public
popd

%install
pushd %_cmake__builddir
mkdir -p %buildroot{%_bindir,%_datadir/rmv}
install -m755 frontend/RadeonMemoryVisualizer %buildroot%_bindir/
cp -ar {docs,samples} %buildroot%_datadir/rmv/
cp -ar help %buildroot%_datadir/rmv/docs/
popd
install -m644 LICENSE.txt %buildroot%_datadir/rmv/

%files
%doc LICENSE.txt NOTICES.txt README.md RELEASE_NOTES.txt
%_bindir/RadeonMemoryVisualizer

%files data
%dir %_datadir/rmv
%_datadir/rmv/*

%changelog
