# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: qucs-s
Version: 25.2.0
Release: alt2

Summary: Circuit simulator
License: GPL-2.0-or-later
Group: Education
URL: https://github.com/ra3xdh/qucs_s
VCS: https://github.com/ra3xdh/qucs_s

Source: %name-%version.tar
Patch: %name-%version-%release.patch

AutoProv: nopython3

Buildrequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: flex
BuildRequires: qt6-base-devel
BuildRequires: qt6-tools-devel
BuildRequires: qt6-svg-devel
BuildRequires: qt6-charts-devel
BuildRequires: rpm-build-python3
Requires: qucsator_rf >= 1.0.7
Requires: ngspice >= 45
# https://bugzilla.altlinux.org/47318
Requires: qt6-svg
%add_python3_path %_datadir/%name/python

Obsoletes: qucs-s-data =< %EVR
Provides: qucs-s-data = %EVR

%description
Qucs-S is spin-off of Qucs.

Qucs is an integrated circuit simulator which means you are
able to setup a circuit with a graphical user interface (GUI)
and simulate the large-signal, small-signal and noise
behaviour of the circuit. After that simulation has finished
you can view the simulation results on a presentation page or
window.

%prep
%setup
%patch -p1

%build
%cmake -DCMAKE_BUILD_TYPE=Release -DUPDATE_TRANSLATIONS=On
%cmake_build

%install
%cmake_install

for l in $(find %buildroot%_datadir/%name/lang -name \*.qm); do
    echo -n $l | sed 's,.*_\(.*\)\.qm,%%lang\(\1\) ,'
    echo $l | sed "s,%buildroot,,"
done > %name.lang

%files
%doc AUTHORS COPYING NEWS.md README.md README_qucs
%_bindir/*
%_desktopdir/*
%_datadir/%name
%_datadir/metainfo/io.github.ra3xdh.qucs_s.metainfo.xml
%_iconsdir/hicolor/*/apps/*
%_man1dir/*

%changelog
