%define _unpackaged_files_terminate_build 1

Name: qtox
Version: 1.18.3
Release: alt1

Summary: Powerful Tox client that follows the Tox design guidelines

License: GPL-3.0-or-later
Group: Networking/Instant messaging
Url: https://qtox.github.io/
VCS: https://github.com/TokTok/qTox.git

Source: %name-%version.tar

BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: libavdevice-devel
BuildRequires: libavformat-devel
BuildRequires: libexif-devel
BuildRequires: libfilteraudio-devel
BuildRequires: libopenal-devel
BuildRequires: libqrencode-devel
BuildRequires: libsodium-devel
BuildRequires: libsqlcipher-devel
BuildRequires: libswresample-devel
BuildRequires: libswscale-devel
BuildRequires: libXScrnSaver-devel
BuildRequires: qt6-base-devel
BuildRequires: qt6-svg-devel
BuildRequires: qt6-tools-devel
BuildRequires: toxcore-devel

%description
Powerful Tox Qt6 client that follows the Tox design guidelines.

%prep
%setup

%build
%add_optflags -fpermissive
%if_with ffmpeg_static
export PKG_CONFIG_PATH=%_libdir/ffmpeg-static/%_lib/pkgconfig/
%endif
%cmake_insource
%make_build VERBOSE=1

%install
%makeinstall_std

%files
%_bindir/%name
%_desktopdir/io.github.qtox.qTox.desktop
%_datadir/metainfo/io.github.qtox.qTox.appdata.xml
%_iconsdir/hicolor/*/apps/*

%changelog
