%define _unpackaged_files_terminate_build 1

%def_without check
%def_without docs

Name: qtile
Version: 0.33.0
Release: alt1

Summary: A full-featured, hackable tiling window manager written and configured in Python
License: MIT
Group: Graphical desktop/Other

VCS: https://github.com/qtile/qtile
Url: http://www.qtile.org/
Source: %name-%version.tar
Patch0: %name-%version-alt.patch

Requires: python3-module-pywlroots >= 0.17.0
Requires: python3-module-cairocffi >= 1.6.0
Requires: python3-module-xcffib >= 1.4.0

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-cairocffi
BuildRequires: python3-module-cffi
BuildRequires: python3-module-dbus-fast
BuildRequires: python3-module-setuptools_scm
BuildRequires: python3-module-xcffib
BuildRequires: python3-module-xkbcommon
BuildRequires: libxcbutil-icccm-devel
BuildRequires: libcairo-devel
BuildRequires: libpango-devel
BuildRequires: libXcursor-devel
BuildRequires: libinput-devel
BuildRequires: libxkbcommon-devel
BuildRequires: libdrm-devel

# wlroots is poorly maintained, using vendored headers from python3-module-pywlroots
# See: https://bugzilla.altlinux.org/54843
# See: https://lists.altlinux.org/pipermail/devel/2025-June/219307.html
BuildRequires: libwayland-server-devel
BuildRequires: libpixman-devel
BuildRequires: python3-module-pywlroots
%global libwlroots_file libwlroots.so.12

%if_with check
BuildRequires: python3-module-pygobject3
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-asyncio
BuildRequires: python3-module-pytest-cov
BuildRequires: python3-modules-curses
BuildRequires: python3-module-mypy
BuildRequires: libgtk-layer-shell
BuildRequires: libgdk-pixbuf-gir
BuildRequires: libgtk+3-gir
BuildRequires: ImageMagick
BuildRequires: xorg-xephyr
BuildRequires: xorg-xvfb
BuildRequires: notify-send
BuildRequires: dbus-tools-gui
BuildRequires: /proc
%endif

%if_with docs
BuildRequires: graphviz
BuildRequires: libgdk-pixbuf
BuildRequires: pytest3
BuildRequires: python3-module-sphinx-sphinx-build-symlink
BuildRequires: python3-module-sphinx_rtd_theme
BuildRequires: python3-module-sphinxcontrib-seqdiag
BuildRequires: python3-module-webcolors
BuildRequires: python3-module-numpydoc
%endif

%description
%summary

%prep
%setup
%patch0 -p1

sed -i -e 's/pytest/pytest3/' docs/Makefile

# pyproject.toml backward compatibility with old setuptools
setuptools_version="$(python3 -c 'import setuptools; print(setuptools.__version__)')"
if [ "$(rpmvercmp "$setuptools_version" 77.0.3)" = -1 ]; then
    sed -i.orig -e '/license-files/d' \
        -e 's/^\(license = \)\(".*"\)$/\1{text = \2}/' ./pyproject.toml
fi

sed -i -e "/libraries=/ s/wlroots/:%libwlroots_file/" \
    ./libqtile/backend/wayland/cffi/build.py

%build
export CFLAGS="%optflags -I %python3_sitelibdir/wlroots/include"
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
export CFFI_TMPDIR=$(mktemp -d -t cffi_tempidr.XXXXXXXXX)
PYTHONPATH="$PWD" ./scripts/ffibuild -v

%pyproject_build

%if_with docs
pushd docs
make html
popd
%endif

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_install

# A workaround to run qtile from SDDM
cat > %buildroot%_bindir/qtile-start <<EOF
#!/bin/sh -efu

%_bindir/qtile start
EOF
chmod 755 %buildroot%_bindir/qtile-start
sed -i -e 's|^Exec=.*|Exec=%_bindir/qtile-start|' resources/qtile.desktop

install -Dm 644 resources/qtile.desktop -t %buildroot%_datadir/xsessions/
install -Dm 644 resources/qtile-wayland.desktop -t %buildroot%_datadir/wayland-sessions/

# hack to drop .abi3 from binaries
find %buildroot -name '*.abi3*' -exec rename '.abi3' '' {} \;

%check
%tox_check_pyproject

%files
%if_with docs
%doc docs/_build/html
%endif
%doc LICENSE README.rst libqtile/resources/default_config.py
%_bindir/qtile
%_bindir/qtile-start
%python3_sitelibdir/libqtile
%python3_sitelibdir/%{pyproject_distinfo qtile}
%_datadir/xsessions/qtile.desktop
%_datadir/wayland-sessions/qtile-wayland.desktop

%changelog
