%def_with check

%define soname 30
Summary: Command-line tools and library for transforming PDF files
Name: qpdf
Version: 12.2.0
Release: alt1
License: Apache-2.0
Group: System/Base
Url: https://github.com/qpdf/qpdf
VCS: https://github.com/qpdf/qpdf
Source0: %name-%version.tar
Source1: qpdf.watch
Patch0: %name-%version-%release.patch

BuildRequires: zlib-devel xml-utils xsltproc docbook-style-xsl
BuildRequires: python3-module-sphinx-sphinx-build-symlink python3(sphinx_rtd_theme)
BuildRequires: pcre-devel
BuildRequires: libjpeg-devel
BuildRequires: perl-base
BuildRequires: libgnutls-devel
BuildRequires: gcc-c++
BuildRequires: cmake ctest

%if_with check
# for testing
BuildRequires: perl(Digest/SHA.pm)
BuildRequires: /usr/bin/gs
BuildRequires: /usr/bin/tiffcmp
%endif

Requires: libqpdf%soname = %EVR

%package -n libqpdf%soname
Summary: QPDF library for transforming PDF files
Group: System/Libraries

%package -n libqpdf-devel
Summary: Development files for QPDF library
Group: Development/C
Requires: libqpdf%soname = %EVR

%description
QPDF is a command-line program that does structural, content-preserving
transformations on PDF files. It could have been called something
like pdf-to-pdf. It includes support for merging and splitting PDFs
and to manipulate the list of pages in a PDF file. It is not a PDF viewer
or a program capable of converting PDF into other formats.

%description -n libqpdf%soname
QPDF is a C++ library that inspect and manipulate the structure of PDF files.
It can encrypt and linearize files, expose the internals of a PDF file,
and do many other operations useful to PDF developers.

%description -n libqpdf-devel
Header files and libraries necessary
for developing programs using the QPDF library.

%prep
%setup
%patch0 -p1

%build
%cmake -DBUILD_STATIC_LIBS=0 \
       -DREQUIRE_CRYPTO_GNUTLS=1 \
       -DUSE_IMPLICIT_CRYPTO=0 \
       -DSHOW_FAILED_TEST_OUTPUT=1 \
       -DINSTALL_EXAMPLES=0 \
       -DINSTALL_CMAKE_PACKAGE=0
%cmake_build

%install
%cmake_install
rm -rf %buildroot%_docdir/qpdf

%check
make test -C %_target_platform


%files
%_bindir/fix-qdf
%_bindir/qpdf
%_bindir/zlib-flate
%_mandir/man1/*

%files -n libqpdf%soname
%doc README.md
%_libdir/libqpdf*.so.%{soname}*

%files -n libqpdf-devel
%doc examples/*.cc examples/*.c TODO.md ChangeLog
%_includedir/*
%_libdir/libqpdf*.so
%_libdir/pkgconfig/libqpdf.pc

%changelog
