%def_disable snapshot
%def_enable qt6
# enable/disable JACK version support
%def_enable jack_version
%def_enable portaudio

%define rdn_name org.rncbc.qjackctl

Name: qjackctl
Version: 1.0.4
Release: alt1

Summary: Qjackctl is a programm to control the JACK sound server daemon
Summary(ru_RU.UTF-8): Qjackctl -- это программа для контроля над демоном JACK-сервера
Group: Sound
License: GPL-2.0-or-later
Url: https://%name.sourceforge.net

Vcs: https://github.com/rncbc/qjackctl.git

%if_enabled snapshot
Source: %name-%cvsdate.tar
%else
Source: https://prdownloads.sourceforge.net/%name/%name-%version.tar.gz
%endif

Requires: jackd

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake gcc-c++
BuildRequires: libalsa-devel
BuildRequires: pkgconfig(jack)
%{?_enable_portaudio:BuildRequires: pkgconfig(portaudio-2.0)}
%if_enabled qt6
BuildRequires: qt6-base-devel qt6-tools-devel qt6-svg-devel
%else
BuildRequires: qt5-base-devel qt5-x11extras-devel qt5-tools-devel
%endif

%description
Qjackctl -- is an easy to use GUI to low-latency JACK audio server. You
can change options of starting JACK, assign scripts to be executed on
start/stop of the server, connect/disconnect loaded JACK clients and
route MIDI inputs'outputs.

%description -l ru_RU.UTF-8
Qjackctl -- это удобная программа с графическим интерфейсом для
управления звуковым сервером JACK. С её помощью можно изменять параметры
запуска сервера, указывать сценарии, запускаемые после старта сервера, а
также коммутировать звуковые и MIDI входы и выходы подключенных
JACK-клиентов.

%prep
%setup -n %name-%version
sed -i 's/JACK_LIBDIR/JACK_LIBRARY_DIRS/' CMakeLists.txt

%build
%add_optflags %(getconf LFS_CFLAGS) %(pkg-config --libs jack)
%cmake \
    %{?_enable_jack_version:-DCONFIG_JACK_VERSION=ON} \
    %{?_disable_portaudio:-DCONFIG_PORTAUDIO=OFF} \
%nil
%cmake_build

%install
%cmake_install

%find_lang --with-qt --with-man --all-name --output=%name.lang %name

%files -f %name.lang
%_bindir/%name
%_datadir/applications/*
%dir %_datadir/%name
%dir %_datadir/%name/translations
%_datadir/%name/palette/
%_iconsdir/hicolor/*/*/*.*
%_man1dir/*
%_datadir/metainfo/%rdn_name.metainfo.xml
%doc ChangeLog README

%changelog
