%define _unpackaged_files_terminate_build 1
# WARNING: Rebuild QGIS whenever a new version of GRASS is shipped! Even though the soname might stay the same, it won't work anymore.
# http://hub.qgis.org/issues/5274
%define grass_version 8.4.1
%def_enable grass
%def_enable python
%def_enable devel
%def_enable server

%ifarch %qt5_qtwebengine_arches
%def_enable qt5_qtwebengine
%else
%def_disable qt5_qtwebengine
%endif

Name:    qgis
Version: 3.44.4
Release: alt1

Summary: A user friendly Open Source Geographic Information System
License: GPL-3.0+ with exceptions
Group:   Sciences/Geosciences
Url:     http://qgis.org/

Packager: Andrey Cherepanov <cas@altlinux.org>

Source: %name-%version.tar
Source3: qgis-server-httpd.conf
Source4: qgis-server-README
Source5: qgis.xml

Patch1: qgis-serverprefix.patch
Patch2: qgis-no-politics.patch
Patch3: qgis-alt-python3-libpath.patch
Patch4: qgis-alt-remove-external-developers-map.patch
Patch2000: qgis-e2k.patch

# Fix unresolved symbols in grass based libs
%set_verify_elf_method unresolved=relaxed

# Set proper libexec directory
%define _libexecdir %prefix/libexec

Conflicts: qgis

ExcludeArch: armh ppc64le %ix86

# TODO: Pyspatialite is included if you use the bundled libspatialite.
# Some plug-ins need it.
# The license is not totally clear, see:
# http://code.google.com/p/pyspatialite/issues/detail?id=3
# It also is sort of a fork of pysqlite, which is not elegant.

BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-ninja
BuildRequires(pre): rpm-macros-qt5-webengine
BuildRequires: gcc-c++
BuildRequires: desktop-file-utils
BuildRequires: flex bison
%if_enabled grass
BuildRequires: grass-devel = %grass_version
%endif
BuildRequires: gzip
BuildRequires: libexpat-devel
BuildRequires: libfcgi-devel
BuildRequires: libgdal-devel
BuildRequires: libgeos-devel
BuildRequires: libgsl-devel
BuildRequires: libproj-devel
BuildRequires: libqca-qt5-devel
BuildRequires: libqscintilla2-qt5-devel
BuildRequires: libspatialite-devel
BuildRequires: libsqlite3-devel
BuildRequires: libzip-devel
BuildRequires: postgresql-devel
%if_enabled python
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-PyQt5-devel
BuildRequires: python3-module-PyQt-builder
BuildRequires: python3-module-nose2
BuildRequires: python3-module-qscintilla2-qt5-devel
BuildRequires: python3-module-sip6
BuildRequires: python3-module-OWSLib
%endif
BuildRequires: qt5-base-devel
BuildRequires: qt5-3d-devel
BuildRequires: qt5-location-devel
BuildRequires: qt5-multimedia-devel
BuildRequires: qt5-svg-devel
BuildRequires: qt5-tools-devel
BuildRequires: qt5-tools-devel-static
BuildRequires: qt5-webkit-devel
%if_enabled qt5_qtwebengine
BuildRequires: qt5-webengine-devel
%endif
BuildRequires: libqtkeychain-qt5-devel
BuildRequires: qt5-xmlpatterns-devel
BuildRequires: qt5-serialport-devel
BuildRequires: spatialindex-devel
BuildRequires: libexiv2-devel
BuildRequires: txt2tags
BuildRequires: libqwt6-qt5-devel
BuildRequires: libprotobuf-devel
BuildRequires: libprotobuf-lite-devel
BuildRequires: protobuf-compiler
BuildRequires: ocl-icd-devel
BuildRequires: libhdf5-devel
BuildRequires: libnetcdf-devel
BuildRequires: libxml2-devel
BuildRequires: /proc
BuildRequires: libzstd-devel
BuildRequires: libpdal-devel
BuildRequires: pdal
BuildRequires: libdraco-devel
BuildRequires: libtiff-devel

#Requires: libqt4-sql-sqlite
Requires: qca-qt5-ossl
Requires: gpsbabel
Requires: libqwt6-qt5

Provides: qgis3 = %EVR
Obsoletes: qgis3 < %EVR

# We don't want to provide private Python extension libs
%add_findprov_skiplist %%python_sitelibdir/qgis/*.so 
%add_python3_path %_datadir/qgis/python
%filter_from_requires /^python3(processing.core.GeoAlgorithm)/d
%add_python3_req_skip PyQt5.QtWebKit PyQt5.QtWebKitWidgets

%description
Geographic Information System (GIS) manages, analyzes, and displays
databases of geographic information. Quantum GIS (QGIS) supports shape
file viewing and editing, spatial data storage with PostgreSQL/PostGIS,
projection on-the-fly, map composition, and a number of other features
via a plugin interface. QGIS also supports display of various
geo-referenced raster and Digital Elevation Model (DEM) formats
including GeoTIFF, Arc/Info ASCII Grid, and USGS ASCII DEM.

%package devel
Summary: Development Libraries for the Quantum GIS
Group: Development/C
Requires: %name = %version-%release
Provides: qgis3-devel = %EVR
Obsoletes: qgis3-devel < %EVR

%description devel
Development packages for Quantum GIS including the C header files.

%package grass 
Summary: GRASS Support Libraries for Quantum GIS
Group: Sciences/Geosciences
Requires: %name = %version-%release
Requires: grass
Provides: qgis3-grass = %EVR
Obsoletes: qgis3-grass < %EVR
  
%description grass
GRASS plugin for Quantum GIS required to interface with the GRASS
system.

%package python 
Summary: Python integration and plug-ins for Quantum GIS
Group: Sciences/Geosciences
Requires: %name = %version-%release
Requires: python3-module-gdal
Requires: python3-module-qscintilla2-qt5
Provides: qgis3-python = %EVR
Obsoletes: qgis3-python < %EVR

%description python
Python integration and plug-ins for Quantum GIS.

%package server 
Summary: FCGI based OGC web map server
Group: Sciences/Geosciences
Provides:  %name-mapserver = %version-%release
Obsoletes: %name-mapserver < %version-%release
Requires: %name = %version-%release
Requires: libfcgi
Provides: qgis3-server = %EVR
Obsoletes: qgis3-server < %EVR

%description server
This FastCGI OGC web map server implements OGC WMS 1.3.0 and 1.1.1.
The services are prepared as regular projects in QGIS. They're rendered
using the QGIS libraries. The server also supports SLD (Styled Layer
Descriptor) for styling. Sample configurations for Httpd and Lighttpd
are included.

Please refer to %name-server-README for details!

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%ifarch %e2k
%patch2000 -p1
%endif

# Delete bundled libs
rm -rf src/core/gps/qextserialport
rm -rf "python/ext-libs/!(CMakeLists.txt|tests)"
rm -rf src/plugins/dxf2shp_converter/
sed -i '/dxf2shp_converter/d' src/plugins/CMakeLists.txt

gzip ChangeLog

%build
%ifarch %e2k
# "error: cpio archive too big"
%define optflags_debug -g0
%endif
%add_optflags -Wno-error=return-type
CFLAGS="${CFLAGS:-%optflags}"; export CFLAGS;
CXXFLAGS="${CXXFLAGS:-%optflags}"; export CXXFLAGS;
export LD_LIBRARY_PATH=`pwd`/output/%_lib
%cmake_insource -GNinja \
    -DBUILD_SHARED_LIBS:BOOL=ON \
    -DCMAKE_SKIP_RPATH:BOOL=ON \
    -DQGIS_LIB_SUBDIR:PATH=%_lib \
    -DQGIS_MANUAL_SUBDIR:PATH=/share/man \
    -DQGIS_PLUGIN_SUBDIR:PATH=%_lib/%name \
    -DQGIS_CGIBIN_SUBDIR:PATH=%_libexecdir/%name \
    -DWITH_BINDINGS:BOOL=%{?_enable_python:ON}%{?!_enable_python:OFF} \
    -DWITH_SERVER:BOOL=%{?_enable_server:ON}%{?!_enable_server:OFF} \
%if_enabled grass
    -DWITH_GRASS=TRUE \
    -DGRASS_PREFIX8=%_libdir/grass \
%endif
%if_enabled qt5_qtwebengine
    -DWITH_QTWEBENGINE:BOOL=ON \
%else
    -DWITH_QTWEBENGINE:BOOL=OFF \
%endif
    -DBINDINGS_GLOBAL_INSTALL:BOOL=TRUE \
    -DWITH_CUSTOM_WIDGETS:BOOL=TRUE \
    -DGDAL_INCLUDE_DIR:PATH=%_includedir/gdal \
    -DGDAL_LIBRARY:PATH=%_libdir/libgdal.so \
    -DGEOS_LIBRARY:PATH=%_libdir/libgeos_c.so \
    -DQWT_INCLUDE_DIR=%_includedir/qt5/qwt \
    -DQWT_LIBRARY=%_libdir/libqwt-qt5.so \
    -DENABLE_TESTS:BOOL=FALSE \
    -DWITH_QTMOBILITY:BOOL=FALSE \
    -DLIBZIP_INCLUDE_DIR:PATH=%_includedir/libzip \
    -DLIBZIP_CONF_INCLUDE_DIR:PATH=%_libdir/libzip/include \
    -DQCA_INCLUDE_DIR:PATH=%_includedir/qt5/Qca-qt5/QtCrypto \
    -DWITH_OAUTH2_PLUGIN=OFF \
    .
%ifarch %ix86
export NPROCS=8
%endif
%ninja_build

%install
%ninja_install

# Install MIME type definitions
install -pd %buildroot%_datadir/mime/packages
install -pm0644 %SOURCE5 %buildroot%_datadir/mime/packages/%name.xml

# Install application and MIME icons
install -pd %buildroot%_datadir/pixmaps
install -pd %buildroot%_datadir/icons/hicolor/16x16/apps
install -pd %buildroot%_datadir/icons/hicolor/scalable/apps
install -pd %buildroot%_datadir/icons/hicolor/128x128/mimetypes
install -pm0644 \
        images/icons/qgis-icon-60x60.png \
	%buildroot%_datadir/pixmaps/%name.png
install -pm0644 \
	images/icons/%name-icon-16x16.png \
	%buildroot%_datadir/icons/hicolor/16x16/apps/%name.png
install -pm0644 \
	images/icons/%{name}_icon.svg \
	%buildroot%_datadir/icons/hicolor/scalable/apps/%name.svg
install -pm0644 \
	%buildroot%_datadir/%name/images/icons/%name-mime-icon.png \
	%buildroot%_datadir/icons/hicolor/128x128/mimetypes/application-x-qgis-layer-settings.png
install -pm0644 \
	%buildroot%_datadir/%name/images/icons/%name-mime-icon.png \
	%buildroot%_datadir/icons/hicolor/128x128/mimetypes/application-x-qgis-project.png

# Install basic QGIS Mapserver configuration for Apache
install -pd %buildroot%_sysconfdir/httpd/conf.d
install -pm0644 %SOURCE3 %buildroot%_sysconfdir/httpd/conf.d/qgis-server.conf

# Remove files packaged by doc
pushd %buildroot%_datadir/%name/doc
rm -f BUGS \
	CHANGELOG \
	CODING \
	COPYING \
	INSTALL \
	PROVENANCE \
	README
popd

# Install server docs
mkdir -p %buildroot%_datadir/doc/%name-server-%version
cp %SOURCE4 %SOURCE3 \
   %buildroot%_datadir/doc/%name-server-%version

%if_enabled python
# Copy test utilities form tests to plugins/processing/tests
cp tests/src/python/utilities.py %buildroot%_datadir/qgis/python/plugins/processing/tests/
%endif

%find_lang %name --with-qt
echo "%%lang(zh) /usr/share/qgis/i18n/qgis_zh-Hans.qm" >> %name.lang
echo "%%lang(zh) /usr/share/qgis/i18n/qgis_zh-Hant.qm" >> %name.lang

%if_disabled devel
rm -rf %buildroot%_datadir/%name/FindQGIS.cmake \
       %buildroot%_includedir/%name \
       %buildroot%_libdir/lib%{name}*.so \
       %buildroot%_libdir/qt5/plugins/designer/libqgis_customwidgets.so* \
       %buildroot%_datadir/doc/%name-server-%version \
       %buildroot%_sysconfdir/httpd/conf.d/%{name}-server.conf \
       %buildroot%_libexecdir/%name
%endif

%if_disabled qt5_qtwebengine
rm -rvf %buildroot%python3_sitelibdir/%name/PyQt/QtWebEngine*
sed -i '/QtWebEngine/d' %buildroot%_datadir/%name/python/qsci_apis/PyQt5.api
%endif


%files -f %name.lang
%doc BUGS COPYING Exception_to_GPL_for_Qt.txt PROVENANCE *.md ChangeLog.gz
# QGIS shows these files in the GUI
%_datadir/%name/doc
%dir %_datadir/%name/i18n/
%_libdir/lib%{name}_analysis.so.*
%_libdir/lib%{name}_app.so.*
%_libdir/lib%{name}_core.so.*
%_libdir/lib%{name}_gui.so.*
%_libdir/lib%{name}_native.so.*
%_libdir/lib%{name}_3d.so.*
%_libdir/%name
%_bindir/%name
%_bindir/%{name}_process
%doc %_man1dir/*
%dir %_datadir/%name/
%_datadir/mime/packages/%name.xml
%_datadir/pixmaps/%name.png
%_datadir/icons/hicolor/*/apps/%name.png
%_datadir/icons/hicolor/128x128/mimetypes/application-x-%name-project.png
%_datadir/icons/hicolor/128x128/mimetypes/application-x-%name-layer-settings.png
%_datadir/icons/hicolor/scalable/apps/%name.svg
%_iconsdir/hicolor/*x*/mimetypes/%{name}-*.png
%_iconsdir/hicolor/scalable/mimetypes/%{name}*.svg
%_datadir/applications/*.desktop
%_datadir/%name/images
%_datadir/%name/resources
%_datadir/%name/svg
%if_enabled server
%_libdir/lib%{name}_server.so.*
%endif
%if_enabled grass
%exclude %_libdir/libqgisgrass*.so.*
%exclude %_libdir/%name/libprovider_grass*.so
%exclude %_libdir/%name/libprovider_grassraster*.so
%exclude %_libdir/%name/grass
%endif
%_datadir/metainfo/org.qgis.qgis.appdata.xml

%if_enabled devel
%files devel
%_datadir/%name/FindQGIS.cmake
%_includedir/%name
%_libdir/lib%{name}*.so
%_libdir/qt5/plugins/designer/libqgis_customwidgets.so*
%endif

%if_enabled grass
%files grass
%_libdir/libqgisgrass*.so.*
%_libdir/%name/libprovider_grass*.so
%_libdir/%name/grass
%_datadir/%name/grass
%endif

%if_enabled python
%files python
%_libdir/libqgispython.so.*
%_datadir/%name/python
%python3_sitelibdir/%name
%python3_sitelibdir/PyQt5/uic/widget-plugins/
%endif

%if_enabled server
%files server
%doc %_datadir/doc/%name-server-%version
%config(noreplace) %_sysconfdir/httpd/conf.d/%{name}-server.conf
%_bindir/qgis_mapserver
%_libexecdir/%name
%endif

%changelog
