%define _untracked_files_terminate_build 1

%define _libexecdir %_usr/libexec

%def_with check

Name:    qbs
Version: 3.0.1
Release: alt2

Summary: Modern build tool for software projects
License: LGPL-3.0-only OR (GPL-2.0-only OR GPL-3.0-or-later) AND (LGPL-2.1-only OR LGPL-3.0-only WITH Qt-LGPL-exception-1.1) AND GPL-3.0-only WITH Qt-GPL-exception-1.0
Group:   Development/Tools 
Url: 		 https://qbs.io/
Vcs:     https://github.com/qbs/qbs.git

Source: %name-%version.tar
Patch0: 0001-fixed-i586-compatibility.patch

BuildRequires(pre): cmake rpm-macros-qt6
BuildRequires: ninja-build
BuildRequires: gcc-c++
BuildRequires: qt6-base-devel
BuildRequires: qt6-5compat-devel
BuildRequires: qt6-tools-devel

BuildRequires: python3-module-lxml
BuildRequires: python3-module-beautifulsoup4

%if_with check
BuildRequires: ctest
%endif

Provides: %name-common = %EVR
Obsoletes: %name-common < %EVR

%description
Qbs is a tool that helps simplify the build process for developing projects
across multiple platforms. Qbs can be used for any software project, regardless
of programming language, toolkit, or libraries used.
 
Qbs is an all-in-one tool that generates a build graph from a high-level
project description (like qmake or CMake) and additionally undertakes the task
of executing the commands in the low-level build graph (like make).

%package devel
Summary: Development files for %name
Group: Development/Tools
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package examples
Summary: Example projects using %name
Requires: %name = %EVR
BuildArch: noarch
Group: Development/Tools

%description examples
The %name-examples package contains example files for using %name.

%prep
%setup
%patch0 -p1

%build
export PATH="%{_qt6_bindir}:$PATH";
export QTDIR=%_qt6_prefix; 
	
%cmake \
    -GNinja \
	-DCMAKE_BUILD_TYPE=RelWithDebInfo \
	-DINSTALL_ARCHDATADIR=%_qt6_archdatadir \
	-DINSTALL_BINDIR=%_qt6_bindir \
	-DINSTALL_DATADIR=%_qt6_datadir \
	-DINSTALL_DOCDIR=%_qt6_docdir \
	-DINSTALL_EXAMPLESDIR=%_qt6_examplesdir \
	-DQT_INSTALL_EXAMPLES_SOURCES:BOOL=ON \
	-DINSTALL_INCLUDEDIR=%_qt6_headerdir \
	-DINSTALL_QMLDIR=%_qt6_qmldir \
	-DINSTALL_LIBDIR=%_qt6_libdir \
	-DINSTALL_LIBEXECDIR=%_qt6_libexecdir \
	-DINSTALL_PLUGINSDIR=%_qt6_plugindir \
	-DINSTALL_SYSCONFDIR=%_qt6_sysconfdir \
	-DINSTALL_TRANSLATIONSDIR=%_qt6_translationdir \
	-DINSTALL_MKSPECSDIR=%_qt6_mkspecsdir \
	-DQT_DISABLE_RPATH:BOOL=TRUE \
  -DQBS_LIB_INSTALL_DIR=%{_libdir} \
  -DQBS_PLUGINS_INSTALL_BASE=%{_lib} \
  -DWITH_UNIT_TESTS=ON \
  -DQBS_ENABLE_RPATH=OFF \
  -DQBS_INSTALL_QCH_DOCS=ON \
  -DQBS_DOC_INSTALL_DIR=%_qt6_docdir

%cmake_build

%install
%cmake_install
install -Dpm 0644 doc/man/qbs.1 %buildroot%_man1dir/qbs.1

#Remove python dmgbuild directory, macOS specific utilites.
rm -rfv %buildroot%_datadir/qbs/python/

#Don't package tests
rm -v %buildroot%_bindir/tst_*
rm -v %buildroot%_bindir/clang-format-test

%if_with check
%check
%ctest || :
%endif

%files
%doc *.md LICENSE.LGPLv21 LICENSE.LGPLv3 LICENSE.GPL3-EXCEPT LGPL_EXCEPTION.txt
%_bindir/%{name}*
%_libdir/%name/
%_libdir/lib%{name}*.so.*
%_datadir/%name/
%_libexecdir/%name/
%_man1dir/%name.1*
%exclude %_datadir/%name/examples

%files devel 
%_includedir/%name/
%_libdir/lib%{name}*.so

%files examples
%_datadir/%name/examples/

%changelog
