%define _unpackaged_files_terminate_build 1
%define pypi_name zope.proxy
%define ns_name zope
%define mod_name proxy

%def_with check

Name: python3-module-%pypi_name
Version: 6.1
Release: alt2
Summary: Generic Transparent Proxies
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/zope.proxy/
Vcs: http://github.com/zopefoundation/zope.proxy
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
%py3_requires zope
# setuptools(pkg_resources) is used by namespace root that is packaged
# separately at python3-module-zope
%add_pyproject_deps_runtime_filter setuptools
%pyproject_runtimedeps_metadata
# mapping from PyPI name
# https://www.altlinux.org/Management_of_Python_dependencies_sources#Mapping_project_names_to_distro_names
Provides: python3-module-%{pep503_name %pypi_name} = %EVR
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
# zope.security is optional circular tests dependency
# zope.security (runtime) => zope.proxy (check) => zope.security
%add_pyproject_deps_check_filter '%{pep503_name zope.security}$'
%pyproject_builddeps_metadata_extra test
%endif

%description
Proxies are special objects which serve as mostly-transparent wrappers
around another object, intervening in the apparent behavior of the
wrapped object only when necessary to apply the policy (e.g., access
checking, location brokering, etc.) for which the proxy is responsible.

%package devel
Summary: Development files for %pypi_name
Group: Development/Python3
Requires: %name

%description devel
This package contains development files for %pypi_name.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run -- zope-testrunner --test-path=src

%files
%doc README.*
%python3_sitelibdir/%ns_name/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/%ns_name/%mod_name/tests/
%exclude %_includedir/python3*/%{pep427_name %pypi_name}/
%exclude %python3_sitelibdir/%ns_name/%mod_name/*.h
%exclude %python3_sitelibdir/%ns_name/%mod_name/*.c

%files devel
%_includedir/python3*/%{pep427_name %pypi_name}/
%python3_sitelibdir/%ns_name/%mod_name/*.h
%python3_sitelibdir/%ns_name/%mod_name/*.c

%changelog
