%define pypi_name zope.processlifetime

%def_with check

Name: python3-module-%pypi_name
Version: 3.1
Release: alt1.1

Summary: Zope process lifetime events
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/zope.processlifetime/
Vcs: https://github.com/zopefoundation/zope.processlifetime

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-zope.testrunner
%endif

Requires: python3-module-zope.interface

%description
This package provides interfaces / implementations for events relative
to the lifetime of a server process (startup, database opening, etc.)

%package tests
Summary: Tests for zope.processlifetime
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package provides interfaces / implementations for events relative
to the lifetime of a server process (startup, database opening, etc.)

This package contains tests for zope.processlifetime.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
    %buildroot%python3_sitelibdir/
%endif

%check
%pyproject_run -- zope-testrunner --test-path=src -vc

%files
%doc *.txt *.rst
%python3_sitelibdir/zope/processlifetime/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests.*
%exclude %python3_sitelibdir/*/*/*/tests.*

%files tests
%python3_sitelibdir/*/*/tests.*
%python3_sitelibdir/*/*/*/tests.*


%changelog
