%define _unpackaged_files_terminate_build 1
%define pypi_name zope.interface
%define ns_name zope
%define mod_name interface

%def_with check

Name: python3-module-%pypi_name
Version: 7.2
Release: alt2

Summary: Zope interfaces package
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/zope.interface/
Vcs: https://github.com/zopefoundation/zope.interface
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
# setuptools(pkg_resources) is used by namespace root that is packaged
# separately at python3-module-zope
%add_pyproject_deps_runtime_filter setuptools
%pyproject_runtimedeps_metadata
# mapping from PyPI name
# https://www.altlinux.org/Management_of_Python_dependencies_sources#Mapping_project_names_to_distro_names
Provides: python3-module-%{pep503_name %pypi_name} = %EVR
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra test
%endif

%description
This is a separate distribution of the %pypi_name package used in
Zope 3, along with the packages it depends on.

%package tests
Summary: Tests for %pypi_name
Group: Development/Python3
Requires: %name = %EVR
%py3_requires zope.event

%description tests
This package contains tests for %pypi_name.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install

%check
# see .github/workflows/tests.yml
# upstream hacks a lot to make tests pass, so do we to not dependent on
# zope.testrunner (circular dependency).
# test discovery for namespace packages:
# https://docs.python.org/3/library/unittest.html#test-discovery
%pyproject_run -- bash -s <<-'ENDTESTS'
set -eux
site_packages="$(python -c 'import sysconfig;print(sysconfig.get_path("platlib"))')"
python -m unittest discover -s %ns_name.%mod_name -t "$site_packages"
ENDTESTS

%files
%doc README.*
%python3_sitelibdir/%ns_name/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%python3_sitelibdir/%pypi_name-%version-py%_python3_version-nspkg.pth
%exclude %python3_sitelibdir/%ns_name/%mod_name/tests/
%exclude %python3_sitelibdir/%ns_name/%mod_name/common/tests/
%exclude %python3_sitelibdir/%ns_name/%mod_name/*.c

%files tests
%python3_sitelibdir/%ns_name/%mod_name/tests/
%python3_sitelibdir/%ns_name/%mod_name/common/tests/

%changelog
