%define _unpackaged_files_terminate_build 1
%define pypi_name zope.dottedname
%define ns_name zope
%define mod_name dottedname

%def_with check

Name: python3-module-%pypi_name
Version: 6.1
Release: alt1
Summary: Resolver for Python dotted names
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/zope.dottedname
Vcs: https://github.com/zopefoundation/zope.dottedname
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
# mapping from PyPI name
# https://www.altlinux.org/Management_of_Python_dependencies_sources#Mapping_project_names_to_distro_names
Provides: python3-module-%{pep503_name %pypi_name} = %EVR
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
# switched to native namespace
Requires: python3-module-zope >= 3.3.0-alt10
# setuptools(pkg_resources) is used by namespace root which is not used in ALT
%add_pyproject_deps_runtime_filter setuptools
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra test
%pyproject_builddeps_check
%endif

%description
Resolve strings containing dotted names into the appropriate python object.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_tox tox.ini testenv
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run -- zope-testrunner --test-path=src -vc

%files
%doc README.*
%python3_sitelibdir/%ns_name/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/%ns_name/%mod_name/tests.*
%exclude %python3_sitelibdir/%ns_name/%mod_name/__pycache__/tests.*
%exclude %python3_sitelibdir/%ns_name/%mod_name/example.*
%exclude %python3_sitelibdir/%ns_name/%mod_name/__pycache__/example.*

%changelog
