%define _unpackaged_files_terminate_build 1
%define oname zope.copy

%def_with check

Name: python3-module-%oname
Version: 5.0
Release: alt2

Summary: Pluggable object copying mechanism
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/zope.copy/
Vcs: https://github.com/zopefoundation/zope.copy.git

Source: %name-%version.tar
# mapping from PyPI name
# https://www.altlinux.org/Management_of_Python_dependencies_sources#Mapping_project_names_to_distro_names
Provides: python3-module-%{pep503_name %oname} = %EVR
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-zope.testing
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-zope.location
BuildRequires: python3-module-zope.component
BuildRequires: python3-module-zodbpickle
%endif

%py3_requires zope

%description
This package provides a pluggable way to copy persistent objects. It was
once extracted from the zc.copy package to contain much less
dependencies. In fact, we only depend on zope.interface to provide
pluggability.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR
%py3_requires zope.component
%py3_requires zope.location
%py3_requires zope.testing

%description tests
This package contains tests for %oname.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install
%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif

%check
%pyproject_run -- zope-testrunner --test-path=src -vv

%files
%doc LICENSE.txt *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/zope/copy/tests

%files tests
%python3_sitelibdir/zope/copy/tests

%changelog
